/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.mail;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryMail
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryMail.class;
    private String server;
    private String destination;
    private String destinationCc;
    private String destinationBCc;
    private String replyAddress;
    private String replyName;
    private String subject;
    private boolean includeDate;
    private String contactPerson;
    private String contactPhone;
    private String comment;
    private boolean includingFiles;
    private int[] fileType;
    private boolean zipFiles;
    private String zipFilename;
    private boolean usingAuthentication;
    private String authenticationUser;
    private String authenticationPassword;
    private boolean onlySendComment;
    private boolean useHTML;
    private boolean usingSecureAuthentication;
    private boolean usePriority;
    private String port;
    private String priority;
    private String importance;
    private String sensitivity;
    private String secureConnectionType;
    private String encoding;
    private String replyToAddresses;
    public String[] embeddedimages;
    public String[] contentids;

    public JobEntryMail(String n) {
        super(n, "");
        this.allocate(0);
    }

    public JobEntryMail() {
        this("");
        this.allocate(0);
    }

    public void allocate(int nrFileTypes) {
        this.fileType = new int[nrFileTypes];
    }

    public void allocateImages(int nrImages) {
        this.embeddedimages = new String[nrImages];
        this.contentids = new String[nrImages];
    }

    @Override
    public Object clone() {
        JobEntryMail je = (JobEntryMail)super.clone();
        if (this.fileType != null) {
            int nrFileTypes = this.fileType.length;
            je.allocate(nrFileTypes);
            System.arraycopy(this.fileType, 0, je.fileType, 0, nrFileTypes);
        }
        if (this.embeddedimages != null) {
            int nrImages = this.embeddedimages.length;
            je.allocateImages(nrImages);
            System.arraycopy(this.embeddedimages, 0, je.embeddedimages, 0, nrImages);
            System.arraycopy(this.contentids, 0, je.contentids, 0, nrImages);
        }
        return je;
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(600);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"server", (String)this.server));
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination", (String)this.destination));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationCc", (String)this.destinationCc));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationBCc", (String)this.destinationBCc));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replyto", (String)this.replyAddress));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replytoname", (String)this.replyName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"subject", (String)this.subject));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_date", (boolean)this.includeDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"contact_person", (String)this.contactPerson));
        retval.append("      ").append(XMLHandler.addTagValue((String)"contact_phone", (String)this.contactPhone));
        retval.append("      ").append(XMLHandler.addTagValue((String)"comment", (String)this.comment));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_files", (boolean)this.includingFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zip_files", (boolean)this.zipFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zip_name", (String)this.zipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_auth", (boolean)this.usingAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_secure_auth", (boolean)this.usingSecureAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append("      ").append(XMLHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_comment", (boolean)this.onlySendComment));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_HTML", (boolean)this.useHTML));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_Priority", (boolean)this.usePriority));
        retval.append("      ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("      ").append(XMLHandler.addTagValue((String)"priority", (String)this.priority));
        retval.append("      ").append(XMLHandler.addTagValue((String)"importance", (String)this.importance));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sensitivity", (String)this.sensitivity));
        retval.append("      ").append(XMLHandler.addTagValue((String)"secureconnectiontype", (String)this.secureConnectionType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replyToAddresses", (String)this.replyToAddresses));
        retval.append("      <filetypes>");
        if (this.fileType != null) {
            for (i = 0; i < this.fileType.length; ++i) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"filetype", (String)ResultFile.getTypeCode((int)this.fileType[i])));
            }
        }
        retval.append("      </filetypes>");
        retval.append("      <embeddedimages>").append(Const.CR);
        if (this.embeddedimages != null) {
            for (i = 0; i < this.embeddedimages.length; ++i) {
                retval.append("        <embeddedimage>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"image_name", (String)this.embeddedimages[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"content_id", (String)this.contentids[i]));
                retval.append("        </embeddedimage>").append(Const.CR);
            }
        }
        retval.append("      </embeddedimages>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.setServer(XMLHandler.getTagValue((Node)entrynode, (String)"server"));
            this.setPort(XMLHandler.getTagValue((Node)entrynode, (String)"port"));
            this.setDestination(XMLHandler.getTagValue((Node)entrynode, (String)"destination"));
            this.setDestinationCc(XMLHandler.getTagValue((Node)entrynode, (String)"destinationCc"));
            this.setDestinationBCc(XMLHandler.getTagValue((Node)entrynode, (String)"destinationBCc"));
            this.setReplyAddress(XMLHandler.getTagValue((Node)entrynode, (String)"replyto"));
            this.setReplyName(XMLHandler.getTagValue((Node)entrynode, (String)"replytoname"));
            this.setSubject(XMLHandler.getTagValue((Node)entrynode, (String)"subject"));
            this.setIncludeDate("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_date")));
            this.setContactPerson(XMLHandler.getTagValue((Node)entrynode, (String)"contact_person"));
            this.setContactPhone(XMLHandler.getTagValue((Node)entrynode, (String)"contact_phone"));
            this.setComment(XMLHandler.getTagValue((Node)entrynode, (String)"comment"));
            this.setIncludingFiles("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_files")));
            this.setUsingAuthentication("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"use_auth")));
            this.setUsingSecureAuthentication("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"use_secure_auth")));
            this.setAuthenticationUser(XMLHandler.getTagValue((Node)entrynode, (String)"auth_user"));
            this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"auth_password")));
            this.setOnlySendComment("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_comment")));
            this.setUseHTML("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"use_HTML")));
            this.setUsePriority("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"use_Priority")));
            this.setEncoding(XMLHandler.getTagValue((Node)entrynode, (String)"encoding"));
            this.setPriority(XMLHandler.getTagValue((Node)entrynode, (String)"priority"));
            this.setImportance(XMLHandler.getTagValue((Node)entrynode, (String)"importance"));
            this.setSensitivity(XMLHandler.getTagValue((Node)entrynode, (String)"sensitivity"));
            this.setSecureConnectionType(XMLHandler.getTagValue((Node)entrynode, (String)"secureconnectiontype"));
            Node ftsnode = XMLHandler.getSubNode((Node)entrynode, (String)"filetypes");
            int nrTypes = XMLHandler.countNodes((Node)ftsnode, (String)"filetype");
            this.allocate(nrTypes);
            for (int i = 0; i < nrTypes; ++i) {
                Node ftnode = XMLHandler.getSubNodeByNr((Node)ftsnode, (String)"filetype", (int)i);
                this.fileType[i] = ResultFile.getType((String)XMLHandler.getNodeValue((Node)ftnode));
            }
            this.setZipFiles("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"zip_files")));
            this.setZipFilename(XMLHandler.getTagValue((Node)entrynode, (String)"zip_name"));
            this.setReplyToAddresses(XMLHandler.getTagValue((Node)entrynode, (String)"replyToAddresses"));
            Node images = XMLHandler.getSubNode((Node)entrynode, (String)"embeddedimages");
            int nrImages = XMLHandler.countNodes((Node)images, (String)"embeddedimage");
            this.allocateImages(nrImages);
            for (int i = 0; i < nrImages; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)images, (String)"embeddedimage", (int)i);
                this.embeddedimages[i] = XMLHandler.getTagValue((Node)fnode, (String)"image_name");
                this.contentids[i] = XMLHandler.getTagValue((Node)fnode, (String)"content_id");
            }
        }
        catch (KettleException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'mail' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.server = rep.getJobEntryAttributeString(id_jobentry, "server");
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.destination = rep.getJobEntryAttributeString(id_jobentry, "destination");
            this.destinationCc = rep.getJobEntryAttributeString(id_jobentry, "destinationCc");
            this.destinationBCc = rep.getJobEntryAttributeString(id_jobentry, "destinationBCc");
            this.replyAddress = rep.getJobEntryAttributeString(id_jobentry, "replyto");
            this.replyName = rep.getJobEntryAttributeString(id_jobentry, "replytoname");
            this.subject = rep.getJobEntryAttributeString(id_jobentry, "subject");
            this.includeDate = rep.getJobEntryAttributeBoolean(id_jobentry, "include_date");
            this.contactPerson = rep.getJobEntryAttributeString(id_jobentry, "contact_person");
            this.contactPhone = rep.getJobEntryAttributeString(id_jobentry, "contact_phone");
            this.comment = rep.getJobEntryAttributeString(id_jobentry, "comment");
            this.encoding = rep.getJobEntryAttributeString(id_jobentry, "encoding");
            this.priority = rep.getJobEntryAttributeString(id_jobentry, "priority");
            this.importance = rep.getJobEntryAttributeString(id_jobentry, "importance");
            this.sensitivity = rep.getJobEntryAttributeString(id_jobentry, "sensitivity");
            this.includingFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "include_files");
            this.usingAuthentication = rep.getJobEntryAttributeBoolean(id_jobentry, "use_auth");
            this.usingSecureAuthentication = rep.getJobEntryAttributeBoolean(id_jobentry, "use_secure_auth");
            this.authenticationUser = rep.getJobEntryAttributeString(id_jobentry, "auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "auth_password"));
            this.onlySendComment = rep.getJobEntryAttributeBoolean(id_jobentry, "only_comment");
            this.useHTML = rep.getJobEntryAttributeBoolean(id_jobentry, "use_HTML");
            this.usePriority = rep.getJobEntryAttributeBoolean(id_jobentry, "use_Priority");
            this.secureConnectionType = rep.getJobEntryAttributeString(id_jobentry, "secureconnectiontype");
            int nrTypes = rep.countNrJobEntryAttributes(id_jobentry, "file_type");
            this.allocate(nrTypes);
            for (int i = 0; i < nrTypes; ++i) {
                String typeCode = rep.getJobEntryAttributeString(id_jobentry, i, "file_type");
                this.fileType[i] = ResultFile.getType((String)typeCode);
            }
            this.zipFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "zip_files");
            this.zipFilename = rep.getJobEntryAttributeString(id_jobentry, "zip_name");
            this.replyToAddresses = rep.getJobEntryAttributeString(id_jobentry, "replyToAddresses");
            int imagesnr = rep.countNrJobEntryAttributes(id_jobentry, "embeddedimage");
            this.allocateImages(imagesnr);
            for (int a = 0; a < imagesnr; ++a) {
                this.embeddedimages[a] = rep.getJobEntryAttributeString(id_jobentry, a, "embeddedimage");
                this.contentids[a] = rep.getJobEntryAttributeString(id_jobentry, a, "contentid");
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'mail' from the repository with id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            int i;
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "server", this.server);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destination", this.destination);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destinationCc", this.destinationCc);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destinationBCc", this.destinationBCc);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "replyto", this.replyAddress);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "replytoname", this.replyName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "subject", this.subject);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_date", this.includeDate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "contact_person", this.contactPerson);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "contact_phone", this.contactPhone);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "comment", this.comment);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "encoding", this.encoding);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "priority", this.priority);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "importance", this.importance);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sensitivity", this.sensitivity);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_files", this.includingFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "use_auth", this.usingAuthentication);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "use_secure_auth", this.usingSecureAuthentication);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "auth_user", this.authenticationUser);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "auth_password", Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "only_comment", this.onlySendComment);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "use_HTML", this.useHTML);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "use_Priority", this.usePriority);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "secureconnectiontype", this.secureConnectionType);
            if (this.fileType != null) {
                for (i = 0; i < this.fileType.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "file_type", ResultFile.getTypeCode((int)this.fileType[i]));
                }
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "zip_files", this.zipFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "zip_name", this.zipFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "replyToAddresses", this.replyToAddresses);
            if (this.embeddedimages != null) {
                for (i = 0; i < this.embeddedimages.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "embeddedimage", this.embeddedimages[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "contentid", this.contentids[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'mail' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setServer(String s) {
        this.server = s;
    }

    public String getServer() {
        return this.server;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setDestinationCc(String destCc) {
        this.destinationCc = destCc;
    }

    public void setDestinationBCc(String destBCc) {
        this.destinationBCc = destBCc;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDestinationCc() {
        return this.destinationCc;
    }

    public String getDestinationBCc() {
        return this.destinationBCc;
    }

    public void setReplyAddress(String reply) {
        this.replyAddress = reply;
    }

    public String getReplyAddress() {
        return this.replyAddress;
    }

    public void setReplyName(String replyname) {
        this.replyName = replyname;
    }

    public String getReplyName() {
        return this.replyName;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setIncludeDate(boolean incl) {
        this.includeDate = incl;
    }

    public boolean getIncludeDate() {
        return this.includeDate;
    }

    public void setContactPerson(String person) {
        this.contactPerson = person;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPhone(String phone) {
        this.contactPhone = phone;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setComment(String comm) {
        this.comment = comm;
    }

    public String getComment() {
        return this.comment;
    }

    public int[] getFileType() {
        return this.fileType;
    }

    public void setFileType(int[] fileType) {
        this.fileType = fileType;
    }

    public boolean isIncludingFiles() {
        return this.includingFiles;
    }

    public void setIncludingFiles(boolean includeFiles) {
        this.includingFiles = includeFiles;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public boolean isZipFiles() {
        return this.zipFiles;
    }

    public void setZipFiles(boolean zipFiles) {
        this.zipFiles = zipFiles;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public boolean isUsingAuthentication() {
        return this.usingAuthentication;
    }

    public void setUsingAuthentication(boolean usingAuthentication) {
        this.usingAuthentication = usingAuthentication;
    }

    public boolean isOnlySendComment() {
        return this.onlySendComment;
    }

    public void setOnlySendComment(boolean onlySendComment) {
        this.onlySendComment = onlySendComment;
    }

    public boolean isUseHTML() {
        return this.useHTML;
    }

    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSecureConnectionType() {
        return this.secureConnectionType;
    }

    public void setSecureConnectionType(String secureConnectionType) {
        this.secureConnectionType = secureConnectionType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReplyToAddresses(String replyToAddresses) {
        this.replyToAddresses = replyToAddresses;
    }

    public String getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getImportance() {
        return this.importance;
    }

    public String getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(String sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result result, int nr) {
        File masterZipfile = null;
        Properties props = new Properties();
        if (Utils.isEmpty((CharSequence)this.server)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobMail.Error.HostNotSpecified", (String[])new String[0]));
            result.setNrErrors(1L);
            result.setResult(false);
            return result;
        }
        String protocol = "smtp";
        if (this.usingSecureAuthentication) {
            if (this.secureConnectionType.equals("TLS")) {
                props.put("mail.smtp.starttls.enable", "true");
            } else {
                protocol = "smtps";
                props.put("mail.smtps.quitwait", "false");
            }
        }
        props.put("mail." + protocol + ".host", this.environmentSubstitute(this.server));
        if (!Utils.isEmpty((CharSequence)this.port)) {
            props.put("mail." + protocol + ".port", this.environmentSubstitute(this.port));
        }
        if (this.log.isDebug()) {
            props.put("mail.debug", "true");
        }
        if (this.usingAuthentication) {
            props.put("mail." + protocol + ".auth", "true");
        }
        Session session = Session.getInstance((Properties)props);
        session.setDebug(this.log.isDebug());
        try {
            List resultFiles;
            JobTracker jobTracker;
            String realSubject;
            String realBCc;
            int i;
            InternetAddress[] address;
            String sender_address;
            MimeMessage msg = new MimeMessage(session);
            if (this.usePriority) {
                String priority_int = "1";
                if (this.priority.equals("low")) {
                    priority_int = "3";
                }
                if (this.priority.equals("normal")) {
                    priority_int = "2";
                }
                msg.setHeader("X-Priority", priority_int);
                msg.setHeader("Importance", this.importance);
                msg.setHeader("Sensitivity", this.sensitivity);
            }
            if (!Utils.isEmpty((CharSequence)(sender_address = this.environmentSubstitute(this.replyAddress)))) {
                String sender_name = this.environmentSubstitute(this.replyName);
                if (!Utils.isEmpty((CharSequence)sender_name)) {
                    sender_address = sender_name + '<' + sender_address + '>';
                }
            } else {
                throw new MessagingException(BaseMessages.getString(PKG, (String)"JobMail.Error.ReplyEmailNotFilled", (String[])new String[0]));
            }
            msg.setFrom((Address)new InternetAddress(sender_address));
            String reply_to_address = this.environmentSubstitute(this.replyToAddresses);
            if (!Utils.isEmpty((CharSequence)reply_to_address)) {
                String[] reply_Address_List = this.environmentSubstitute(reply_to_address).split(" ");
                address = new InternetAddress[reply_Address_List.length];
                for (i = 0; i < reply_Address_List.length; ++i) {
                    address[i] = new InternetAddress(reply_Address_List[i]);
                }
                msg.setReplyTo((Address[])address);
            }
            String[] destinations = this.environmentSubstitute(this.destination).split(" ");
            address = new InternetAddress[destinations.length];
            for (i = 0; i < destinations.length; ++i) {
                address[i] = new InternetAddress(destinations[i]);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            String realCC = this.environmentSubstitute(this.getDestinationCc());
            if (!Utils.isEmpty((CharSequence)realCC)) {
                String[] destinationsCc = realCC.split(" ");
                InternetAddress[] addressCc = new InternetAddress[destinationsCc.length];
                for (int i2 = 0; i2 < destinationsCc.length; ++i2) {
                    addressCc[i2] = new InternetAddress(destinationsCc[i2]);
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
            }
            if (!Utils.isEmpty((CharSequence)(realBCc = this.environmentSubstitute(this.getDestinationBCc())))) {
                String[] destinationsBCc = realBCc.split(" ");
                InternetAddress[] addressBCc = new InternetAddress[destinationsBCc.length];
                for (int i3 = 0; i3 < destinationsBCc.length; ++i3) {
                    addressBCc[i3] = new InternetAddress(destinationsBCc[i3]);
                }
                msg.setRecipients(Message.RecipientType.BCC, (Address[])addressBCc);
            }
            if (!Utils.isEmpty((CharSequence)(realSubject = this.environmentSubstitute(this.subject)))) {
                msg.setSubject(realSubject);
            }
            msg.setSentDate(new Date());
            StringBuilder messageText = new StringBuilder();
            String endRow = this.isUseHTML() ? "<br>" : Const.CR;
            String realComment = this.environmentSubstitute(this.comment);
            if (!Utils.isEmpty((CharSequence)realComment)) {
                messageText.append(realComment).append(Const.CR).append(Const.CR);
            }
            if (!this.onlySendComment) {
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.Job", (String[])new String[0])).append(endRow);
                messageText.append("-----").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.JobName", (String[])new String[0]) + "    : ").append(this.parentJob.getJobMeta().getName()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.JobDirectory", (String[])new String[0]) + "  : ").append(this.parentJob.getJobMeta().getRepositoryDirectory()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.JobEntry", (String[])new String[0]) + "   : ").append(this.getName()).append(endRow);
                messageText.append(Const.CR);
            }
            if (this.includeDate) {
                messageText.append(endRow).append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.MsgDate", (String[])new String[0]) + ": ").append(XMLHandler.date2string((Date)new Date())).append(endRow).append(endRow);
            }
            if (!this.onlySendComment && result != null) {
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.PreviousResult", (String[])new String[0]) + ":").append(endRow);
                messageText.append("-----------------").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.JobEntryNr", (String[])new String[0]) + "         : ").append(result.getEntryNr()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.Errors", (String[])new String[0]) + "               : ").append(result.getNrErrors()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.LinesRead", (String[])new String[0]) + "           : ").append(result.getNrLinesRead()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.LinesWritten", (String[])new String[0]) + "        : ").append(result.getNrLinesWritten()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.LinesInput", (String[])new String[0]) + "          : ").append(result.getNrLinesInput()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.LinesOutput", (String[])new String[0]) + "         : ").append(result.getNrLinesOutput()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.LinesUpdated", (String[])new String[0]) + "        : ").append(result.getNrLinesUpdated()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.LinesRejected", (String[])new String[0]) + "       : ").append(result.getNrLinesRejected()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.Status", (String[])new String[0]) + "  : ").append(result.getExitStatus()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.Result", (String[])new String[0]) + "               : ").append(result.getResult()).append(endRow);
                messageText.append(endRow);
            }
            if (!(this.onlySendComment || Utils.isEmpty((CharSequence)this.environmentSubstitute(this.contactPerson)) && Utils.isEmpty((CharSequence)this.environmentSubstitute(this.contactPhone)))) {
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.ContactInfo", (String[])new String[0]) + " :").append(endRow);
                messageText.append("---------------------").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.PersonToContact", (String[])new String[0]) + " : ").append(this.environmentSubstitute(this.contactPerson)).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.Tel", (String[])new String[0]) + "  : ").append(this.environmentSubstitute(this.contactPhone)).append(endRow);
                messageText.append(endRow);
            }
            if (!this.onlySendComment && (jobTracker = this.parentJob.getJobTracker()) != null) {
                messageText.append(BaseMessages.getString(PKG, (String)"JobMail.Log.Comment.PathToJobentry", (String[])new String[0]) + ":").append(endRow);
                messageText.append("------------------------").append(endRow);
                this.addBacktracking(jobTracker, messageText);
                if (this.isUseHTML()) {
                    messageText.replace(0, messageText.length(), messageText.toString().replace(Const.CR, endRow));
                }
            }
            MimeMultipart parts = new MimeMultipart();
            MimeBodyPart part1 = new MimeBodyPart();
            int nrattachedFiles = 0;
            if (this.useHTML) {
                if (!Utils.isEmpty((CharSequence)this.getEncoding())) {
                    part1.setContent((Object)messageText.toString(), "text/html; charset=" + this.getEncoding());
                } else {
                    part1.setContent((Object)messageText.toString(), "text/html; charset=ISO-8859-1");
                }
            } else {
                part1.setText(messageText.toString());
            }
            parts.addBodyPart((BodyPart)part1);
            if (this.includingFiles && result != null && (resultFiles = result.getResultFilesList()) != null && !resultFiles.isEmpty()) {
                boolean found;
                if (!this.zipFiles) {
                    for (Object resultFile : resultFiles) {
                        FileObject file = resultFile.getFile();
                        if (file == null || !file.exists()) continue;
                        found = false;
                        for (int i4 = 0; i4 < this.fileType.length; ++i4) {
                            if (this.fileType[i4] != resultFile.getType()) continue;
                            found = true;
                        }
                        if (!found) continue;
                        MimeBodyPart files = new MimeBodyPart();
                        URLDataSource fds = new URLDataSource(file.getURL());
                        files.setDataHandler(new DataHandler((DataSource)fds));
                        files.setFileName(file.getName().getBaseName());
                        files.addHeader("Content-Transfer-Encoding", "base64");
                        parts.addBodyPart((BodyPart)files);
                        ++nrattachedFiles;
                        this.logBasic("Added file '" + fds.getName() + "' to the mail message.");
                    }
                } else {
                    masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + this.environmentSubstitute(this.zipFilename));
                    ZipOutputStream zipOutputStream = null;
                    try {
                        zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                        for (ResultFile resultFile : resultFiles) {
                            found = false;
                            for (int i5 = 0; i5 < this.fileType.length; ++i5) {
                                if (this.fileType[i5] != resultFile.getType()) continue;
                                found = true;
                            }
                            if (!found) continue;
                            FileObject file = resultFile.getFile();
                            ZipEntry zipEntry = new ZipEntry(file.getName().getBaseName());
                            zipOutputStream.putNextEntry(zipEntry);
                            try (BufferedInputStream inputStream = new BufferedInputStream(KettleVFS.getInputStream((FileObject)file));){
                                int c;
                                while ((c = inputStream.read()) >= 0) {
                                    zipOutputStream.write(c);
                                }
                            }
                            zipOutputStream.closeEntry();
                            ++nrattachedFiles;
                            this.logBasic("Added file '" + file.getName().getURI() + "' to the mail message in a zip archive.");
                        }
                    }
                    catch (Exception e) {
                        this.logError("Error zipping attachement files into file [" + masterZipfile.getPath() + "] : " + e.toString());
                        this.logError(Const.getStackTracker((Throwable)e));
                        result.setNrErrors(1L);
                    }
                    finally {
                        if (zipOutputStream != null) {
                            try {
                                zipOutputStream.finish();
                                zipOutputStream.close();
                            }
                            catch (IOException e) {
                                this.logError("Unable to close attachement zip file archive : " + e.toString());
                                this.logError(Const.getStackTracker((Throwable)e));
                                result.setNrErrors(1L);
                            }
                        }
                    }
                    if (result.getNrErrors() == 0L) {
                        MimeBodyPart files = new MimeBodyPart();
                        FileDataSource fds = new FileDataSource(masterZipfile);
                        files.setDataHandler(new DataHandler((DataSource)fds));
                        files.setFileName(fds.getName());
                        parts.addBodyPart((BodyPart)files);
                    }
                }
            }
            int nrEmbeddedImages = 0;
            if (this.embeddedimages != null && this.embeddedimages.length > 0) {
                FileObject imageFile = null;
                for (int i6 = 0; i6 < this.embeddedimages.length; ++i6) {
                    String realImageFile = this.environmentSubstitute(this.embeddedimages[i6]);
                    String realcontenID = this.environmentSubstitute(this.contentids[i6]);
                    if (messageText.indexOf("cid:" + realcontenID) < 0) {
                        if (!this.log.isDebug()) continue;
                        this.log.logDebug("Image [" + realImageFile + "] is not used in message body!");
                        continue;
                    }
                    try {
                        boolean found = false;
                        imageFile = KettleVFS.getFileObject((String)realImageFile, (VariableSpace)this);
                        if (imageFile.exists() && imageFile.getType() == FileType.FILE) {
                            found = true;
                        } else {
                            this.log.logError("We can not find [" + realImageFile + "] or it is not a file");
                        }
                        if (!found) continue;
                        MimeBodyPart messageBodyPart = new MimeBodyPart();
                        URLDataSource fds = new URLDataSource(imageFile.getURL());
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                        messageBodyPart.setHeader("Content-ID", "<" + realcontenID + ">");
                        parts.addBodyPart((BodyPart)messageBodyPart);
                        ++nrEmbeddedImages;
                        this.log.logBasic("Image '" + fds.getName() + "' was embedded in message.");
                        continue;
                    }
                    catch (Exception e) {
                        this.log.logError("Error embedding image [" + realImageFile + "] in message : " + e.toString());
                        this.log.logError(Const.getStackTracker((Throwable)e));
                        result.setNrErrors(1L);
                        continue;
                    }
                    finally {
                        if (imageFile != null) {
                            try {
                                imageFile.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            if (nrEmbeddedImages > 0 && nrattachedFiles == 0) {
                parts.setSubType("related");
            }
            msg.setContent((Multipart)parts);
            try (Transport transport = null;){
                transport = session.getTransport(protocol);
                String authPass = this.getPassword(this.authenticationPassword);
                if (this.usingAuthentication) {
                    if (!Utils.isEmpty((CharSequence)this.port)) {
                        transport.connect(this.environmentSubstitute(Const.NVL((String)this.server, (String)"")), Integer.parseInt(this.environmentSubstitute(Const.NVL((String)this.port, (String)""))), this.environmentSubstitute(Const.NVL((String)this.authenticationUser, (String)"")), authPass);
                    } else {
                        transport.connect(this.environmentSubstitute(Const.NVL((String)this.server, (String)"")), this.environmentSubstitute(Const.NVL((String)this.authenticationUser, (String)"")), authPass);
                    }
                } else {
                    transport.connect();
                }
                transport.sendMessage((Message)msg, msg.getAllRecipients());
            }
        }
        catch (IOException e) {
            this.logError("Problem while sending message: " + e.toString());
            result.setNrErrors(1L);
        }
        catch (MessagingException mex) {
            this.logError("Problem while sending message: " + mex.toString());
            result.setNrErrors(1L);
            Throwable ex = mex;
            do {
                Address[] validSent;
                Address[] validUnsent;
                if (!(ex instanceof SendFailedException)) continue;
                SendFailedException sfex = (SendFailedException)ex;
                Address[] invalid = sfex.getInvalidAddresses();
                if (invalid != null) {
                    this.logError("    ** Invalid Addresses");
                    for (int i = 0; i < invalid.length; ++i) {
                        this.logError("         " + invalid[i]);
                        result.setNrErrors(1L);
                    }
                }
                if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                    this.logError("    ** ValidUnsent Addresses");
                    for (int i = 0; i < validUnsent.length; ++i) {
                        this.logError("         " + validUnsent[i]);
                        result.setNrErrors(1L);
                    }
                }
                if ((validSent = sfex.getValidSentAddresses()) == null) continue;
                for (int i = 0; i < validSent.length; ++i) {
                    this.logError("         " + validSent[i]);
                    result.setNrErrors(1L);
                }
            } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
        }
        finally {
            if (masterZipfile != null && masterZipfile.exists()) {
                masterZipfile.delete();
            }
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
        return result;
    }

    private void addBacktracking(JobTracker jobTracker, StringBuilder messageText) {
        this.addBacktracking(jobTracker, messageText, 0);
    }

    private void addBacktracking(JobTracker jobTracker, StringBuilder messageText, int level) {
        int nr = jobTracker.nrJobTrackers();
        messageText.append(Const.rightPad((String)" ", (int)(level * 2)));
        messageText.append(Const.NVL((String)jobTracker.getJobName(), (String)"-"));
        JobEntryResult jer = jobTracker.getJobEntryResult();
        if (jer != null) {
            messageText.append(" : ");
            if (jer.getJobEntryName() != null) {
                messageText.append(" : ");
                messageText.append(jer.getJobEntryName());
            }
            if (jer.getResult() != null) {
                messageText.append(" : ");
                messageText.append("[" + jer.getResult().toString() + "]");
            }
            if (jer.getReason() != null) {
                messageText.append(" : ");
                messageText.append(jer.getReason());
            }
            if (jer.getComment() != null) {
                messageText.append(" : ");
                messageText.append(jer.getComment());
            }
            if (jer.getLogDate() != null) {
                messageText.append(" (");
                messageText.append(XMLHandler.date2string((Date)jer.getLogDate()));
                messageText.append(')');
            }
        }
        messageText.append(Const.CR);
        for (int i = 0; i < nr; ++i) {
            JobTracker jt = jobTracker.getJobTracker(i);
            this.addBacktracking(jt, messageText, level + 1);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    public boolean isUsingSecureAuthentication() {
        return this.usingSecureAuthentication;
    }

    public void setUsingSecureAuthentication(boolean usingSecureAuthentication) {
        this.usingSecureAuthentication = usingSecureAuthentication;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        String realServername = jobMeta.environmentSubstitute(this.server);
        ResourceReference reference = new ResourceReference(this);
        reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
        references.add(reference);
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "server", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "replyAddress", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.emailValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "destination", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        if (this.usingAuthentication) {
            JobEntryValidatorUtils.andValidator().validate(this, "authenticationUser", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
            JobEntryValidatorUtils.andValidator().validate(this, "authenticationPassword", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        }
        JobEntryValidatorUtils.andValidator().validate(this, "port", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    public String getPassword(String authPassword) {
        return Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(Const.NVL((String)authPassword, (String)"")));
    }
}

