/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs.configuration;

import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.SftpFileNameParser;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.configuration.KettleGenericFileSystemConfigBuilder;

public class KettleSftpFileSystemConfigBuilder
extends KettleGenericFileSystemConfigBuilder {
    private static final KettleSftpFileSystemConfigBuilder builder = new KettleSftpFileSystemConfigBuilder();
    private static final LogChannelInterface log = new LogChannel("cfgbuilder");
    private static final String IDENTITY_KEY = SftpFileSystemConfigBuilder.class.getName() + ".IDENTITIES";

    public static KettleSftpFileSystemConfigBuilder getInstance() {
        return builder;
    }

    protected KettleSftpFileSystemConfigBuilder() {
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return SftpFileSystem.class;
    }

    @Override
    public void setParameter(FileSystemOptions opts, String name, String value, String fullParameterName, String vfsUrl) throws IOException {
        if (!fullParameterName.startsWith("vfs.sftp")) {
            super.setParameter(opts, name, value, fullParameterName, vfsUrl);
        } else {
            try {
                FileNameParser sftpFilenameParser = SftpFileNameParser.getInstance();
                URLFileName file = (URLFileName)sftpFilenameParser.parseUri(null, null, vfsUrl);
                if (!KettleSftpFileSystemConfigBuilder.parameterContainsHost(fullParameterName) || fullParameterName.endsWith(file.getHostName())) {
                    if (name.equalsIgnoreCase("AuthKeyPassphrase")) {
                        this.setParam(opts, UserInfo.class.getName(), new PentahoUserInfo(value));
                    } else if (name.equals("identity")) {
                        IdentityInfo[] identities = (IdentityInfo[])this.getParam(opts, IDENTITY_KEY);
                        if (identities == null) {
                            identities = new IdentityInfo[]{new IdentityInfo(new File(value))};
                        } else {
                            IdentityInfo[] temp = new IdentityInfo[identities.length + 1];
                            System.arraycopy(identities, 0, temp, 0, identities.length);
                            identities = temp;
                            identities[identities.length - 1] = new IdentityInfo(new File(value));
                        }
                        this.setParam(opts, IDENTITY_KEY, identities);
                    } else {
                        super.setParameter(opts, name, value, fullParameterName, vfsUrl);
                    }
                } else {
                    log.logDebug("No host match found for: " + fullParameterName);
                }
            }
            catch (IOException e) {
                log.logError("Failed to set VFS parameter: [" + fullParameterName + "] " + value, e);
            }
        }
    }

    private static boolean parameterContainsHost(String parameter) {
        return parameter.matches("^(.*\\..*){3,}");
    }

    private static class PentahoUserInfo
    implements UserInfo {
        private String passphrase;
        private String password;

        public PentahoUserInfo(String passphrase) {
            this.passphrase = passphrase;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassphrase(String arg0) {
            return true;
        }

        public boolean promptPassword(String arg0) {
            return false;
        }

        public boolean promptYesNo(String arg0) {
            return false;
        }

        public void showMessage(String arg0) {
        }
    }
}

