/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.util.PosixPermissions;
import org.pentaho.di.core.vfs.SftpFileSystemWindows;

class SftpFileObjectWithWindowsSupport
extends SftpFileObject {
    private static final String FULL_ACCESS = "(F)";
    private static final String MODIFY_ACCESS = "(M)";
    private static final String READ_AND_EXECUTE_ACCESS = "(RX)";
    private static final String READ_ACCESS = "(R)";
    private static final String WRITE_ACCESS = "(W)";
    private static final String WRITE_DATA_ADD_FILES_ACCESS = "WD";
    private static final String READ_DATA_ADD_FILES_ACCESS = "RD";
    private String path;

    SftpFileObjectWithWindowsSupport(AbstractFileName name, SftpFileSystemWindows fileSystem) throws FileSystemException {
        super(name, (SftpFileSystem)fileSystem);
        this.path = name.getPath();
    }

    protected boolean doIsReadable() throws Exception {
        SftpFileSystemWindows fileSystem = (SftpFileSystemWindows)this.getAbstractFileSystem();
        if (!fileSystem.isRemoteHostWindows()) {
            return super.doIsReadable();
        }
        List<String> userGroups = fileSystem.getUserGroups();
        Map<String, String> filePermissions = fileSystem.getFilePermission(this.path);
        for (String group : userGroups) {
            String acl = filePermissions.get(group);
            if (acl == null) continue;
            return acl.contains(FULL_ACCESS) || acl.contains(MODIFY_ACCESS) || acl.contains(READ_AND_EXECUTE_ACCESS) || acl.contains(READ_ACCESS) || acl.contains(WRITE_ACCESS) || acl.contains(WRITE_DATA_ADD_FILES_ACCESS) || acl.contains(READ_DATA_ADD_FILES_ACCESS);
        }
        return false;
    }

    protected boolean doIsWriteable() throws Exception {
        SftpFileSystemWindows fileSystem = (SftpFileSystemWindows)this.getAbstractFileSystem();
        if (!fileSystem.isRemoteHostWindows()) {
            return super.doIsWriteable();
        }
        List<String> userGroups = fileSystem.getUserGroups();
        Map<String, String> filePermissions = fileSystem.getFilePermission(this.path);
        for (String group : userGroups) {
            String acl = filePermissions.get(group);
            if (acl == null) continue;
            return acl.contains(FULL_ACCESS) || acl.contains(MODIFY_ACCESS) || acl.contains(WRITE_ACCESS) || acl.contains(WRITE_DATA_ADD_FILES_ACCESS);
        }
        return false;
    }

    protected PosixPermissions getPermissions(boolean checkIds) throws Exception {
        if (checkIds && this.getAbstractFileSystem() instanceof SftpFileSystemWindows && ((SftpFileSystemWindows)this.getAbstractFileSystem()).isExecDisabled()) {
            return new PretendUserIsOwnerPosixPermissions();
        }
        return super.getPermissions(checkIds);
    }

    public class PretendUserIsOwnerPosixPermissions
    extends PosixPermissions {
        public PretendUserIsOwnerPosixPermissions() {
            super(PosixPermissions.Type.UserReadable.getMask() + PosixPermissions.Type.UserWritable.getMask() + PosixPermissions.Type.UserExecutable.getMask() + PosixPermissions.Type.GroupReadable.getMask() + PosixPermissions.Type.GroupWritable.getMask() + PosixPermissions.Type.GroupExecutable.getMask() + PosixPermissions.Type.OtherReadable.getMask() + PosixPermissions.Type.OtherWritable.getMask() + PosixPermissions.Type.OtherExecutable.getMask(), true, true);
        }
    }
}

