/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingEventListener
implements KettleLoggingEventListener {
    @VisibleForTesting
    Logger transLogger = LoggerFactory.getLogger((String)"org.pentaho.di.trans.Trans");
    @VisibleForTesting
    Logger jobLogger = LoggerFactory.getLogger((String)"org.pentaho.di.job.Job");
    @VisibleForTesting
    Logger diLogger = LoggerFactory.getLogger((String)"org.pentaho.di");
    @VisibleForTesting
    Function<String, LoggingObjectInterface> logObjProvider = objId -> LoggingRegistry.getInstance().getLoggingObject((String)objId);
    private static final String SEPARATOR = "/";

    @Override
    public void eventAdded(KettleLoggingEvent event) {
        Object messageObject = event.getMessage();
        Preconditions.checkNotNull((Object)messageObject, (Object)"Expected log message to be defined.");
        if (messageObject instanceof LogMessage) {
            LogMessage message = (LogMessage)messageObject;
            LoggingObjectInterface loggingObject = this.logObjProvider.apply(message.getLogChannelId());
            if (loggingObject == null) {
                this.logToLogger(this.diLogger, message.getLevel(), message.getSubject() + " " + message.getMessage());
            } else if (loggingObject.getObjectType() == LoggingObjectType.TRANS || loggingObject.getObjectType() == LoggingObjectType.STEP || loggingObject.getObjectType() == LoggingObjectType.DATABASE) {
                this.logToLogger(this.transLogger, message.getLevel(), loggingObject, message);
            } else if (loggingObject.getObjectType() == LoggingObjectType.JOB || loggingObject.getObjectType() == LoggingObjectType.JOBENTRY) {
                this.logToLogger(this.jobLogger, message.getLevel(), loggingObject, message);
            }
        }
    }

    private void logToLogger(Logger logger, LogLevel logLevel, LoggingObjectInterface loggingObject, LogMessage message) {
        this.logToLogger(logger, logLevel, "[" + this.getDetailedSubject(loggingObject) + "]  " + message.getMessage());
    }

    private void logToLogger(Logger logger, LogLevel logLevel, String message) {
        switch (logLevel) {
            case NOTHING: {
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            case MINIMAL: {
                logger.warn(message);
                break;
            }
            case BASIC: 
            case DETAILED: {
                logger.info(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case ROWLEVEL: {
                logger.trace(message);
                break;
            }
        }
    }

    private String getDetailedSubject(LoggingObjectInterface loggingObject) {
        LinkedList<String> subjects = new LinkedList<String>();
        while (loggingObject != null) {
            if (loggingObject.getObjectType() == LoggingObjectType.TRANS || loggingObject.getObjectType() == LoggingObjectType.JOB) {
                String name;
                RepositoryDirectoryInterface rd = loggingObject.getRepositoryDirectory();
                if (StringUtils.isNotBlank((String)loggingObject.getFilename())) {
                    name = loggingObject.getFilename();
                } else {
                    String string = name = loggingObject.getObjectType() == LoggingObjectType.TRANS ? loggingObject.getObjectName() + RepositoryObjectType.TRANSFORMATION.getExtension() : loggingObject.getObjectName() + RepositoryObjectType.JOB.getExtension();
                }
                if (rd != null) {
                    String path = rd.getPath();
                    if (path.equals(SEPARATOR)) {
                        if (name != null && name.length() > 0) {
                            subjects.add(name);
                        }
                    } else {
                        subjects.add(path + SEPARATOR + name);
                    }
                } else if (name != null && name.length() > 0) {
                    subjects.add(name);
                }
            }
            loggingObject = loggingObject.getParent();
        }
        if (subjects.size() > 0) {
            return subjects.size() > 1 ? this.formatDetailedSubject(subjects) : subjects.get(0);
        }
        return "";
    }

    private String formatDetailedSubject(LinkedList<String> subjects) {
        StringBuilder string = new StringBuilder();
        Iterator<String> it = subjects.descendingIterator();
        while (it.hasNext()) {
            string.append(it.next());
            if (!it.hasNext()) continue;
            string.append("  ");
        }
        return string.toString();
    }
}

