/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseTransactionListener;
import org.pentaho.di.core.util.Utils;

public class DatabaseConnectionMap {
    private final ConcurrentMap<String, Database> map = new ConcurrentHashMap<String, Database>();
    private final AtomicInteger transactionId = new AtomicInteger(0);
    private final Map<String, List<DatabaseTransactionListener>> transactionListenersMap = new HashMap<String, List<DatabaseTransactionListener>>();
    private static final DatabaseConnectionMap connectionMap = new DatabaseConnectionMap();

    public static DatabaseConnectionMap getInstance() {
        return connectionMap;
    }

    private DatabaseConnectionMap() {
    }

    public Database getOrStoreIfAbsent(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        return this.map.putIfAbsent(key, database);
    }

    public void removeConnection(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        this.map.remove(key);
    }

    @Deprecated
    public synchronized void storeDatabase(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        this.map.put(key, database);
    }

    @Deprecated
    public synchronized Database getDatabase(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        return (Database)this.map.get(key);
    }

    public static String createEntryKey(String connectionGroup, String partitionID, Database database) {
        StringBuilder key = new StringBuilder(connectionGroup);
        key.append(':').append(database.getDatabaseMeta().getName());
        if (!Utils.isEmpty(partitionID)) {
            key.append(':').append(partitionID);
        }
        return key.toString();
    }

    public Map<String, Database> getMap() {
        return this.map;
    }

    public String getNextTransactionId() {
        return Integer.toString(this.transactionId.incrementAndGet());
    }

    public void addTransactionListener(String transactionId, DatabaseTransactionListener listener) {
        List<DatabaseTransactionListener> transactionListeners = this.getTransactionListeners(transactionId);
        transactionListeners.add(listener);
    }

    public void removeTransactionListener(String transactionId, DatabaseTransactionListener listener) {
        List<DatabaseTransactionListener> transactionListeners = this.getTransactionListeners(transactionId);
        transactionListeners.remove(listener);
    }

    public List<DatabaseTransactionListener> getTransactionListeners(String transactionId) {
        List<DatabaseTransactionListener> transactionListeners = this.transactionListenersMap.get(transactionId);
        if (transactionListeners == null) {
            transactionListeners = new ArrayList<DatabaseTransactionListener>();
            this.transactionListenersMap.put(transactionId, transactionListeners);
        }
        return transactionListeners;
    }

    public void removeTransactionListeners(String transactionId) {
        this.transactionListenersMap.remove(transactionId);
    }
}

