/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;

public class NeoviewDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 18650;
        }
        return -1;
    }

    @Override
    public boolean supportsAutoInc() {
        return false;
    }

    @Override
    public String getLimitClause(int nrRows) {
        return "";
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT [FIRST 1] * FROM " + tableName;
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT [FIRST 1] " + columnname + " FROM " + tableName;
    }

    @Override
    public boolean needsToLockAllTables() {
        return false;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.hp.t4jdbc.HPT4Driver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) throws KettleDatabaseException {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        String appendix = "";
        if (!Utils.isEmpty(databaseName)) {
            appendix = databaseName.contains("=") ? ":" + databaseName : ":schema=" + databaseName;
        }
        return "jdbc:hpt4jdbc://" + hostname + ":" + port + "/" + appendix;
    }

    @Override
    public boolean supportsOptionsInURL() {
        return true;
    }

    @Override
    public boolean useSchemaNameForTableList() {
        return true;
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD ( " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " ) ";
    }

    @Override
    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP ( " + v.getName() + " ) " + Const.CR;
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "INTEGER NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length <= 18) {
                            retval = retval + "NUMERIC(" + length + ")";
                            break;
                        }
                        retval = retval + "FLOAT";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                if (length <= 18) {
                    retval = retval + "NUMERIC(" + length;
                    if (precision > 0) {
                        retval = retval + ", " + precision;
                    }
                    retval = retval + ")";
                    break;
                }
                retval = retval + "FLOAT";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length <= 4028) {
                        retval = retval + "VARCHAR(" + length + ")";
                        break;
                    }
                    if (length <= 4036) {
                        retval = retval + "CHAR(" + length + ")";
                        break;
                    }
                    retval = retval + "CLOB";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 8: {
                retval = retval + "BLOB";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ACTION", "FOR", "PROTOTYPE", "ADD", "FOREIGN", "PUBLIC", "ADMIN", "FOUND", "READ", "AFTER", "FRACTION", "READS", "AGGREGATE", "FREE", "REAL", "ALIAS", "FROM", "RECURSIVE", "ALL", "FULL", "REF", "ALLOCATE", "FUNCTION", "REFERENCES", "ALTER", "GENERAL", "REFERENCING", "AND", "GET", "RELATIVE", "ANY", "GLOBAL", "REPLACE", "ARE", "GO", "RESIGNAL", "ARRAY", "GOTO", "RESTRICT", "AS", "GRANT", "RESULT", "ASC", "GROUP", "RETURN", "ASSERTION", "GROUPING", "RETURNS", "ASYNC", "HAVING", "REVOKE", "AT", "HOST", "RIGHT", "AUTHORIZATION", "HOUR", "ROLE", "AVG", "IDENTITY", "ROLLBACK", "BEFORE", "IF", "ROLLUP", "BEGIN", "IGNORE", "ROUTINE", "BETWEEN", "IMMEDIATE", "ROW", "BINARY", "IN", "ROWS", "BIT", "INDICATOR", "SAVEPOINT", "BIT_LENGTH", "INITIALLY", "SCHEMA", "BLOB", "INNER", "SCOPE", "BOOLEAN", "INOUT", "SCROLL", "BOTH", "INPUT", "SEARCH", "BREADTH", "INSENSITIVE", "SECOND", "BY", "INSERT", "SECTION", "CALL", "INT", "SELECT", "CASE", "INTEGER", "SENSITIVE", "CASCADE", "INTERSECT", "SESSION", "CASCADED", "INTERVAL", "SESSION_USER", "CAST", "INTO", "SET", "CATALOG", "IS", "SETS", "CHAR", "ISOLATION", "SIGNAL", "CHAR_LENGTH", "ITERATE", "SIMILAR", "CHARACTER", "JOIN", "SIZE", "CHARACTER_LENGTH", "KEY", "SMALLINT", "CHECK", "LANGUAGE", "SOME", "CLASS", "LARGE", "CLOB", "LAST", "SPECIFIC", "CLOSE", "LATERAL", "SPECIFICTYPE", "COALESCE", "LEADING", "SQL", "COLLATE", "LEAVE", "SQL_CHAR", "COLLATION", "LEFT", "SQL_DATE", "COLUMN", "LESS", "SQL_DECIMAL", "COMMIT", "LEVEL", "SQL_DOUBLE", "COMPLETION", "LIKE", "SQL_FLOAT", "CONNECT", "LIMIT", "SQL_INT", "CONNECTION", "LOCAL", "SQL_INTEGER", "CONSTRAINT", "LOCALTIME", "SQL_REAL", "CONSTRAINTS", "LOCALTIMESTAMP", "SQL_SMALLINT", "CONSTRUCTOR", "LOCATOR", "SQL_TIME", "CONTINUE", "LOOP", "SQL_TIMESTAMP", "CONVERT", "LOWER", "SQL_VARCHAR", "CORRESPONDING", "MAP", "SQLCODE", "COUNT", "MATCH", "SQLERROR", "CREATE", "MAX", "SQLEXCEPTION", "CROSS", "MIN", "SQLSTATE", "CUBE", "MINUTE", "SQLWARNING", "CURRENT", "MODIFIES", "STRUCTURE", "CURRENT_DATE", "MODIFY", "SUBSTRING", "CURRENT_PATH", "MODULE", "SUM", "CURRENT_ROLE", "MONTH", "SYSTEM_USER", "CURRENT_TIME", "NAMES", "TABLE", "CURRENT_TIMESTAMP", "NATIONAL", "TEMPORARY", "CURRENT_USER", "NATURAL", "TERMINATE", "CURSOR", "NCHAR", "TEST", "CYCLE", "NCLOB", "THAN", "DATE", "NEW", "THEN", "DATETIME", "NEXT", "THERE", "DAY", "NO", "TIME", "DEALLOCATE", "NONE", "TIMESTAMP", "DEC", "NOT", "TIMEZONE_HOUR", "DECIMAL", "NULL", "TIMEZONE_MINUTE", "DECLARE", "NULLIF", "TO", "DEFAULT", "NUMERIC", "TRAILING", "DEFERRABLE", "OBJECT", "TRANSACTION", "DEFERRED", "OCTET_LENGTH", "TRANSLATE", "DELETE", "OF", "TRANSLATION", "DEPTH", "OFF", "TRANSPOSE", "DEREF", "OID", "TREAT", "DESC", "OLD", "TRIGGER", "DESCRIBE", "ON", "TRIM", "DESCRIPTOR", "ONLY", "TRUE", "DESTROY", "OPEN", "UNDER", "DESTRUCTOR", "OPERATORS", "UNION", "DETERMINISTIC", "OPTION", "UNIQUE", "DIAGNOSTICS", "OR", "UNKNOWN", "DISTINCT", "ORDER", "UNNEST", "DICTIONARY", "ORDINALITY", "UPDATE", "DISCONNECT", "OTHERS", "UPPER", "DOMAIN", "OUT", "UPSHIFT", "DOUBLE", "OUTER", "USAGE", "DROP", "OUTPUT", "USER", "DYNAMIC", "OVERLAPS", "USING", "EACH", "PAD", "VALUE", "ELSE", "PARAMETER", "VALUES", "ELSEIF", "PARAMETERS", "VARCHAR", "END", "PARTIAL", "VARIABLE", "END-EXEC", "PENDANT", "VARYING", "EQUALS", "POSITION", "VIEW", "ESCAPE", "POSTFIX", "VIRTUAL", "EXCEPT", "PRECISION", "VISIBLE", "EXCEPTION", "PREFIX", "WAIT", "EXEC", "PREORDER", "WHEN", "EXECUTE", "PREPARE", "WHENEVER", "EXISTS", "PRESERVE", "WHERE", "EXTERNAL", "PRIMARY", "WHILE", "EXTRACT", "PRIOR", "WITH", "FALSE", "PRIVATE", "WITHOUT", "FETCH", "PRIVILEGES", "WORK", "FIRST", "PROCEDURE", "WRITE", "FLOAT", "PROTECTED", "YEAR", "ZONE"};
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        StringBuilder sql = new StringBuilder(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("LOCK TABLE ").append(tableNames[i]).append(" IN EXCLUSIVE MODE;").append(Const.CR);
        }
        return sql.toString();
    }

    @Override
    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "http://docs.hp.com/en/busintellsol.html";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"hpt4jdbc.jar"};
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public int getMaxVARCHARLength() {
        return 4028;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public Object getValueFromResultSet(ResultSet rs, ValueMetaInterface val, int i) throws KettleDatabaseException {
        Object data = null;
        try {
            switch (val.getType()) {
                case 4: {
                    data = rs.getBoolean(i + 1);
                    break;
                }
                case 1: {
                    data = new Double(rs.getDouble(i + 1));
                    break;
                }
                case 6: {
                    data = rs.getBigDecimal(i + 1);
                    break;
                }
                case 5: {
                    data = rs.getLong(i + 1);
                    break;
                }
                case 2: {
                    if (val.isStorageBinaryString()) {
                        data = rs.getBytes(i + 1);
                        break;
                    }
                    data = rs.getString(i + 1);
                    break;
                }
                case 8: {
                    if (this.supportsGetBlob()) {
                        Blob blob = rs.getBlob(i + 1);
                        if (blob != null) {
                            data = blob.getBytes(1L, (int)blob.length());
                            break;
                        }
                        data = null;
                        break;
                    }
                    data = rs.getBytes(i + 1);
                    break;
                }
                case 3: 
                case 9: {
                    if (val.getOriginalColumnType() == 92) {
                        data = rs.getTime(i + 1);
                        break;
                    }
                    if (val.getPrecision() != 1 && this.supportsTimeStampToDateConversion()) {
                        data = rs.getTimestamp(i + 1);
                        break;
                    }
                    data = rs.getDate(i + 1);
                    break;
                }
            }
            if (rs.wasNull()) {
                data = null;
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to get value '" + val.toStringMeta() + "' from database resultset, index " + i, e);
        }
        return data;
    }
}

