/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.MSSQLServerDatabaseMeta;
import org.pentaho.di.core.util.Utils;

public class MSSQLServerNativeDatabaseMeta
extends MSSQLServerDatabaseMeta {
    public static final String ATTRIBUTE_USE_INTEGRATED_SECURITY = "MSSQLUseIntegratedSecurity";

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        String useIntegratedSecurity = "false";
        Object value = this.getAttributes().get(ATTRIBUTE_USE_INTEGRATED_SECURITY);
        if (value != null && value instanceof String) {
            useIntegratedSecurity = (String)value;
            try {
                Boolean.parseBoolean(useIntegratedSecurity);
            }
            catch (IllegalArgumentException e) {
                useIntegratedSecurity = "false";
            }
        }
        String url = "jdbc:sqlserver://" + hostname;
        if (!Utils.isEmpty(port) && Const.toInt(port, -1) > 0) {
            url = url + ":" + port;
        }
        url = url + ";databaseName=" + databaseName + ";integratedSecurity=" + useIntegratedSecurity;
        return url;
    }

    @Override
    public boolean supportsGetBlob() {
        return false;
    }
}

