/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.part;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.PartReportFiller;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.part.PartComponentFillFactory;
import net.sf.jasperreports.engine.part.PartComponentManager;
import net.sf.jasperreports.engine.part.PartComponentsEnvironment;
import net.sf.jasperreports.engine.part.PartEvaluationTime;
import net.sf.jasperreports.engine.part.PartFillComponent;
import net.sf.jasperreports.engine.part.PartFillContext;
import net.sf.jasperreports.engine.part.PartPrintOutput;
import net.sf.jasperreports.engine.part.StandardPartEvaluationTime;
import net.sf.jasperreports.engine.util.ElementalPropertiesHolder;

public class FillPart {
    private JRPart reportPart;
    private JRFillExpressionEvaluator expressionEvaluator;
    private PartReportFiller reportFiller;
    private JRPropertiesHolder staticPartProperties;
    private List<JRPropertyExpression> propertyExpressions;
    private JRPropertiesHolder printPartProperties;
    private PartFillComponent fillComponent;
    private String partName;

    public FillPart(JRPart part, JRFillObjectFactory fillFactory) {
        this.reportPart = part;
        this.expressionEvaluator = fillFactory.getExpressionEvaluator();
        this.reportFiller = (PartReportFiller)fillFactory.getReportFiller();
        ComponentKey componentKey = part.getComponentKey();
        PartComponent component = part.getComponent();
        JasperReportsContext jasperReportsContext = fillFactory.getReportFiller().getJasperReportsContext();
        this.staticPartProperties = new ElementalPropertiesHolder();
        JRPropertiesUtil.getInstance(jasperReportsContext).transferProperties(part, this.staticPartProperties, "net.sf.jasperreports.part.print.transfer.");
        JRPropertyExpression[] partPropertyExpressions = part.getPropertyExpressions();
        this.propertyExpressions = partPropertyExpressions == null ? new ArrayList<JRPropertyExpression>(0) : new ArrayList<JRPropertyExpression>(Arrays.asList(partPropertyExpressions));
        PartComponentsEnvironment partsEnv = PartComponentsEnvironment.getInstance(jasperReportsContext);
        PartComponentManager componentManager = partsEnv.getManager(componentKey);
        PartComponentFillFactory componentFactory = componentManager.getComponentFillFactory(jasperReportsContext);
        this.fillComponent = componentFactory.toFillComponent(component, fillFactory);
        this.fillComponent.initialize(new Context());
    }

    public void fill(byte evaluation, PartPrintOutput output) throws JRException {
        boolean toPrint = this.evaluatePrintWhenExpression(evaluation);
        if (!toPrint) {
            return;
        }
        this.evaluateProperties(evaluation);
        this.evaluatePartNameExpression(evaluation);
        this.fillComponent.evaluate(evaluation);
        this.fillComponent.fill(output);
    }

    protected boolean evaluatePrintWhenExpression(byte evaluation) throws JRException {
        Boolean expressionResult;
        JRExpression expression = this.reportPart.getPrintWhenExpression();
        boolean result = expression == null ? true : (expressionResult = (Boolean)this.expressionEvaluator.evaluate(expression, evaluation)) != null && expressionResult != false;
        return result;
    }

    protected void evaluateProperties(byte evaluation) throws JRException {
        JRPropertiesMap dynamicProperties = new JRPropertiesMap();
        for (JRPropertyExpression prop : this.propertyExpressions) {
            String value = (String)this.expressionEvaluator.evaluate(prop.getValueExpression(), evaluation);
            dynamicProperties.setProperty(prop.getName(), value);
        }
        if (dynamicProperties.isEmpty()) {
            this.printPartProperties = this.staticPartProperties;
        } else {
            JRPropertiesMap props = new JRPropertiesMap();
            props.setBaseProperties(this.staticPartProperties.getPropertiesMap());
            this.printPartProperties = new ElementalPropertiesHolder(props);
            JRPropertiesUtil.getInstance(this.reportFiller.getJasperReportsContext()).transferProperties(dynamicProperties, this.printPartProperties, "net.sf.jasperreports.part.print.transfer.");
        }
    }

    protected void evaluatePartNameExpression(byte evaluation) throws JRException {
        JRExpression expression = this.reportPart.getPartNameExpression();
        this.partName = expression == null ? null : (String)this.expressionEvaluator.evaluate(expression, evaluation);
    }

    public PartEvaluationTime getEvaluationTime() {
        PartEvaluationTime evaluationTime = this.reportPart.getEvaluationTime();
        return evaluationTime == null ? StandardPartEvaluationTime.EVALUATION_NOW : evaluationTime;
    }

    public String getPartName() {
        return this.partName;
    }

    public JRPropertiesHolder getPrintPartProperties() {
        return this.printPartProperties;
    }

    protected class Context
    implements PartFillContext {
        protected Context() {
        }

        @Override
        public JRPart getPart() {
            return FillPart.this.reportPart;
        }

        @Override
        public FillPart getFillPart() {
            return FillPart.this;
        }

        @Override
        public PartReportFiller getFiller() {
            return FillPart.this.reportFiller;
        }

        @Override
        public Object evaluate(JRExpression expression, byte evaluation) throws JRException {
            return FillPart.this.reportFiller.evaluateExpression(expression, evaluation);
        }
    }
}

