/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class AutoIndentWriter
extends FilterWriter {
    public static final char ALIGN = '\uffff';
    public static final char FLUSH_TABBING = '\ufffe';
    public static final char INDENT = '\ufffd';
    public static final char UNINDENT = '\ufffc';
    private int previousChar = -1;
    private List indentation = new ArrayList();
    private String prefix;

    public AutoIndentWriter(Writer out) {
        super(out);
        this.indentation.add(null);
        this.prefix = null;
    }

    public void write(int c) throws IOException {
        if (c == 65534) {
            this.flushTabbing();
            return;
        }
        if ((c == 13 || c == 10) && this.prefix == null && this.previousChar == 123) {
            this.indent();
        }
        StringBuffer indent = (StringBuffer)this.indentation.get(this.indentation.size() - 1);
        if (c == 65535 && indent == null) {
            indent = new StringBuffer();
            this.indentation.set(this.indentation.size() - 1, indent);
        }
        if (indent == null) {
            if (this.previousChar == 13 && c != 10 || this.previousChar == 10) {
                if (this.prefix == null && c == 125) {
                    this.unindent();
                }
                for (int i = this.indentation.size(); i > 0; --i) {
                    this.out.write("    ");
                }
                if (this.prefix != null) {
                    this.out.write(this.prefix);
                }
            }
            this.out.write(c);
        } else {
            indent.append((char)c);
        }
        this.previousChar = c;
    }

    private void unindent() throws IOException {
        this.flushTabbing();
        this.indentation.remove(this.indentation.size() - 1);
    }

    private void flushTabbing() throws IOException {
        char c;
        int i;
        StringBuffer sb = (StringBuffer)this.indentation.get(this.indentation.size() - 1);
        if (sb == null) {
            return;
        }
        ArrayList<Integer> tabWidths = new ArrayList<Integer>();
        int col = 0;
        int idx = 0;
        for (i = 0; i < sb.length(); ++i) {
            c = sb.charAt(i);
            if (c == '\uffff') {
                if (tabWidths.size() <= idx) {
                    tabWidths.add(new Integer(col));
                } else if (col > (Integer)tabWidths.get(idx)) {
                    tabWidths.set(idx, new Integer(col));
                }
                col = 0;
                ++idx;
                continue;
            }
            if (c == '\r' || c == '\n') {
                col = 0;
                continue;
            }
            ++col;
        }
        col = 0;
        idx = 0;
        for (i = 0; i < sb.length(); ++i) {
            c = sb.charAt(i);
            if (c == '\uffff') {
                for (int j = (Integer)tabWidths.get(idx) - col; j > 0; --j) {
                    this.out.write(32);
                }
                col = 0;
                ++idx;
                continue;
            }
            if (c == '\r' || c == '\n') {
                this.out.write(c);
                col = 0;
                continue;
            }
            this.out.write(c);
            ++col;
        }
    }

    private void indent() {
        this.indentation.add(null);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        while (len > 0) {
            this.write(cbuf[off++]);
            --len;
        }
    }

    public void write(String str, int off, int len) throws IOException {
        while (len > 0) {
            this.write(str.charAt(off++));
            --len;
        }
    }
}

