/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.TransferProtocolException;
import de.destatis.core.inspector.InspectionController;
import de.destatis.core.inspector.util.ExtResourceDirNotExistsResourceAccessException;
import de.destatis.core.inspector.util.ResourceAccessException;
import de.destatis.core.resource.DatmlSdfSource;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.ResourceConfig;
import de.destatis.core.resource.ResourceStorage;
import de.destatis.core.resource.ResourceStorageException;
import de.destatis.core.resource.SurveyResource;
import de.destatis.core.resource.SurveyResourceProvider;
import de.destatis.core.resource.util.ExtResourceDirNotExistsException;
import de.destatis.core.resource.util.ResourceManager;
import de.destatis.core.resource.util.ResponseStatusException;
import java.util.Properties;

public class InspectorConfig {
    private Properties properties = new Properties();
    private Client client;
    private ResourceStorage surveyResourceStorage;
    private SurveyResourceProvider surveyResourceProvider;
    private InspectionController inspectionController;
    private SurveyResourceProvider autoSurveyResourceProvider;
    public static final String INSPECTION_LEVEL = "inspector.inspectionLevel";
    public static final String SURVEY_AUTOUPDATE = "inspector.survey.autoupdate";
    public static final String SURVEY_DIR = "inspector.survey.dir";
    public static final String SCHEMA_DIR = "inspector.schema.dir";
    private static final int DEFAULT_INSPECTOR_INSPECTION_LEVEL = 2;

    public InspectorConfig() {
    }

    public InspectorConfig(Properties properties) {
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) {
        if (properties.containsKey(INSPECTION_LEVEL)) {
            this.properties.put(INSPECTION_LEVEL, properties.get(INSPECTION_LEVEL));
        }
        if (properties.containsKey(SURVEY_AUTOUPDATE)) {
            this.properties.put(SURVEY_AUTOUPDATE, properties.get(SURVEY_AUTOUPDATE));
            this.autoSurveyResourceProvider = null;
        }
        if (properties.containsKey(SURVEY_DIR)) {
            this.properties.put(SURVEY_DIR, properties.get(SURVEY_DIR));
            this.autoSurveyResourceProvider = null;
        }
        if (properties.containsKey(SCHEMA_DIR)) {
            this.properties.put(SCHEMA_DIR, properties.get(SCHEMA_DIR));
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getInspectionLevel() {
        int inspectionLevel = 2;
        String value = this.properties.getProperty(INSPECTION_LEVEL);
        if (value != null) {
            try {
                inspectionLevel = Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                exc.printStackTrace();
                inspectionLevel = 2;
            }
            if (inspectionLevel < 1 || inspectionLevel > 4) {
                inspectionLevel = 2;
            }
        }
        return inspectionLevel;
    }

    public String getSchemaDir() {
        return this.properties.getProperty(SCHEMA_DIR);
    }

    public String getSurveyDir() {
        return this.properties.getProperty(SURVEY_DIR);
    }

    public void setSurveyDir(String dir) {
        this.properties.put(SURVEY_DIR, dir);
        this.autoSurveyResourceProvider = null;
    }

    public void setSurveyResourceStorage(ResourceStorage surveyResourceStorage) {
        this.surveyResourceStorage = surveyResourceStorage;
        this.autoSurveyResourceProvider = null;
    }

    public boolean isSurveyAutoUpdate() {
        String value = this.properties.getProperty(SURVEY_AUTOUPDATE);
        boolean result = value != null && "yes".equals(value);
        return result;
    }

    public void autoUpdateSurvey(boolean value) {
        this.properties.put(SURVEY_AUTOUPDATE, value ? "yes" : "no");
        this.autoSurveyResourceProvider = null;
    }

    public SurveyResourceProvider getSurveyResourceProvider() {
        SurveyResourceProvider result;
        if (this.surveyResourceProvider != null) {
            result = this.surveyResourceProvider;
        } else {
            if (this.autoSurveyResourceProvider == null) {
                this.autoSurveyResourceProvider = new ConnectSurveyResourceProvider();
            }
            result = this.autoSurveyResourceProvider;
        }
        return result;
    }

    public void setSurveyResourceProvider(SurveyResourceProvider surveyResourceProvider) {
        this.surveyResourceProvider = surveyResourceProvider;
    }

    public void setClient(Client client) {
        this.client = client;
        this.autoSurveyResourceProvider = null;
    }

    public void setInspectionController(InspectionController inspectionController) {
        this.inspectionController = inspectionController;
    }

    public InspectionController getInspectionController() {
        return this.inspectionController;
    }

    private class ConnectSurveyResourceProvider
    implements SurveyResourceProvider {
        private ResourceManager resourceManager;

        public ConnectSurveyResourceProvider() {
            ResourceConfig resourceConfig = new ResourceConfig();
            if (InspectorConfig.this.surveyResourceStorage != null) {
                resourceConfig.setSurveyResourceStorage(InspectorConfig.this.surveyResourceStorage);
            } else {
                resourceConfig.setSurveyDir(InspectorConfig.this.getSurveyDir());
            }
            resourceConfig.setSurveyAutoUpdate(InspectorConfig.this.isSurveyAutoUpdate());
            if (InspectorConfig.this.isSurveyAutoUpdate()) {
                Client client = InspectorConfig.this.client != null ? InspectorConfig.this.client : new Client(InspectorConfig.this.properties);
                resourceConfig.setClient(client);
            }
            this.resourceManager = new ResourceManager(resourceConfig);
        }

        public SurveyResource getSurveyResource(String statId, String reportingPeriod, String collector) throws NoResourceFoundException {
            DatmlSdfSource sdf;
            try {
                sdf = this.resourceManager.getSdfResource(statId, reportingPeriod, collector);
            }
            catch (TransferProtocolException e) {
                throw new ResourceAccessException(e);
            }
            catch (ExtResourceDirNotExistsException e) {
                throw new ExtResourceDirNotExistsResourceAccessException(e);
            }
            catch (ResourceStorageException e) {
                throw new ResourceAccessException(e);
            }
            catch (ResponseStatusException e) {
                throw new ResourceAccessException(e);
            }
            return sdf;
        }
    }
}

