/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.InvocationContextFactory;
import com.meterware.servletunit.InvocationContextImpl;
import com.meterware.servletunit.JSPServletDescriptor;
import com.meterware.servletunit.ServletUnitClient;
import com.meterware.servletunit.ServletUnitContext;
import com.meterware.servletunit.WebApplication;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServletRunner {
    public static final JSPServletDescriptor JASPER_DESCRIPTOR;
    private static JSPServletDescriptor _jspServletDescriptor;
    private WebApplication _application;
    private ServletUnitClient _client;
    private ServletUnitContext _context;
    private InvocationContextFactory _factory = new InvocationContextFactory(){

        public InvocationContext newInvocation(ServletUnitClient client, FrameSelector targetFrame, WebRequest request, Dictionary clientHeaders, byte[] messageBody) throws IOException, MalformedURLException {
            return new InvocationContextImpl(client, ServletRunner.this, targetFrame, request, clientHeaders, messageBody);
        }

        public HttpSession getSession(String sessionId, boolean create) {
            return ServletRunner.this._context.getValidSession(sessionId, null, create);
        }
    };

    public ServletRunner() {
        this._application = new WebApplication();
        this.completeInitialization(null);
    }

    public ServletRunner(String webXMLFileSpec) throws IOException, SAXException {
        this._application = new WebApplication(HttpUnitUtils.newParser().parse(webXMLFileSpec));
        this.completeInitialization(null);
    }

    public ServletRunner(String webXMLFileSpec, String contextPath) throws IOException, SAXException {
        this(new File(webXMLFileSpec), contextPath);
    }

    public ServletRunner(File webXml) throws IOException, SAXException {
        this._application = new WebApplication(HttpUnitUtils.newParser().parse(webXml));
        this.completeInitialization(null);
    }

    public ServletRunner(File webXml, String contextPath) throws IOException, SAXException {
        this._application = new WebApplication(HttpUnitUtils.newParser().parse(webXml), webXml.getParentFile().getParentFile(), contextPath);
        this.completeInitialization(contextPath);
    }

    public ServletRunner(InputStream webXML) throws IOException, SAXException {
        this(webXML, null);
    }

    public ServletRunner(InputStream webXML, String contextPath) throws IOException, SAXException {
        this._application = new WebApplication(HttpUnitUtils.newParser().parse(new InputSource(webXML)), contextPath);
        this.completeInitialization(contextPath);
    }

    public void registerServlet(String resourceName, String servletClassName) {
        this._application.registerServlet(resourceName, servletClassName, null);
    }

    private void completeInitialization(String contextPath) {
        this._context = new ServletUnitContext(contextPath, this._application.getServletContext(), this._application);
        this._application.registerServlet("*.jsp", _jspServletDescriptor.getClassName(), _jspServletDescriptor.getInitializationParameters(null, null));
    }

    public void registerServlet(String resourceName, String servletClassName, Hashtable initParameters) {
        this._application.registerServlet(resourceName, servletClassName, initParameters);
    }

    public WebResponse getResponse(WebRequest request) throws MalformedURLException, IOException, SAXException {
        return this.getClient().getResponse(request);
    }

    public WebResponse getResponse(String url) throws MalformedURLException, IOException, SAXException {
        return this.getClient().getResponse(url);
    }

    public HttpSession getSession(boolean create) {
        return this.getClient().getSession(create);
    }

    public String getContextParameter(String name) {
        Object value = this._application.getContextParameters().get(name);
        return value == null ? null : value.toString();
    }

    public void shutDown() {
        this._application.shutDown();
    }

    public ServletUnitClient newClient() {
        return ServletUnitClient.newClient(this._factory);
    }

    ServletUnitContext getContext() {
        return this._context;
    }

    WebApplication getApplication() {
        return this._application;
    }

    private ServletUnitClient getClient() {
        if (this._client == null) {
            this._client = this.newClient();
        }
        return this._client;
    }

    static {
        _jspServletDescriptor = JASPER_DESCRIPTOR = new JasperJSPServletDescriptor();
    }

    public static class JasperJSPServletDescriptor
    implements JSPServletDescriptor {
        public String getClassName() {
            return "org.apache.jasper.servlet.JspServlet";
        }

        public Hashtable getInitializationParameters(String classPath, String workingDirectory) {
            Hashtable<String, String> params = new Hashtable<String, String>();
            if (classPath != null) {
                params.put("classpath", classPath);
            }
            if (workingDirectory != null) {
                params.put("scratchdir", workingDirectory);
            }
            return params;
        }
    }
}

