/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.StringWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DomBuilder;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XmlTraversor;
import org.w3c.dom.Document;

public class TraversalDomSerializer {
    private CleanerProperties props;
    protected boolean escapeXml = true;
    protected boolean deserializeCdataEntities = false;
    protected boolean strictErrorChecking = true;

    public TraversalDomSerializer(CleanerProperties props, boolean escapeXml, boolean deserializeCdataEntities, boolean strictErrorChecking) {
        this.props = props;
        this.escapeXml = escapeXml;
        this.deserializeCdataEntities = deserializeCdataEntities;
        this.strictErrorChecking = strictErrorChecking;
    }

    public TraversalDomSerializer(CleanerProperties props, boolean escapeXml, boolean deserializeCdataEntities) {
        this.props = props;
        this.escapeXml = escapeXml;
        this.deserializeCdataEntities = deserializeCdataEntities;
    }

    public TraversalDomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public TraversalDomSerializer(CleanerProperties props) {
        this.props = props;
    }

    public Document createDOM(TagNode rootNode) throws ParserConfigurationException {
        DomBuilder builder = new DomBuilder(this.props, this.escapeXml, this.deserializeCdataEntities, this.strictErrorChecking);
        XmlTraversor.traverse(builder, rootNode);
        return builder.getDocument();
    }

    public static String toString(Document doc) throws TransformerException, ParserConfigurationException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }
}

