/*
 * Decompiled with CFR 0.152.
 */
package com.his.jackson.databind.ser.std;

import com.his.jackson.core.JsonGenerator;
import com.his.jackson.core.JsonToken;
import com.his.jackson.core.type.WritableTypeId;
import com.his.jackson.databind.JavaType;
import com.his.jackson.databind.JsonMappingException;
import com.his.jackson.databind.JsonNode;
import com.his.jackson.databind.SerializerProvider;
import com.his.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.his.jackson.databind.jsontype.TypeSerializer;
import com.his.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

