/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.awt.geom.GeneralPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.GlyphDescription;

class GlyphRenderer {
    private static final Log LOG = LogFactory.getLog(GlyphRenderer.class);
    private GlyphDescription glyphDescription;

    public GlyphRenderer(GlyphDescription glyphDescription) {
        this.glyphDescription = glyphDescription;
    }

    public GeneralPath getPath() {
        Point[] points = this.describe(this.glyphDescription);
        return this.calculatePath(points);
    }

    private Point[] describe(GlyphDescription gd) {
        int endPtIndex = 0;
        Point[] points = new Point[gd.getPointCount()];
        for (int i = 0; i < gd.getPointCount(); ++i) {
            boolean endPt;
            boolean bl = endPt = gd.getEndPtOfContours(endPtIndex) == i;
            if (endPt) {
                ++endPtIndex;
            }
            points[i] = new Point(gd.getXCoordinate(i), gd.getYCoordinate(i), (gd.getFlags(i) & 1) != 0, endPt);
        }
        return points;
    }

    private GeneralPath calculatePath(Point[] points) {
        GeneralPath path = new GeneralPath();
        int numberOfPoints = points.length;
        int i = 0;
        boolean endOfContour = true;
        Point startingPoint = null;
        Point offCurveStartPoint = null;
        while (i < numberOfPoints) {
            Point point = points[i % numberOfPoints];
            Point nextPoint1 = points[(i + 1) % numberOfPoints];
            Point nextPoint2 = points[(i + 2) % numberOfPoints];
            if (endOfContour) {
                if (point.endOfContour) {
                    ++i;
                    continue;
                }
                this.moveTo(path, point);
                endOfContour = false;
                startingPoint = point;
                offCurveStartPoint = null;
                if (!point.onCurve && !nextPoint1.onCurve) {
                    offCurveStartPoint = point;
                    startingPoint = this.midValue(point, nextPoint1);
                    this.moveTo(path, startingPoint);
                }
            }
            if (point.onCurve) {
                offCurveStartPoint = null;
            }
            if (point.onCurve && nextPoint1.onCurve) {
                this.lineTo(path, nextPoint1);
                ++i;
                if (!point.endOfContour && !nextPoint1.endOfContour) continue;
                endOfContour = true;
                this.closePath(path);
                continue;
            }
            if (point.onCurve && !nextPoint1.onCurve && nextPoint2.onCurve) {
                if (nextPoint1.endOfContour) {
                    this.quadTo(path, nextPoint1, startingPoint);
                } else {
                    this.quadTo(path, nextPoint1, nextPoint2);
                }
                if (nextPoint1.endOfContour || nextPoint2.endOfContour) {
                    endOfContour = true;
                    this.closePath(path);
                }
                i += 2;
                continue;
            }
            if (offCurveStartPoint != null && !nextPoint1.onCurve && !nextPoint2.onCurve) {
                this.quadTo(path, nextPoint1, this.midValue(nextPoint1, nextPoint2));
                if (point.endOfContour || nextPoint1.endOfContour || nextPoint2.endOfContour) {
                    this.quadTo(path, nextPoint2, this.midValue(nextPoint2, offCurveStartPoint));
                    this.quadTo(path, offCurveStartPoint, startingPoint);
                    endOfContour = true;
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            if (point.onCurve && !nextPoint1.onCurve && !nextPoint2.onCurve) {
                this.quadTo(path, nextPoint1, this.midValue(nextPoint1, nextPoint2));
                if (point.endOfContour || nextPoint1.endOfContour || nextPoint2.endOfContour) {
                    this.quadTo(path, nextPoint2, startingPoint);
                    endOfContour = true;
                    this.closePath(path);
                }
                i += 2;
                continue;
            }
            if (!point.onCurve && !nextPoint1.onCurve) {
                this.quadTo(path, point, this.midValue(point, nextPoint1));
                if (point.endOfContour || nextPoint1.endOfContour) {
                    endOfContour = true;
                    this.quadTo(path, nextPoint1, startingPoint);
                }
                ++i;
                continue;
            }
            if (!point.onCurve && nextPoint1.onCurve) {
                this.quadTo(path, point, nextPoint1);
                if (point.endOfContour || nextPoint1.endOfContour) {
                    endOfContour = true;
                    this.closePath(path);
                }
                ++i;
                continue;
            }
            LOG.error((Object)"Unknown glyph command!!");
            break;
        }
        return path;
    }

    private void closePath(GeneralPath path) {
        path.closePath();
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)"closePath");
        }
    }

    private void moveTo(GeneralPath path, Point point) {
        path.moveTo(point.x, point.y);
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)("moveTo: " + String.format("%d,%d", point.x, point.y)));
        }
    }

    private void lineTo(GeneralPath path, Point point) {
        path.lineTo(point.x, point.y);
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)("lineTo: " + String.format("%d,%d", point.x, point.y)));
        }
    }

    private void quadTo(GeneralPath path, Point ctrlPoint, Point point) {
        path.quadTo(ctrlPoint.x, ctrlPoint.y, point.x, point.y);
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)("quadTo: " + String.format("%d,%d %d,%d", ctrlPoint.x, ctrlPoint.y, point.x, point.y)));
        }
    }

    private int midValue(int a, int b) {
        return a + (b - a) / 2;
    }

    private Point midValue(Point point1, Point point2) {
        return new Point(this.midValue(point1.x, point2.x), this.midValue(point1.y, point2.y));
    }

    private class Point {
        private int x = 0;
        private int y = 0;
        private boolean onCurve = true;
        private boolean endOfContour = false;

        Point(int xValue, int yValue, boolean onCurveValue, boolean endOfContourValue) {
            this.x = xValue;
            this.y = yValue;
            this.onCurve = onCurveValue;
            this.endOfContour = endOfContourValue;
        }

        Point(int xValue, int yValue) {
            this(xValue, yValue, false, false);
        }

        public String toString() {
            return String.format("Point(%d,%d,%s,%s)", this.x, this.y, this.onCurve ? "onCurve" : "", this.endOfContour ? "endOfContour" : "");
        }
    }
}

