/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.encoding;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class Encoding {
    private static final String NOTDEF = ".notdef";
    private static final Map<String, String> NAME_TO_CHARACTER = new HashMap<String, String>();
    private static final Map<String, String> CHARACTER_TO_NAME = new HashMap<String, String>();
    protected Map<Integer, String> codeToName = new HashMap<Integer, String>();
    protected Map<String, Integer> nameToCode = new HashMap<String, Integer>();

    protected void addCharacterEncoding(int code, String name) {
        this.codeToName.put(code, name);
        this.nameToCode.put(name, code);
    }

    public Integer getCode(String name) {
        return this.nameToCode.get(name);
    }

    public String getName(int code) {
        String name = this.codeToName.get(code);
        if (name == null) {
            name = NOTDEF;
        }
        return name;
    }

    public String getNameFromCharacter(char c) throws IOException {
        String name = CHARACTER_TO_NAME.get(Character.valueOf(c));
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        return Encoding.getCharacter(this.getName(code));
    }

    public static String getCharacter(String name) {
        String character = NAME_TO_CHARACTER.get(name);
        if (character == null) {
            character = name;
        }
        return character;
    }

    public Map<Integer, String> getCodeToNameMap() {
        return Collections.unmodifiableMap(this.codeToName);
    }
}

