/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.xmldb;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FileSplitter {
    File fDestDir;
    File fSource;

    public FileSplitter(File s, File d) {
        this.fSource = s;
        this.fDestDir = d;
        this.testFiles();
    }

    public FileSplitter(String sourceFile, String destDir) {
        this.fSource = new File(sourceFile);
        this.fDestDir = new File(destDir);
        this.testFiles();
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage: java FileSplitter sourceFile destinationDirectory\n\nexample:\njava FileSplitter source.jsp c:\\tomcat\\webapps\\your_app\\");
            System.exit(1);
        }
        new FileSplitter(args[0], args[1]).splitFile();
    }

    public void splitFile() {
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.fSource));
            BufferedWriter out = null;
            String line = null;
            String fileName = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("//--file")) {
                    int preBegin = line.indexOf(34);
                    int postEnd = line.indexOf(34, preBegin + 1);
                    fileName = line.substring(preBegin + 1, postEnd);
                    System.out.println("current file:" + fileName);
                    if (out != null) {
                        out.close();
                    }
                    out = new BufferedWriter(new FileWriter(new File(this.fDestDir, fileName)));
                    continue;
                }
                if (out == null) continue;
                out.write(line);
                out.newLine();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("ERROR: " + ioe.toString());
        }
    }

    private void testFiles() {
        if (!this.fSource.exists()) {
            System.out.println("ERROR: source file not found");
            System.exit(1);
        }
        if (!this.fSource.canRead()) {
            System.out.println("ERROR: source file not readable for this process");
            System.exit(1);
        }
        if (!this.fDestDir.exists()) {
            System.out.println("ERROR: destination directory not found");
            System.exit(1);
        }
        if (!this.fDestDir.isDirectory()) {
            System.out.println("ERROR: destination is not a directory");
            System.exit(1);
        }
        if (!this.fDestDir.canWrite()) {
            System.out.println("ERROR: destination directory not writable for this process");
            System.exit(1);
        }
    }
}

