/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import jakarta.el.ELContext;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.VariableResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.commons.el.VariableResolverImpl;
import org.dbforms.util.JspWriterBuffer;

public class PageContextBuffer
extends PageContext {
    private Exception exception;
    private ExpressionEvaluatorImpl elExprEval = new ExpressionEvaluatorImpl();
    private Hashtable nametable;
    private HttpSession session;
    private JspWriterBuffer out;
    private Servlet servlet;
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private ServletRequest request;
    private ServletResponse response;
    private String errorPageURL;
    private VariableResolverImpl variableResolver = new VariableResolverImpl((PageContext)this);
    private boolean needsSession;

    public void setAttribute(String name, Object attribute) {
        if (name == null || attribute == null) {
            throw new NullPointerException();
        }
        this.nametable.put(name, attribute);
    }

    public void setAttribute(String name, Object attribute, int scope) {
        if (name == null || attribute == null) {
            throw new NullPointerException();
        }
        switch (scope) {
            case 4: {
                break;
            }
            case 1: {
                this.setAttribute(name, attribute);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.needsSession) break;
                throw new IllegalArgumentException("Invalid scope - Page does not participate in a session");
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.nametable.get(name);
    }

    public Object getAttribute(String name, int scope) {
        Object obj = null;
        if (name == null) {
            throw new NullPointerException();
        }
        switch (scope) {
            case 1: {
                obj = this.getAttribute(name);
                break;
            }
            case 2: {
                obj = this.request.getAttribute(name);
                break;
            }
            case 3: {
                if (this.needsSession) {
                    obj = this.session.getAttribute(name);
                    break;
                }
                throw new IllegalArgumentException("Invalid scope - Page does not participate in a session");
            }
            case 4: {
                obj = this.servletContext.getAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
        return obj;
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return this.nametable.keys();
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (!this.needsSession) {
                    throw new IllegalArgumentException("Invalid scope - Page does not participate in a session");
                }
                return this.session.getAttributeNames();
            }
            case 4: {
                return this.servletContext.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    public int getAttributesScope(String name) {
        int scope = 0;
        if (this.getAttribute(name, 1) != null) {
            scope = 1;
        }
        if (this.getAttribute(name, 2) != null) {
            scope = 2;
        }
        if (this.needsSession && this.getAttribute(name, 3) != null) {
            scope = 3;
        }
        if (this.getAttribute(name, 4) != null) {
            scope = 4;
        }
        return scope;
    }

    public StringBuffer getBuffer() {
        return this.out.getBuffer();
    }

    public Exception getException() {
        return this.exception;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.elExprEval;
    }

    public JspWriter getOut() {
        return this.out;
    }

    public Object getPage() {
        return this.servlet;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public String getResult() {
        return this.out.getResult();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public Object findAttribute(String name) {
        Object obj = null;
        obj = this.getAttribute(name, 1);
        if (obj != null) {
            return obj;
        }
        obj = this.getAttribute(name, 2);
        if (obj != null) {
            return obj;
        }
        if (this.needsSession && (obj = this.getAttribute(name, 3)) != null) {
            return obj;
        }
        obj = this.getAttribute(name, 4);
        if (obj != null) {
            return obj;
        }
        return obj;
    }

    public void forward(String relativeURLPath) throws ServletException, IOException {
        if (relativeURLPath == null) {
            throw new ServletException("[PageContext.forward()] Got 'null' URL - Probably caused by a non-existent Request Time Attribute Value.");
        }
        String path = this.decodePath(relativeURLPath);
        RequestDispatcher requestDispatcher = this.servletContext.getRequestDispatcher(path);
        requestDispatcher.forward(this.request, this.response);
    }

    public void handlePageException(Throwable t) throws IOException, ServletException {
        this.request.setAttribute("jakarta.servlet.jsp.jspException", (Object)t);
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException ise) {
                this.include(this.errorPageURL);
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof JspException) {
                Throwable rootCause = ((JspException)t).getRootCause();
                if (rootCause != null) {
                    throw new ServletException(t.getMessage(), rootCause);
                }
                throw new ServletException(t);
            }
            throw new ServletException(t);
        }
    }

    public void handlePageException(Exception e) throws ServletException, IOException {
        if (this.errorPageURL.equals("")) {
            System.out.println("Unhandled Page Exception:");
            e.printStackTrace();
            throw new ServletException("An unhandled Page Exception occurred");
        }
        this.setAttribute("jakarta.servlet.jsp.jspException", e, 2);
        this.forward(this.errorPageURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(String relativeURLPath) throws ServletException, IOException {
        if (relativeURLPath == null) {
            throw new ServletException("[PageContext.include()] Got 'null' URL. Probably caused  by a non-existent Request Time Attribute Value.");
        }
        this.out.flush();
        String path = this.decodePath(relativeURLPath);
        RequestDispatcher requestDispatcher = this.servletContext.getRequestDispatcher(path);
        if (requestDispatcher == null) {
            InputStream is = this.servletContext.getResourceAsStream(relativeURLPath);
            if (is == null) {
                throw new ServletException("[PageContext.include()] Unable to obtain include resource " + relativeURLPath);
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(is));){
                int c;
                while ((c = in.read()) > 0) {
                    this.out.write(c);
                }
            }
        } else {
            HttpServletRequest httpReq = (HttpServletRequest)this.request;
            String attrib = httpReq.getRequestURI();
            if (attrib != null) {
                this.request.setAttribute("jakarta.servlet.include.request_uri", (Object)attrib);
            }
            if ((attrib = httpReq.getServletPath()) != null) {
                this.request.setAttribute("jakarta.servlet.include.servlet_path", (Object)attrib);
            }
            if ((attrib = httpReq.getPathInfo()) != null) {
                this.request.setAttribute("jakarta.servlet.include.path_info", (Object)attrib);
            }
            if ((attrib = httpReq.getQueryString()) != null) {
                this.request.setAttribute("jakarta.servlet.include.query_string", (Object)attrib);
            }
            requestDispatcher.include(this.request, this.response);
        }
    }

    public void include(String relativeURLPath, boolean flush) throws ServletException, IOException {
        this.include(relativeURLPath);
        this.out.flush();
    }

    public void initialize(Servlet aservlet, ServletRequest arequest, ServletResponse aresponse, String aerrorPageURL, boolean aneedsSession, int bufferSize, boolean autoFlush) {
        this.servlet = aservlet;
        this.request = arequest;
        this.response = aresponse;
        this.errorPageURL = aerrorPageURL;
        this.needsSession = aneedsSession;
        if (this.needsSession) {
            this.session = ((HttpServletRequest)this.request).getSession();
        }
        this.nametable = new Hashtable();
        this.out = new JspWriterBuffer(bufferSize, autoFlush, this.response);
        this.exception = null;
        this.servletConfig = this.servlet.getServletConfig();
        this.servletContext = this.servletConfig.getServletContext();
    }

    public void release() {
        this.servlet = null;
        this.request = null;
        this.response = null;
        this.errorPageURL = null;
        this.nametable = null;
        this.out = null;
        this.exception = null;
        this.servletConfig = null;
        this.servletContext = null;
    }

    public void removeAttribute(String name) {
        this.nametable.remove(name);
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Invalid scope - Can't remove attribute from REQUEST_SCOPE");
            }
            case 3: {
                if (this.needsSession) break;
                throw new IllegalArgumentException("Invalid Scope - Page does not participate in an HTTP session");
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Scope");
            }
        }
    }

    private String decodePath(String relativeURLPath) {
        String path;
        if (relativeURLPath.startsWith("/")) {
            path = relativeURLPath;
        } else {
            path = ((HttpServletRequest)this.request).getServletPath();
            path = path.substring(0, path.lastIndexOf("/"));
            path = path + "/" + relativeURLPath;
        }
        return path;
    }

    public ELContext getELContext() {
        return null;
    }
}

