/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import java.util.Vector;
import org.dbforms.config.DbFormsErrors;
import org.dbforms.taglib.TagSupportWithScriptHandler;

public class DbXmlErrorsTag
extends TagSupportWithScriptHandler
implements TryCatchFinally {
    private transient DbFormsErrors errors;
    private String caption = "Error:";
    private String name = "errors";

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.errors = (DbFormsErrors)pageContext.getServletContext().getAttribute("dbformsErrors");
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.name = "errors";
        this.caption = "Error:";
        this.errors = null;
    }

    public int doStartTag() throws JspException {
        Vector<String> transformedErrors = new Vector<String>();
        Vector originalErrors = (Vector)this.pageContext.getAttribute(this.name, 2);
        if (this.errors == null) {
            throw new JspException("XML error handler is disabled, please supply xml error file on startup or use error tag instead!");
        }
        if (originalErrors != null && originalErrors.size() > 0) {
            for (Exception ex : originalErrors) {
                String result = this.errors.getXMLErrorMessage(ex.getMessage());
                if (result == null) continue;
                transformedErrors.add(result);
            }
            StringBuffer results = new StringBuffer();
            results.append(this.caption);
            results.append("<ul>");
            for (int i = 0; i < transformedErrors.size(); ++i) {
                results.append("<li>");
                results.append(transformedErrors.elementAt(i));
                results.append("</li>");
            }
            results.append("</ul>");
            JspWriter writer = this.pageContext.getOut();
            try {
                writer.print(results.toString());
            }
            catch (IOException e) {
                throw new JspException(e.toString());
            }
        }
        return 1;
    }
}

