/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.taglib.DataContainer;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.KeyValuePair;
import org.dbforms.util.Util;

public class DbRadioTag
extends DbBaseHandlerTag
implements DataContainer,
TryCatchFinally {
    private static Log logCat = LogFactory.getLog((String)DbRadioTag.class.getName());
    private List embeddedData = null;
    private String growDirection;
    private String growSize = "0";

    @Override
    public void setEmbeddedData(List embeddedData) {
        this.embeddedData = embeddedData;
    }

    public void setGrowDirection(String growDirection) {
        this.growDirection = growDirection;
    }

    public String getGrowDirection() {
        return this.growDirection;
    }

    public void setGrowSize(String growSize) {
        this.growSize = growSize;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        StringBuffer tagBuf = new StringBuffer();
        String currentValue = this.getFormFieldValue();
        if (Util.isNull(currentValue)) {
            currentValue = this.getDefaultValue();
        }
        if (this.embeddedData != null) {
            int embeddedDataSize = this.embeddedData.size();
            if (this.hasReadOnlySet() || this.getParentForm().hasReadOnlySet()) {
                for (int i = 0; i < embeddedDataSize; ++i) {
                    String onclick;
                    KeyValuePair aKeyValuePair = (KeyValuePair)this.embeddedData.get(i);
                    String aKey = aKeyValuePair.getKey();
                    if (!aKey.equals(currentValue)) continue;
                    String string = onclick = this.getOnClick() != null ? this.getOnClick() : "";
                    if (onclick.lastIndexOf(";") != onclick.length() - 1) {
                        onclick = onclick + ";";
                    }
                    this.setOnClick("document.dbform['" + this.getFormFieldName() + "'][" + i + "].checked=true;" + onclick);
                    break;
                }
            }
            int maxSize = this.growSize();
            tagBuf.append("<table  BORDER=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr valign=\"top\">");
            for (int i = 0; i < embeddedDataSize; ++i) {
                KeyValuePair aKeyValuePair = (KeyValuePair)this.embeddedData.get(i);
                String aKey = aKeyValuePair.getKey();
                String aValue = aKeyValuePair.getValue();
                boolean isSelected = aKey.equals(currentValue);
                if ("horizontal".equals(this.getGrowDirection()) && maxSize != 0 && i % maxSize == 0 && i != 0) {
                    tagBuf.append("</tr><tr valign=\"top\">");
                }
                if ("vertical".equals(this.getGrowDirection()) && i != 0) {
                    tagBuf.append("</tr><tr valign=\"top\">");
                }
                tagBuf.append("<td ");
                tagBuf.append(this.prepareStyles());
                tagBuf.append(">").append(this.generateTagString(aKey, aValue, isSelected)).append("</td>");
            }
            tagBuf.append("</tr></table>");
        }
        this.getParentForm().addChildName(this.getName(), this.getFormFieldName());
        try {
            this.pageContext.getOut().write(tagBuf.toString());
            this.writeOutSpecialValues();
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.embeddedData = null;
        this.growDirection = null;
        this.growSize = "0";
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    private String generateTagString(String value, String description, boolean selected) {
        StringBuffer tagBuf = new StringBuffer();
        tagBuf.append("<input type=\"radio\" name=\"");
        tagBuf.append(this.getFormFieldName());
        tagBuf.append("\" value=\"");
        tagBuf.append(value);
        tagBuf.append("\" ");
        if (selected) {
            tagBuf.append(" checked=\"checked\" ");
        }
        if (this.getAccessKey() != null) {
            tagBuf.append(" accesskey=\"");
            tagBuf.append(this.getAccessKey());
            tagBuf.append("\"");
        }
        if (this.getTabIndex() != null) {
            tagBuf.append(" tabindex=\"");
            tagBuf.append(this.getTabIndex());
            tagBuf.append("\"");
        }
        tagBuf.append(this.prepareStyles());
        tagBuf.append(this.prepareEventHandlers());
        tagBuf.append(">\n");
        tagBuf.append(description);
        tagBuf.append("</input>");
        return tagBuf.toString();
    }

    private int growSize() {
        int res = 0;
        try {
            res = Integer.parseInt(this.growSize);
        }
        catch (NumberFormatException nfe) {
            logCat.warn((Object)(" setGrowSize(" + this.growSize + ") NumberFormatException : " + nfe.getMessage()));
        }
        return res;
    }
}

