/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.ResultSetVector;
import org.dbforms.taglib.DbBaseButtonTag;
import org.dbforms.util.MessageResources;

public class DbDeleteButtonTag
extends DbBaseButtonTag
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog(DbDeleteButtonTag.class);
    private static int uniqueID = 1;
    private String associatedRadio;
    private String confirmMessage = null;

    public void setAssociatedRadio(String associatedRadio) {
        this.associatedRadio = associatedRadio;
    }

    public String getAssociatedRadio() {
        return this.associatedRadio;
    }

    public void setConfirmMessage(String confirmMessage) {
        this.confirmMessage = confirmMessage;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.confirmMessage = null;
        this.associatedRadio = null;
        super.doFinally();
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        ++uniqueID;
        if (this.getConfirmMessage() != null) {
            String onclick;
            String string = onclick = this.getOnClick() != null ? this.getOnClick() : "";
            if (onclick.lastIndexOf(";") != onclick.length() - 1) {
                onclick = onclick + ";";
            }
            String message = this.getConfirmMessage();
            if (this.getParentForm().hasCaptionResourceSet()) {
                try {
                    message = MessageResources.getMessage((HttpServletRequest)this.pageContext.getRequest(), this.getConfirmMessage());
                }
                catch (Exception e) {
                    logCat.debug((Object)("confirm(" + this.getCaption() + ") Exception : " + e.getMessage()));
                }
            }
            this.setOnClick(onclick + "return confirm('" + message + "');");
        }
        if (this.getParentForm().isFooterReached() && ResultSetVector.isNull(this.getParentForm().getResultSetVector())) {
            return 0;
        }
        try {
            StringBuffer tagNameBuf = new StringBuffer("ac_delete");
            if (this.associatedRadio != null) {
                tagNameBuf.append("ar");
            }
            tagNameBuf.append("_");
            tagNameBuf.append(this.getTable().getId());
            if (this.associatedRadio == null) {
                tagNameBuf.append("_");
                tagNameBuf.append(this.getParentForm().getPositionPath());
            }
            tagNameBuf.append("_");
            tagNameBuf.append(uniqueID);
            String tagName = tagNameBuf.toString();
            StringBuffer tagBuf = new StringBuffer();
            if (this.associatedRadio != null) {
                tagBuf.append(this.getDataTag(tagName, "arname", this.associatedRadio));
            }
            if (this.getFollowUp() != null) {
                tagBuf.append(this.getDataTag(tagName, "fu", this.getFollowUp()));
            }
            if (this.getFollowUpOnError() != null) {
                tagBuf.append(this.getDataTag(tagName, "fue", this.getFollowUpOnError()));
            }
            tagBuf.append(this.getButtonBegin());
            tagBuf.append(" name=\"");
            tagBuf.append(tagName);
            tagBuf.append(this.getButtonEnd());
            this.pageContext.getOut().write(tagBuf.toString());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        if (this.getChoosenFlavor() == 2) {
            return 2;
        }
        return 0;
    }
}

