/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.event.WebEvent;
import org.dbforms.taglib.DataContainer;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.KeyValuePair;
import org.dbforms.util.Util;

public class DbCheckboxTag
extends DbBaseHandlerTag
implements DataContainer,
TryCatchFinally {
    private static Log logCat = LogFactory.getLog(DbCheckboxTag.class);
    private List embeddedData = null;
    private String checked;
    private String growDirection;
    private String growSize = "0";
    private String noValue;
    private String value;
    private String force = "false";

    public void setChecked(String checked) {
        this.checked = checked;
    }

    @Override
    public void setEmbeddedData(List embeddedData) {
        this.embeddedData = embeddedData;
    }

    public void setForce(String b) {
        this.force = b;
    }

    public String getForce() {
        return this.force;
    }

    public void setGrowDirection(String growDirection) {
        this.growDirection = growDirection;
    }

    public String getGrowDirection() {
        return this.growDirection;
    }

    public void setGrowSize(String growSize) {
        try {
            int grow = Integer.parseInt(growSize);
            this.growSize = grow > 0 ? growSize : "0";
        }
        catch (NumberFormatException nfe) {
            logCat.warn((Object)(" setGrowSize(" + growSize + ") NumberFormatException : " + nfe.getMessage()));
            this.growSize = "0";
        }
    }

    public String getGrowSize() {
        return this.growSize;
    }

    public void setNovalue(String noValue) {
        this.noValue = noValue;
    }

    public String getNovalue() {
        return this.noValue;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        String onclick;
        StringBuffer tagBuf = new StringBuffer();
        WebEvent we = this.getParentForm().getWebEvent();
        String currentValue = this.getFormFieldValue();
        String string = onclick = this.getOnClick() != null ? this.getOnClick() : "";
        if (onclick.lastIndexOf(";") != onclick.length() - 1) {
            onclick = onclick + ";";
        }
        this.getParentForm().addChildName(this.getName(), this.getFormFieldName());
        if (this.embeddedData == null) {
            boolean isSelected;
            boolean bl = isSelected = (!this.getParentForm().isFooterReached() || we != null && we.getType().equals("navReload")) && this.getValue() != null && this.getValue().equals(currentValue) || this.getParentForm().isFooterReached() && this.hasCheckedSet();
            if (Util.getTrue(this.getForce())) {
                isSelected = this.hasCheckedSet();
            }
            if (this.hasReadOnlySet() || this.getParentForm().hasReadOnlySet()) {
                this.setOnClick("this.checked=" + isSelected + ";" + onclick);
            }
            tagBuf.append(this.generateTagString(this.getValue(), "", isSelected));
        } else {
            int embeddedDataSize = this.embeddedData.size();
            int maxSize = Integer.parseInt(this.getGrowSize());
            tagBuf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr valign=\"top\">");
            for (int i = 0; i < embeddedDataSize; ++i) {
                KeyValuePair aKeyValuePair = (KeyValuePair)this.embeddedData.get(i);
                String aKey = aKeyValuePair.getKey();
                String aValue = aKeyValuePair.getValue();
                boolean isSelected = aKey.equals(currentValue);
                if (this.hasReadOnlySet() || this.getParentForm().hasReadOnlySet()) {
                    this.setOnClick("this.checked=" + isSelected + ";" + onclick);
                }
                if ("horizontal".equals(this.getGrowDirection()) && maxSize != 0 && i % maxSize == 0 && i != 0) {
                    tagBuf.append("</tr><tr valign=\"top\">");
                }
                if ("vertical".equals(this.getGrowDirection()) && i != 0) {
                    tagBuf.append("</tr><tr valign=\"top\">");
                }
                tagBuf.append("<td>").append(this.generateTagString(aKey, aValue, isSelected)).append("&nbsp;</td>");
            }
            tagBuf.append("</tr></table>");
        }
        if (!Util.isNull(this.getNovalue())) {
            tagBuf.append("<input type=\"hidden\" name=\"");
            tagBuf.append(this.getFormFieldName());
            tagBuf.append("\" value =\"");
            tagBuf.append(this.getNovalue());
            tagBuf.append("\" ");
            tagBuf.append("/>");
        }
        try {
            this.pageContext.getOut().write(tagBuf.toString());
            this.writeOutSpecialValues();
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.embeddedData = null;
        this.checked = null;
        this.growDirection = null;
        this.growSize = "0";
        this.noValue = null;
        this.value = null;
        this.force = "false";
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public boolean hasCheckedSet() {
        return Util.getTrue(this.checked);
    }

    private String generateTagString(String avalue, String description, boolean selected) {
        StringBuffer tagBuf = new StringBuffer();
        tagBuf.append("<input type=\"checkbox\" name=\"");
        tagBuf.append(this.getFormFieldName());
        tagBuf.append("\" value =\"");
        tagBuf.append(avalue);
        tagBuf.append("\" ");
        if (selected) {
            tagBuf.append(" checked=\"checked\" ");
        }
        if (this.getAccessKey() != null) {
            tagBuf.append(" accesskey=\"");
            tagBuf.append(this.getAccessKey());
            tagBuf.append("\"");
        }
        if (this.getTabIndex() != null) {
            tagBuf.append(" tabindex=\"");
            tagBuf.append(this.getTabIndex());
            tagBuf.append("\"");
        }
        tagBuf.append(this.prepareStyles());
        tagBuf.append(this.prepareEventHandlers());
        tagBuf.append(">");
        tagBuf.append(description);
        tagBuf.append("</input>");
        return tagBuf.toString();
    }
}

