/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.FileHolder;
import org.dbforms.util.SqlUtil;

public class DbBlobContentTag
extends DbBaseHandlerTag
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog(DbBlobContentTag.class);
    private String dbConnectionName;

    public void setDbConnectionName(String string) {
        this.dbConnectionName = string;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        try {
            if (this.getParentForm().isFooterReached()) {
                return 6;
            }
            StringBuffer queryBuf = new StringBuffer();
            queryBuf.append("SELECT ");
            queryBuf.append(this.getField().getName());
            queryBuf.append(" FROM ");
            queryBuf.append(this.getParentForm().getTable().getName());
            queryBuf.append(" WHERE ");
            queryBuf.append(this.getParentForm().getTable().getWhereClauseForKeyFields());
            logCat.info((Object)("blobcontent query- " + queryBuf.toString()));
            StringBuffer contentBuf = new StringBuffer();
            try {
                Connection con = this.getConfig().getConnection(this.dbConnectionName);
                PreparedStatement ps = con.prepareStatement(queryBuf.toString());
                this.getParentForm().getTable().populateWhereClauseWithKeyFields(this.getKeyVal(), ps, 1);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    InputStream is = null;
                    String fileName = null;
                    if (this.getField().getType() == 4200) {
                        fileName = rs.getString(1);
                        is = SqlUtil.readDiskBlob(fileName, this.getField().getDirectory(), null);
                    } else if (this.getField().getTable().getBlobHandlingStrategy() == 1) {
                        FileHolder fh = SqlUtil.readFileHolderBlob(rs);
                        is = fh.getInputStreamFromBuffer();
                    } else {
                        is = SqlUtil.readDbFieldBlob(rs);
                    }
                    if (is != null) {
                        try {
                            int read;
                            BufferedReader br = new BufferedReader(new InputStreamReader(is));
                            char[] c = new char[1024];
                            while ((read = br.read(c)) != -1) {
                                contentBuf.append(c, 0, read);
                            }
                        }
                        finally {
                            is.close();
                        }
                    }
                } else {
                    logCat.info((Object)("fs- we have got no result" + queryBuf));
                }
                SqlUtil.closeConnection(con);
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            this.pageContext.getOut().write(this.escapeHTML(contentBuf.toString()));
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.dbConnectionName = null;
        super.doFinally();
    }

    private String getKeyVal() {
        return this.getParentForm().getTable().getKeyPositionString(this.getParentForm().getResultSetVector());
    }
}

