/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets.reports;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.sql.Connection;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.Field;
import org.dbforms.taglib.TextFormatterUtil;
import org.dbforms.util.MessageResources;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.Util;

public class ReportParameter {
    private static Log logCat = LogFactory.getLog(ReportParameter.class);
    private Connection connection;
    private HttpServletRequest request;
    private Locale locale;
    private ServletContext context;
    private String reportPath;
    private Map attributes;

    public ReportParameter(ServletContext context, HttpServletRequest request, Map attributes, Connection connection, String reportPath) {
        this.context = context;
        this.request = request;
        this.connection = connection;
        this.reportPath = reportPath;
        this.attributes = attributes;
        this.locale = MessageResources.getLocale(request);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getContextPath() {
        return this.context.getRealPath("") + File.separator;
    }

    public String getBaseURL() {
        return Util.getBaseURL(this.request);
    }

    public String getMessage(String msg) {
        return MessageResources.getMessage(this.request, msg);
    }

    public String getParameter(String param) {
        return ParseUtil.getParameter(this.request, param);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public String getStringValue(Object obj, String pattern) {
        try {
            Field field = new Field();
            field.setTypeByObject(obj);
            return TextFormatterUtil.FormatText(field, this.locale, pattern, obj);
        }
        catch (Exception e) {
            logCat.error((Object)e);
            return e.getMessage();
        }
    }

    public String getStringValue(Object obj) {
        return this.getStringValue(obj, null);
    }
}

