/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.dbforms.servlets.reports.LineReportServletAbstract;
import org.dbforms.util.MessageResources;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.ParseUtil;

public class ExcelReportServlet
extends LineReportServletAbstract {
    private static final String SHEETNAMEPARAM = "sheetname";
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private short rowCnt = 0;

    @Override
    protected String getMimeType() {
        return "application/msexcel";
    }

    @Override
    protected String getFileExtension() {
        return ".csv";
    }

    @Override
    protected void openStream(OutputStream out) throws Exception {
    }

    @Override
    protected void closeStream(OutputStream out) throws Exception {
        this.wb.write(out);
    }

    @Override
    protected void writeHeader(String[] header) throws Exception {
        short s = this.rowCnt;
        this.rowCnt = (short)(s + 1);
        HSSFRow row = this.sheet.createRow((int)s);
        for (int i = 0; i < header.length; ++i) {
            HSSFCell cell = row.createCell((short)i);
            cell.setEncoding((short)1);
            cell.setCellValue(header[i]);
        }
    }

    @Override
    protected void writeData(Object[] data) throws Exception {
        short s = this.rowCnt;
        this.rowCnt = (short)(s + 1);
        HSSFRow row = this.sheet.createRow((int)s);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            HSSFCell cell = row.createCell((short)i);
            if (data[i] instanceof Number) {
                cell.setCellValue(((Number)data[i]).doubleValue());
                continue;
            }
            if (data[i] instanceof Date) {
                cell.setCellValue((Date)data[i]);
                continue;
            }
            if (data[i] instanceof Calendar) {
                cell.setCellValue((Calendar)data[i]);
                continue;
            }
            cell.setEncoding((short)1);
            cell.setCellValue(data[i].toString());
        }
    }

    @Override
    protected void process(HttpServletRequest request, HttpServletResponse response) {
        String sheetname = ParseUtil.getParameter(request, SHEETNAMEPARAM, MessageResourcesInternal.getMessage("dbforms.new_worksheet", MessageResources.getLocale(request)));
        this.wb = new HSSFWorkbook();
        this.sheet = this.wb.createSheet(sheetname);
        this.rowCnt = 0;
        super.process(request, response);
    }
}

