/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist.dao;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.Table;
import org.dbforms.event.datalist.dao.DataSourceFactory;

public class DataSourceSessionList
implements HttpSessionBindingListener {
    private static Log logCat = LogFactory.getLog((String)DataSourceSessionList.class.getName());
    private Map ht = new HashMap();

    private DataSourceSessionList() {
    }

    public static synchronized DataSourceSessionList getInstance(HttpServletRequest request) {
        DataSourceSessionList ds = (DataSourceSessionList)request.getSession().getAttribute("org.dbforms.event.datalist.dao.DataSourceSessionList");
        if (ds == null) {
            ds = new DataSourceSessionList();
            request.getSession().setAttribute("org.dbforms.event.datalist.dao.DataSourceSessionList", (Object)ds);
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceFactory get(Table table, HttpServletRequest request) {
        Map map = this.ht;
        synchronized (map) {
            DataSourceFactory result = (DataSourceFactory)this.ht.get(this.getKey(table, request));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Table table, HttpServletRequest request, DataSourceFactory ds) throws SQLException {
        Map map = this.ht;
        synchronized (map) {
            this.ht.put(this.getKey(table, request), ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceFactory remove(Table table, HttpServletRequest request) {
        Map map = this.ht;
        synchronized (map) {
            DataSourceFactory result = (DataSourceFactory)this.ht.remove(this.getKey(table, request));
            if (result != null) {
                result.close();
            }
            return result;
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent event) {
        Map map = this.ht;
        synchronized (map) {
            logCat.info((Object)"valueUnbound called");
            for (Object obj : this.ht.values()) {
                DataSourceFactory qry = (DataSourceFactory)obj;
                qry.close();
            }
            this.ht.clear();
        }
    }

    private String getKey(Table table, HttpServletRequest request) {
        String refSource = request.getRequestURI();
        refSource = refSource + "?" + table.getName();
        return refSource;
    }
}

