/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.JDBCDataHelper;
import org.dbforms.config.ResultSetVector;
import org.dbforms.event.datalist.dao.DataSource;
import org.dbforms.util.FileHolder;
import org.dbforms.util.UniqueIDGenerator;
import org.dbforms.util.Util;

public class DataSourceJDBC
extends DataSource {
    private static Log logCat = LogFactory.getLog(DataSourceJDBC.class);
    private Connection connection;
    private List data = new ArrayList();
    private Map keys = new HashMap();
    private ResultSet rs;
    private Statement stmt;
    private String connectionName;
    private String query;
    private String sqlFilter;
    private String tableList;
    private String whereClause;
    private FieldValue[] filterConstraint;
    private FieldValue[] orderConstraint;
    private FieldValue[] sqlFilterParams;
    private boolean calcRowCount = false;
    private boolean fetchedAll = false;
    private int colCount;
    private int rowCount = 0;

    public void setCalcRowCount(boolean calcRowCount) {
        this.calcRowCount = calcRowCount;
    }

    public boolean isCalcRowCount() {
        return this.calcRowCount;
    }

    @Override
    public void setSelect(String tableList, String whereClause) {
        this.tableList = tableList;
        this.whereClause = whereClause;
    }

    @Override
    public void setSelect(FieldValue[] filterConstraint, FieldValue[] orderConstraint, String sqlFilter, FieldValue[] sqlFilterParams) {
        this.filterConstraint = filterConstraint;
        this.orderConstraint = orderConstraint;
        this.sqlFilter = sqlFilter;
        this.sqlFilterParams = sqlFilterParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDelete(DbEventInterceptorData interceptorData, String keyValuesStr) throws SQLException {
        FieldValues fieldValues = null;
        if (this.getTable().containsDiskblob()) {
            ResultSet diskblobs = null;
            StringBuffer queryBuf = new StringBuffer();
            queryBuf.append(this.getTable().getDisblobSelectStatement());
            queryBuf.append(" WHERE ");
            queryBuf.append(this.getTable().getWhereClauseForKeyFields());
            try (PreparedStatement diskblobsPs = interceptorData.getConnection().prepareStatement(queryBuf.toString());){
                this.getTable().populateWhereClauseWithKeyFields(keyValuesStr, diskblobsPs, 1);
                diskblobs = diskblobsPs.executeQuery();
                try {
                    ResultSetVector rsv = new ResultSetVector(this.getTable(), this.getTable().getDiskblobs());
                    rsv.addResultSet(interceptorData, diskblobs);
                    if (!ResultSetVector.isNull(rsv)) {
                        rsv.moveFirst();
                        fieldValues = rsv.getCurrentRowAsFieldValues();
                    }
                }
                finally {
                    diskblobs.close();
                }
            }
        }
        try (PreparedStatement ps = interceptorData.getConnection().prepareStatement(this.getTable().getDeleteStatement());){
            this.getTable().populateWhereClauseWithKeyFields(keyValuesStr, ps, 1);
            ps.executeUpdate();
            if (fieldValues != null) {
                this.deleteBlobFilesFromDisk(fieldValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doInsert(DbEventInterceptorData interceptorData, FieldValues fieldValues) throws SQLException {
        try (PreparedStatement ps = interceptorData.getConnection().prepareStatement(this.getTable().getInsertStatement(fieldValues));){
            this.fillWithData(ps, fieldValues);
            ps.executeUpdate();
        }
        this.saveBlobFilesToDisk(fieldValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdate(DbEventInterceptorData interceptorData, FieldValues fieldValues, String keyValuesStr) throws SQLException {
        try (PreparedStatement ps = interceptorData.getConnection().prepareStatement(this.getTable().getUpdateStatement(fieldValues));){
            int col = this.fillWithData(ps, fieldValues);
            this.getTable().populateWhereClauseWithKeyFields(keyValuesStr, ps, col);
            ps.executeUpdate();
        }
        this.saveBlobFilesToDisk(fieldValues);
    }

    @Override
    protected void setConnection(Connection con, String dbConnectionName) {
        this.close();
        this.connectionName = Util.isNull(dbConnectionName) ? "default" : dbConnectionName;
    }

    @Override
    protected final Object[] getRow(int i) throws SQLException {
        Object[] result = null;
        if (i >= 0) {
            if (i < this.data.size()) {
                result = (Object[])this.data.get(i);
            } else if (!this.fetchedAll) {
                while (this.rs.next()) {
                    this.addRow();
                    if (i >= this.data.size()) continue;
                    result = (Object[])this.data.get(i);
                    break;
                }
                this.checkResultSetEnd();
            }
        }
        return result;
    }

    @Override
    protected final void close() {
        if (this.data != null) {
            this.data.clear();
        }
        if (this.keys != null) {
            this.keys.clear();
        }
        this.closeConnection();
        this.fetchedAll = false;
    }

    @Override
    protected final int findStartRow(String startRow) throws SQLException {
        int result = 0;
        boolean found = false;
        if (startRow != null) {
            Integer i = (Integer)this.keys.get(startRow);
            if (i != null) {
                result = i;
                found = true;
            }
            if (!found && !this.fetchedAll) {
                while (this.rs.next()) {
                    String key = this.addRow();
                    if (!startRow.equals(key)) continue;
                    result = this.data.size() - 1;
                    break;
                }
                this.checkResultSetEnd();
            }
        }
        return result;
    }

    @Override
    protected final boolean hasMore(int i) throws SQLException {
        return !this.fetchedAll || i < this.size();
    }

    @Override
    protected void open() throws SQLException {
        if (!this.fetchedAll && this.rs == null) {
            if (this.connection == null || this.connection.isClosed()) {
                try {
                    this.connection = DbFormsConfigRegistry.instance().lookup().getConnection(this.connectionName);
                }
                catch (Exception e) {
                    logCat.error((Object)"open", (Throwable)e);
                }
            }
            if (this.connection == null) {
                throw new SQLException("no connection found!");
            }
            if (Util.isNull(this.whereClause)) {
                this.query = this.getTable().getSelectQuery(this.getTable().getFields(), this.filterConstraint, this.orderConstraint, this.sqlFilter, 0);
                this.stmt = this.connection.prepareStatement(this.query);
                if (this.stmt == null) {
                    throw new SQLException("no statement: " + this.query);
                }
                this.rs = this.getTable().getDoSelectResultSet(this.filterConstraint, this.orderConstraint, this.sqlFilterParams, 0, (PreparedStatement)this.stmt);
            } else {
                this.query = this.getTable().getFreeFormSelectQuery(this.getTable().getFields(), this.whereClause, this.tableList);
                this.stmt = this.connection.createStatement();
                if (this.stmt == null) {
                    throw new SQLException("no statement");
                }
                this.rs = this.stmt.executeQuery(this.query);
            }
            ResultSetMetaData rsmd = this.rs.getMetaData();
            this.colCount = rsmd.getColumnCount();
            if (this.isCalcRowCount()) {
                Field f = new Field();
                f.setName("count(*) cnt");
                Vector<Field> v = new Vector<Field>();
                v.add(f);
                ResultSet prs = null;
                if (Util.isNull(this.whereClause)) {
                    String pquery = this.getTable().getSelectQuery(v, this.filterConstraint, this.orderConstraint, this.sqlFilter, 0);
                    PreparedStatement pstmt = this.connection.prepareStatement(pquery);
                    if (pstmt == null) {
                        throw new SQLException("no statement: " + pquery);
                    }
                    prs = this.getTable().getDoSelectResultSet(this.filterConstraint, this.orderConstraint, this.sqlFilterParams, 0, pstmt);
                } else {
                    String pquery = this.getTable().getFreeFormSelectQuery(v, this.whereClause, this.tableList);
                    Statement pstmt = this.connection.createStatement();
                    if (pstmt == null) {
                        throw new SQLException("no statement");
                    }
                    prs = pstmt.executeQuery(pquery);
                }
                prs.next();
                this.rowCount = prs.getInt(prs.findColumn("cnt"));
            }
        }
    }

    @Override
    protected final int size() throws SQLException {
        if (!this.fetchedAll) {
            while (this.rs.next()) {
                try {
                    this.addRow();
                }
                catch (Exception e) {
                    logCat.error((Object)"size", (Throwable)e);
                    break;
                }
            }
            this.closeConnection();
        }
        return this.data.size();
    }

    protected int getRowCount() {
        return this.rowCount;
    }

    private String addRow() throws SQLException {
        Integer j = new Integer(this.data.size());
        Object[] objectRow = new Object[this.colCount];
        String[] stringRow = new String[this.colCount];
        for (int i = 0; i < this.colCount; ++i) {
            objectRow[i] = JDBCDataHelper.getData(this.rs, this.getTable().getField(i).getEscaper(), i + 1);
            stringRow[i] = objectRow[i] != null ? objectRow[i].toString() : null;
        }
        this.data.add(objectRow);
        String key = this.getTable().getKeyPositionString(stringRow);
        this.keys.put(key, j);
        return key;
    }

    private void checkResultSetEnd() throws SQLException {
        if (this.rs.getRow() != 0 && this.rs.next()) {
            this.addRow();
        }
        if (this.rs.getRow() == 0) {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        this.fetchedAll = true;
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                logCat.info((Object)"closeConnection", (Throwable)e);
            }
            this.rs = null;
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException e) {
                logCat.info((Object)"closeConnection", (Throwable)e);
            }
            this.stmt = null;
        }
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                logCat.info((Object)"closeConnection", (Throwable)e);
            }
            this.connection = null;
        }
    }

    private int fillWithData(PreparedStatement ps, FieldValues fieldValues) throws SQLException {
        Iterator e = fieldValues.keys();
        int col = 1;
        while (e.hasNext()) {
            String fieldName = (String)e.next();
            Field curField = this.getTable().getFieldByName(fieldName);
            if (curField == null) continue;
            FieldValue fv = fieldValues.get(fieldName);
            logCat.debug((Object)("Retrieved curField:" + curField.getName() + " type:" + curField.getType()));
            int fieldType = curField.getType();
            Object value = null;
            if (fieldType == 2004) {
                value = fv.getFileHolder() == null ? fv.getFieldValue() : fv.getFileHolder();
            } else if (fieldType == 4200) {
                FileHolder fileHolder = fv.getFileHolder();
                String fileName = fileHolder.getFileName();
                if (curField.hasEncodedSet()) {
                    int dotIndex = fileName.lastIndexOf(46);
                    String suffix = dotIndex != -1 ? fileName.substring(dotIndex) : "";
                    fileHolder.setFileName(UniqueIDGenerator.getUniqueID() + suffix);
                    value = fileHolder.getFileName();
                } else {
                    value = fileName;
                }
            } else {
                value = fv.getFieldValueAsObject();
            }
            logCat.info((Object)("field=" + curField.getName() + " col=" + col + " value=" + value + " type=" + fieldType));
            JDBCDataHelper.fillWithData(ps, curField.getEscaper(), col, value, fieldType, this.getTable().getBlobHandlingStrategy());
            ++col;
        }
        return col;
    }
}

