/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist.dao;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.ResultSetVector;
import org.dbforms.config.Table;
import org.dbforms.event.datalist.dao.DataSource;
import org.dbforms.util.ReflectionUtil;
import org.dbforms.util.Util;

public class DataSourceFactory {
    private static Log logCat = LogFactory.getLog((String)DataSourceFactory.class.getName());
    private DataSource dataHandler;

    public DataSourceFactory(String dbConnectionName, Connection connection, Table table) throws SQLException {
        String dataAccessClass = table.getDataAccessClass();
        if (Util.isNull(dataAccessClass)) {
            dataAccessClass = "org.dbforms.event.datalist.dao.DataSourceJDBC";
        }
        try {
            this.dataHandler = (DataSource)ReflectionUtil.newInstance(dataAccessClass);
            this.dataHandler.setTable(table);
            this.dataHandler.setConnection(connection, dbConnectionName);
        }
        catch (Exception e) {
            logCat.error((Object)e);
        }
    }

    public ResultSetVector getCurrent(DbEventInterceptorData interceptorData, String position, int count) throws SQLException {
        return this.dataHandler.getCurrent(interceptorData, position, count);
    }

    public DataSource getDataHandler() {
        return this.dataHandler;
    }

    public ResultSetVector getFirst(DbEventInterceptorData interceptorData, int count) throws SQLException {
        return this.dataHandler.getFirst(interceptorData, count);
    }

    public ResultSetVector getLast(DbEventInterceptorData interceptorData, int count) throws SQLException {
        return this.dataHandler.getLast(interceptorData, count);
    }

    public ResultSetVector getNext(DbEventInterceptorData interceptorData, String position, int count) throws SQLException {
        return this.dataHandler.getNext(interceptorData, position, count);
    }

    public ResultSetVector getPrev(DbEventInterceptorData interceptorData, String position, int count) throws SQLException {
        return this.dataHandler.getPrev(interceptorData, position, count);
    }

    public void setSelect(FieldValue[] filterConstraint, FieldValue[] orderConstraint, String sqlFilter, FieldValue[] sqlFilterParams) {
        this.dataHandler.setSelect(filterConstraint, orderConstraint, sqlFilter, sqlFilterParams);
    }

    public void setSelect(String tableList, String whereClause) throws SQLException {
        this.dataHandler.setSelect(tableList, whereClause);
    }

    public void close() {
        this.dataHandler.close();
    }

    public void doDelete(DbEventInterceptorData interceptorData, String keyValuesStr) throws SQLException {
        this.dataHandler.doDelete(interceptorData, keyValuesStr);
    }

    public void doInsert(DbEventInterceptorData interceptorData, FieldValues fieldValues) throws SQLException {
        this.dataHandler.doInsert(interceptorData, fieldValues);
    }

    public void doUpdate(DbEventInterceptorData interceptorData, FieldValues fieldValues, String keyValuesStr) throws SQLException {
        this.dataHandler.doUpdate(interceptorData, fieldValues, keyValuesStr);
    }
}

