/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.FieldValues;
import org.dbforms.event.ValidationEvent;
import org.dbforms.event.datalist.dao.DataSourceFactory;
import org.dbforms.event.datalist.dao.DataSourceSessionList;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class UpdateEvent
extends ValidationEvent {
    private static Log logCat = LogFactory.getLog((String)UpdateEvent.class.getName());

    public UpdateEvent(Integer tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        super(tableId, keyId, request, config);
    }

    public UpdateEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        super(StringUtil.getEmbeddedStringAsInteger(action, 2, '_'), StringUtil.getEmbeddedString(action, 3, '_'), request, config);
    }

    @Override
    public FieldValues getFieldValues() {
        String s = ParseUtil.getParameter(this.getRequest(), "overridefieldcheck_" + this.getTable().getId());
        boolean flag = "true".equalsIgnoreCase(s);
        return this.getFieldValues(flag);
    }

    @Override
    public void processEvent(Connection con) throws SQLException {
        if (!this.hasUserPrivileg(2)) {
            String s = MessageResourcesInternal.getMessage("dbforms.events.update.nogrant", this.getRequest().getLocale(), new String[]{this.getTable().getName()});
            throw new SQLException(s);
        }
        String keyValuesStr = this.getKeyValues();
        if (Util.isNull(keyValuesStr)) {
            logCat.error((Object)"::processEvent - at least one key is required per table, check your dbforms-config.xml");
            return;
        }
        FieldValues fieldValues = this.getFieldValues();
        if (fieldValues.size() == 0) {
            logCat.info((Object)"no parameters to update found");
            return;
        }
        DbEventInterceptorData interceptorData = new DbEventInterceptorData(this.getRequest(), this.getConfig(), con, this.getTable());
        interceptorData.setAttribute("fieldValues", fieldValues);
        interceptorData.setAttribute("keyValues", keyValuesStr);
        int operation = this.getTable().processInterceptors(2, interceptorData);
        if (operation == 0 && fieldValues.size() > 0) {
            DataSourceSessionList ds = DataSourceSessionList.getInstance(this.getRequest());
            DataSourceFactory qry = ds.get(this.getTable(), this.getRequest());
            boolean own = false;
            if (qry == null) {
                qry = new DataSourceFactory((String)interceptorData.getAttribute("connectionName"), interceptorData.getConnection(), this.getTable());
                own = true;
            }
            qry.doUpdate(interceptorData, fieldValues, keyValuesStr);
            if (own) {
                qry.close();
            } else {
                ds.remove(this.getTable(), this.getRequest());
            }
            this.getTable().processInterceptors(3, interceptorData);
        }
    }
}

