/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Properties;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.Table;

public abstract class WebEvent {
    private DbFormsConfig config;
    private HttpServletRequest request;
    private Properties properties = null;
    private String followUp;
    private String followUpOnError;
    private String type = "UNDEFINED";
    private Table table;

    public WebEvent(int tableId, HttpServletRequest request, DbFormsConfig config) {
        this.setTable(config.getTable(tableId));
        this.setRequest(request);
        this.config = config;
    }

    public DbFormsConfig getConfig() {
        return this.config;
    }

    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    public String getFollowUp() {
        if (this.followUp.indexOf("WEB-INF") > -1 || this.followUp.indexOf("META-INF") > -1) {
            System.out.println("Achtung: Zugriff auf gesch\u00fctztes Tomcat-Verzeichnis " + this.followUp + " wird blockiert.");
            this.followUp = "/error.htm";
        }
        return this.followUp;
    }

    public void setFollowUpOnError(String followUpOnError) {
        this.followUpOnError = followUpOnError;
    }

    public String getFollowUpOnError() {
        if (this.followUpOnError.indexOf("WEB-INF") > -1 || this.followUpOnError.indexOf("META-INF") > -1) {
            System.out.println("Achtung: Zugriff auf gesch\u00fctztes Tomcat-Verzeichnis " + this.followUpOnError + " wird blockiert.");
            this.followUpOnError = "/error.htm";
        }
        return this.followUpOnError;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    protected boolean hasUserPrivileg(int privileg) {
        return this.config.getTable(this.getTable().getId()).hasUserPrivileg(this.getRequest(), privileg);
    }
}

