/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.Table;
import org.dbforms.event.DatabaseEvent;
import org.dbforms.event.DatabaseEventFactory;
import org.dbforms.event.DatabaseEventFactoryImpl;
import org.dbforms.event.NavEventFactory;
import org.dbforms.event.NavEventFactoryImpl;
import org.dbforms.event.NoopEvent;
import org.dbforms.event.PageReloadEvent;
import org.dbforms.event.WebEvent;
import org.dbforms.event.eventtype.EventType;
import org.dbforms.event.eventtype.EventTypeUtil;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class EventEngine {
    private static Log logCat = LogFactory.getLog((String)EventEngine.class.getName());
    private DatabaseEventFactory dbEventFactory = DatabaseEventFactoryImpl.instance();
    private DbFormsConfig config;
    private HttpServletRequest request;
    private NavEventFactory navEventFactory = NavEventFactoryImpl.instance();
    private Vector involvedTables;

    public EventEngine(HttpServletRequest request, DbFormsConfig config) {
        this.request = request;
        this.config = config;
        this.involvedTables = this.parseInvolvedTables();
    }

    public Vector getInvolvedTables() {
        return this.involvedTables;
    }

    public WebEvent generatePrimaryEvent() {
        WebEvent e = null;
        String action = ParseUtil.getFirstParameterStartingWith(this.request, "ac_");
        String customEvent = ParseUtil.getParameter(this.request, "customEvent");
        if (Util.isNull(action) && !Util.isNull(customEvent)) {
            action = customEvent.trim();
        }
        if (Util.isNull(action)) {
            logCat.info((Object)"##### N O O P   ELEMENT ######");
            e = new NoopEvent(-1, this.request, this.config);
            this.initializeWebEvent(e);
            return e;
        }
        if (action.startsWith("re_")) {
            logCat.info((Object)"##### RELOAD  EVENT ######");
            e = new PageReloadEvent(StringUtil.getEmbeddedStringAsInteger(action, 2, '_'), this.request, this.config);
            e.setType("navReload");
            this.initializeWebEvent(e);
            return e;
        }
        action = this.getImageButtonAction(action);
        EventType eventType = EventTypeUtil.getEventType(action);
        switch (eventType.getEventGroup()) {
            case 0: {
                logCat.info((Object)"::generatePrimaryEvent - generating a database event");
                e = this.dbEventFactory.createEvent(action, this.request, this.config);
                break;
            }
            case 1: {
                logCat.info((Object)"::generatePrimaryEvent - generating a navigation event");
                e = this.navEventFactory.createEvent(action, this.request, this.config);
                break;
            }
            default: {
                logCat.error((Object)"::generatePrimaryEvent - WARNING: generating NO event. Why ?");
            }
        }
        this.setEventFollowUp(e, action);
        return e;
    }

    public Enumeration generateSecundaryEvents(Table actTable, WebEvent exclude) {
        String param;
        String res;
        Vector<DatabaseEvent> result = new Vector<DatabaseEvent>();
        int excludeTableId = -1;
        String excludeKeyId = null;
        boolean collissionDanger = false;
        if (exclude instanceof DatabaseEvent) {
            collissionDanger = true;
            excludeTableId = exclude.getTable().getId();
            excludeKeyId = ((DatabaseEvent)exclude).getKeyId();
        }
        if ((res = ParseUtil.getParameter(this.request, param = "autoupdate_" + String.valueOf(actTable.getId()))).equalsIgnoreCase("true") || res.equalsIgnoreCase("OnUpdateOnly") && exclude.getType().equals("update")) {
            Vector v;
            String paramStub = "k_" + actTable.getId() + "_";
            Enumeration keysOfCurrentTable = ParseUtil.getParametersStartingWith(this.request, paramStub).elements();
            while (keysOfCurrentTable.hasMoreElements()) {
                String aKeyParam = (String)keysOfCurrentTable.nextElement();
                String keyId = aKeyParam.substring(paramStub.length());
                logCat.info((Object)("autoaupdate debug info: keyId=" + keyId + " excludeKeyId=" + excludeKeyId));
                if (collissionDanger && excludeTableId == actTable.getId() && keyId.equals(excludeKeyId)) continue;
                DatabaseEvent e = this.dbEventFactory.createUpdateEvent(actTable.getId(), keyId, this.request, this.config);
                result.addElement(e);
            }
            if (collissionDanger && excludeTableId != actTable.getId() && (v = ParseUtil.getParametersStartingWith(this.request, paramStub = "f_" + actTable.getId() + "_" + "ins")).size() > 0) {
                String aKeyParam = (String)v.firstElement();
                String keyId = aKeyParam.substring(paramStub.length());
                keyId = StringUtil.getEmbeddedString(keyId, 0, '_');
                DatabaseEvent e = this.dbEventFactory.createInsertEvent(actTable.getId(), keyId, this.request, this.config);
                result.addElement(e);
            }
        }
        return result.elements();
    }

    private void setEventFollowUp(WebEvent e, String action) {
        String followUpOnError;
        String followUp = ParseUtil.getParameter(this.request, "data" + action + "_fu");
        if (followUp == null) {
            followUp = ParseUtil.getParameter(this.request, "fu_" + (e == null || e.getTable() == null ? -1 : e.getTable().getId()));
        }
        logCat.info((Object)("setting follow up to:" + followUp));
        if (e != null) {
            e.setFollowUp(followUp);
        }
        if ((followUpOnError = ParseUtil.getParameter(this.request, "data" + action + "_fue")) == null) {
            followUpOnError = ParseUtil.getParameter(this.request, "fue_" + (e == null || e.getTable() == null ? -1 : e.getTable().getId()));
        }
        if (followUpOnError == null) {
            followUpOnError = followUp;
        }
        logCat.info((Object)("setting follow up on Error to:" + followUpOnError));
        if (e != null) {
            e.setFollowUpOnError(followUpOnError);
        }
    }

    private String getImageButtonAction(String action) {
        if (action.endsWith(".y") || action.endsWith(".x")) {
            action = action.substring(0, action.length() - 2);
        }
        logCat.info((Object)("::getImageButtonAction - action = [" + action + "]"));
        return action;
    }

    private String setSourcePath(String contextPath, String sourcePath) {
        if (!Util.isNull(contextPath) && !Util.isNull(sourcePath) && sourcePath.startsWith(contextPath)) {
            sourcePath = contextPath.endsWith("/") ? sourcePath.substring(contextPath.length() - 1) : sourcePath.substring(contextPath.length());
        }
        return sourcePath;
    }

    private void initializeWebEvent(WebEvent e) {
        String contextPath = this.request.getContextPath();
        String sourcePath = ParseUtil.getParameter(this.request, "source");
        logCat.info((Object)("sourcePath = " + sourcePath));
        sourcePath = this.setSourcePath(contextPath, sourcePath);
        e.setFollowUp(sourcePath);
        logCat.info((Object)("followup=" + e.getFollowUp()));
    }

    private Vector parseInvolvedTables() {
        String[] invTables = ParseUtil.getParameterValues(this.request, "invtable");
        if (invTables == null) {
            return null;
        }
        Vector<Table> result = new Vector<Table>();
        for (int i = 0; i < invTables.length; ++i) {
            int tableIndex = Integer.parseInt(invTables[i]);
            Table t = this.config.getTable(tableIndex);
            result.addElement(t);
        }
        return result;
    }
}

