/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.MultipleValidationException;
import org.dbforms.event.WebEvent;
import org.dbforms.util.MessageResources;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.Util;

public abstract class DatabaseEvent
extends WebEvent {
    private static Log logCat = LogFactory.getLog((String)DatabaseEvent.class.getName());
    private String keyId;

    public DatabaseEvent(int tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        super(tableId, request, config);
        this.keyId = keyId;
    }

    public abstract FieldValues getFieldValues();

    public String getKeyId() {
        return this.keyId;
    }

    public void doValidation(String formValidatorName, ServletContext context) throws MultipleValidationException {
    }

    public abstract void processEvent(Connection var1) throws SQLException, MultipleValidationException;

    protected FieldValues getFieldValues(boolean insertMode) {
        FieldValues result = new FieldValues();
        String paramStub = "f_" + this.getTable().getId() + "_" + ("insert".equals(this.getType()) ? "ins" : "") + this.keyId + "_";
        Vector params = ParseUtil.getParametersStartingWith(this.getRequest(), paramStub);
        boolean doIt = insertMode;
        if (!doIt) {
            for (String param : params) {
                String oldValue;
                String value = ParseUtil.getParameter(this.getRequest(), param);
                doIt = !value.equals(oldValue = ParseUtil.getParameter(this.getRequest(), "o" + param));
                if (!doIt) continue;
                break;
            }
        }
        if (doIt) {
            for (String param : params) {
                int iiFieldId = Integer.parseInt(param.substring(paramStub.length()));
                Field f = this.getTable().getField(iiFieldId);
                String value = f.getEscaper().unescapeHTML(ParseUtil.getParameter(this.getRequest(), param));
                FieldValue fv = new FieldValue(f, value);
                fv.setOldValue(f.getEscaper().unescapeHTML(ParseUtil.getParameter(this.getRequest(), "o" + param)));
                fv.setPattern(ParseUtil.getParameter(this.getRequest(), "p" + param));
                fv.setLocale(MessageResources.getLocale(this.getRequest()));
                if (f.getType() == 2004 || f.getType() == 4200) {
                    fv.setFileHolder(ParseUtil.getFileHolder(this.getRequest(), "f_" + this.getTable().getId() + "_" + (insertMode ? "ins" : "") + this.keyId + "_" + iiFieldId));
                }
                result.put(fv);
            }
        }
        return result;
    }

    protected String getKeyValues() {
        String key = null;
        try {
            key = ParseUtil.getParameter(this.getRequest(), "k_" + this.getTable().getId() + "_" + this.keyId);
            key = Util.decode(key, this.getRequest().getCharacterEncoding());
            logCat.info((Object)("::getKeyValues - key: " + key));
        }
        catch (UnsupportedEncodingException e) {
            logCat.error((Object)e);
        }
        return key;
    }
}

