/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.devgui;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.dbforms.config.ForeignKey;
import org.dbforms.config.Reference;
import org.dbforms.devgui.ProjectData;
import org.dbforms.devgui.PropertyNames;

public class XMLConfigGenerator
implements PropertyNames {
    static final String[] knownFieldTypes = new String[]{"tinyint", "int", "smallint", "integer", "bigint", "float", "real", "double", "numeric", "decimal", "number", "char", "varchar", "longchar", "nvarchar", "blob", "image", "diskblob", "date", "timestamp"};
    private static final int DBMS_MYSQL = 1;
    private static final int DBMS_IBMDB2 = 2;

    public static HashMap getForeignKeyInformation(DatabaseMetaData dbmd, boolean includeCatalog, String catalogSeparator, boolean includeSchema, String schemaSeparator, Vector knownTables, boolean foreignKeyTryGetCrossReferences, Vector catalogNames, Vector schemaNames, Vector tableNames) {
        HashMap hm = null;
        if (foreignKeyTryGetCrossReferences) {
            try {
                hm = new HashMap();
                ResultSet rsk = dbmd.getCrossReference(null, null, null, null, null, null);
                while (rsk.next()) {
                    XMLConfigGenerator.addSingleReference(hm, rsk, knownTables, includeCatalog, catalogSeparator, includeSchema, schemaSeparator);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                hm = null;
            }
        }
        if (hm == null) {
            try {
                hm = new HashMap();
                for (int i = 0; i < tableNames.size(); ++i) {
                    String catalogName = (String)catalogNames.get(i);
                    String schemaName = (String)schemaNames.get(i);
                    String tableName = (String)tableNames.get(i);
                    ResultSet rsk = dbmd.getImportedKeys(catalogName, schemaName, tableName);
                    while (rsk.next()) {
                        XMLConfigGenerator.addSingleReference(hm, rsk, knownTables, includeCatalog, catalogSeparator, includeSchema, schemaSeparator);
                    }
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return hm;
    }

    public static String getForeignKeyTags(HashMap hm, String catalog, String schema, String table) {
        String hashKey = XMLConfigGenerator.emptyIfNull(schema) + "\t" + table;
        HashMap keyInfo = (HashMap)hm.get(hashKey);
        if (keyInfo == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        Collection col = keyInfo.values();
        for (ForeignKey fk : col) {
            Vector v = fk.getReferencesVector();
            sb.append("\n\t\t<foreign-key  name=\"").append(fk.getName()).append("\"").append("\n\t\t      foreignTable=\"").append(fk.getForeignTable()).append("\"").append("\n\t\t      displayType=\"").append(v.size() == 1 ? "select" : "none").append("\"").append(">\n");
            for (int jj = 0; jj < v.size(); ++jj) {
                Reference ref = (Reference)v.get(jj);
                sb.append("\t\t     <reference local=\"").append(ref.getLocal()).append("\"").append("\n\t\t              foreign=\"").append(ref.getForeign()).append("\"/>\n");
            }
            sb.append("\t\t</foreign-key>\n");
        }
        return sb.toString();
    }

    public static String createXMLOutput(ProjectData projectData, boolean createGuiMessagewindow) throws Exception {
        String jdbcDriver = projectData.getProperty("jdbcDriver");
        String jdbcURL = projectData.getProperty("jdbcURL");
        String username = projectData.getProperty("username");
        String password = projectData.getProperty("password");
        boolean includeCatalog = projectData.getProperty("includeCatalogName").equalsIgnoreCase("true");
        boolean includeSchema = projectData.getProperty("includeSchemaName").equalsIgnoreCase("true");
        boolean useAutoCommitMode = projectData.getProperty("autoCommitMode").equalsIgnoreCase("true");
        boolean useStdTypeNames = projectData.getProperty("writeStdTypeNames").equalsIgnoreCase("true");
        boolean foreignKeyDetectionActivated = !"deactivated".equalsIgnoreCase(projectData.getProperty("foreignKeyDetection"));
        boolean foreignKeyTryGetCrossReferences = "useGetCrossReferences".equalsIgnoreCase(projectData.getProperty("foreignKeyDetection"));
        boolean generateDefaultValues = true;
        Vector<String> typesVec = new Vector<String>();
        if (projectData.getProperty("examineTables").equalsIgnoreCase("true")) {
            typesVec.add("TABLE");
        }
        if (projectData.getProperty("examineViews").equalsIgnoreCase("true")) {
            typesVec.add("VIEW");
        }
        if (projectData.getProperty("examineSysTabs").equalsIgnoreCase("true")) {
            typesVec.add("SYSTEM TABLE");
        }
        String[] types = new String[typesVec.size()];
        for (int jj = 0; jj < typesVec.size(); ++jj) {
            types[jj] = (String)typesVec.get(jj);
        }
        String catalog = projectData.getProperty("catalogSelection").equalsIgnoreCase("all") ? null : projectData.getProperty("catalog");
        String schemaPattern = projectData.getProperty("schemaSelection").equalsIgnoreCase("all") ? null : projectData.getProperty("schema");
        String tableNamePattern = projectData.getProperty("tableSelection").equalsIgnoreCase("all") ? null : projectData.getProperty("tableNamePattern");
        String dateFormatTag = projectData.getProperty("dateFormat").equalsIgnoreCase("") ? "" : "\n\t<date-format>" + projectData.getProperty("dateFormat") + "</date-format>\n\n";
        System.out.println(": Retrieving metadata using the following properties ");
        System.out.println("-----------------------------------------------------");
        System.out.println("jdbcDriver=" + jdbcDriver);
        System.out.println("jdbcURL=" + jdbcURL);
        System.out.println("username=" + username);
        System.out.println("password=(hidden)");
        System.out.println("catalog=" + catalog);
        System.out.println("schemaPattern=" + schemaPattern);
        System.out.println("tableNamePattern=" + tableNamePattern);
        StringBuffer result = new StringBuffer();
        boolean showWarning = false;
        int catalogNameFailure = 0;
        int schemaNameFailure = 0;
        StringBuffer warningMessage = new StringBuffer("<html><ul>");
        Connection con = null;
        try {
            con = XMLConfigGenerator.createConnection(jdbcDriver, jdbcURL, username, password);
            result.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n\n<dbforms-config>\n");
            result.append(dateFormatTag);
            DatabaseMetaData dbmd = con.getMetaData();
            boolean checkForAutoIncFields = false;
            String autoIncColumnsQuery = "";
            String catalogPlaceholder = ":catalog";
            String schemaPlaceholder = ":schema";
            String tabnamePlaceholder = ":tabname";
            int dbms = 0;
            PreparedStatement spCall = null;
            try {
                String dbmsProductName = dbmd.getDatabaseProductName();
                if (dbmsProductName != null) {
                    if ((dbmsProductName = dbmsProductName.toLowerCase()).equals("mysql")) {
                        dbms = 1;
                        checkForAutoIncFields = true;
                        autoIncColumnsQuery = "SHOW COLUMNS FROM :tabname LIKE ?";
                    } else if (dbmsProductName.startsWith("db2")) {
                        dbms = 2;
                        checkForAutoIncFields = true;
                        autoIncColumnsQuery = "SELECT identity FROM sysibm.syscolumns WHERE tbcreator=':schema' and  tbname = ':tabname' AND name = ?";
                    }
                }
            }
            catch (SQLException dbmsProductName) {
                // empty catch block
            }
            if (includeCatalog) {
                boolean supportsCatalogInDML = false;
                try {
                    supportsCatalogInDML = dbmd.supportsCatalogsInDataManipulation();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!supportsCatalogInDML) {
                    showWarning = true;
                    warningMessage.append("<li>Your database system does not seem to support use of  <br>  catalog names in data manipulation statements. You should<br>   better not include catalog names in table names.");
                }
            }
            if (includeSchema) {
                boolean supportsSchemaInDML = false;
                try {
                    supportsSchemaInDML = dbmd.supportsSchemasInDataManipulation();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!supportsSchemaInDML) {
                    showWarning = true;
                    warningMessage.append("<li>Your database system does not seem to support use of <br>  schema names in data manipulation statements. You should <br>  better not include schema names in table names.");
                }
            }
            if (!useAutoCommitMode && !dbmd.supportsTransactions()) {
                showWarning = true;
                warningMessage.append("<li>Transaction mode not supported by DBMS, connection is <br>    automatically set to autocommit mode.");
                useAutoCommitMode = true;
            }
            if (!useAutoCommitMode) {
                con.setAutoCommit(false);
            }
            String catalogSeparator = ".";
            if (includeCatalog) {
                try {
                    catalogSeparator = dbmd.getCatalogSeparator();
                }
                catch (SQLException ex) {
                    showWarning = true;
                    warningMessage.append("<li>Error reading catalog separator from database:   <br>" + ex.getMessage() + "<br>  Using default '" + catalogSeparator + "' instead.");
                }
            }
            String schemaSeparator = ".";
            Vector<String> tableNames = new Vector<String>();
            Vector<String> catalogNames = new Vector<String>();
            Vector<String> schemaNames = new Vector<String>();
            Vector<String> knownTables = new Vector<String>();
            try {
                ResultSet tablesRS = dbmd.getTables(catalog, schemaPattern, tableNamePattern, types);
                while (tablesRS.next()) {
                    catalogNames.add(tablesRS.getString(1));
                    schemaNames.add(tablesRS.getString(2));
                    tableNames.add(tablesRS.getString(3));
                    knownTables.add("" + XMLConfigGenerator.emptyIfNull(tablesRS.getString(2)) + "\t" + XMLConfigGenerator.emptyIfNull(tablesRS.getString(3)));
                }
                tablesRS.close();
            }
            catch (SQLException ex) {
                showWarning = true;
                warningMessage.append("<li>Error while trying to read table names with <br>  catalog=" + catalog + ",<br>   schemapattern=" + schemaPattern + ",<br>   tableNamePattern=" + tableNamePattern + "<br> from database.   <br>Error message:" + ex.getMessage() + "<br>");
            }
            if (!useAutoCommitMode) {
                con.commit();
            }
            HashMap forKeys = null;
            if (foreignKeyDetectionActivated) {
                forKeys = XMLConfigGenerator.getForeignKeyInformation(dbmd, includeCatalog, catalogSeparator, includeSchema, schemaSeparator, knownTables, foreignKeyTryGetCrossReferences, catalogNames, schemaNames, tableNames);
            }
            if (!useAutoCommitMode) {
                con.commit();
            }
            if (tableNames.size() == 0) {
                showWarning = true;
                warningMessage.append("<li> No tables of type <br>(");
                for (int i = 0; i < types.length; ++i) {
                    warningMessage.append("'").append(types[i]).append("' ");
                }
                warningMessage.append(") <br>found with catalog='" + catalog + "', schemapattern='" + schemaPattern + "',<br>tablename pattern='" + tableNamePattern + "'");
            }
            boolean autoIncColumnsQueryAlwaysSucceeded = true;
            for (int i = 0; i < tableNames.size(); ++i) {
                String catalogName = (String)catalogNames.get(i);
                String schemaName = (String)schemaNames.get(i);
                String tableName = (String)tableNames.get(i);
                result.append("\t<table name=\"");
                if (includeCatalog && catalogName != null && !catalogName.equalsIgnoreCase("")) {
                    result.append(catalogName.trim()).append(catalogSeparator);
                }
                if (includeCatalog && (catalogName == null || catalogName.equalsIgnoreCase(""))) {
                    ++catalogNameFailure;
                }
                if (includeSchema && schemaName != null && !schemaName.equalsIgnoreCase("")) {
                    result.append(schemaName.trim()).append(schemaSeparator);
                }
                if (includeSchema && (schemaName == null || schemaName.equalsIgnoreCase(""))) {
                    ++schemaNameFailure;
                }
                ResultSet rsKeys = dbmd.getPrimaryKeys(catalogName, schemaName, tableName);
                Vector<String> keys = new Vector<String>();
                String defaultVisibleFields = "";
                boolean isFirst = true;
                while (rsKeys.next()) {
                    String columnName = rsKeys.getString(4);
                    keys.addElement(columnName);
                    defaultVisibleFields = isFirst ? defaultVisibleFields + columnName : defaultVisibleFields + "," + columnName;
                    isFirst = false;
                }
                rsKeys.close();
                result.append(tableName).append("\"");
                if (defaultVisibleFields.length() > 0) {
                    result.append("\n\t            defaultVisibleFields=\"" + defaultVisibleFields + "\" ");
                }
                result.append(">\n");
                if (checkForAutoIncFields) {
                    String sqlStmtPS = autoIncColumnsQuery;
                    int pos = autoIncColumnsQuery.indexOf(tabnamePlaceholder);
                    if (pos >= 0) {
                        sqlStmtPS = autoIncColumnsQuery.substring(0, pos) + tableName + autoIncColumnsQuery.substring(pos + tabnamePlaceholder.length());
                    }
                    if ((pos = sqlStmtPS.indexOf(schemaPlaceholder)) >= 0) {
                        sqlStmtPS = sqlStmtPS.substring(0, pos) + schemaName + sqlStmtPS.substring(pos + schemaPlaceholder.length());
                    }
                    if ((pos = sqlStmtPS.indexOf(catalogPlaceholder)) >= 0) {
                        sqlStmtPS = sqlStmtPS.substring(0, pos) + catalogName + sqlStmtPS.substring(pos + catalogPlaceholder.length());
                    }
                    try {
                        spCall = con.prepareStatement(sqlStmtPS);
                    }
                    catch (SQLException ex) {
                        System.err.println("Warning: Prepare of Statement \n'" + sqlStmtPS + "'\n  failed with message \n'" + ex.getMessage() + "'.\n No reason to panic, just detection auf auto-incremented \n  columns will not work. However, better send a mail to \n DbForms Mailing list to get this corrected");
                    }
                }
                ResultSet rsFields = dbmd.getColumns(catalogName, schemaName, tableName, null);
                while (rsFields.next()) {
                    String columnName = rsFields.getString(4);
                    String typeName = rsFields.getString(6);
                    int columnSize = rsFields.getInt(7);
                    int typeCode = rsFields.getInt(5);
                    String defaultValue = null;
                    if (generateDefaultValues && (defaultValue = rsFields.getString(13)) != null) {
                        if (defaultValue.length() == 0) {
                            defaultValue = null;
                        } else if (defaultValue.equals("0")) {
                            defaultValue = null;
                        }
                    }
                    typeName = XMLConfigGenerator.remapType(dbms, typeName);
                    boolean isAutoIncColumn = false;
                    if (checkForAutoIncFields && spCall != null) {
                        try {
                            spCall.setString(1, columnName);
                            ResultSet rssp = spCall.executeQuery();
                            switch (dbms) {
                                case 1: {
                                    isAutoIncColumn = rssp.next() && rssp.getString(1).equalsIgnoreCase(columnName) && rssp.getString(6).equalsIgnoreCase("auto_increment");
                                    break;
                                }
                                case 2: {
                                    isAutoIncColumn = rssp.next() && rssp.getString(1).equalsIgnoreCase("y");
                                }
                            }
                            rssp.close();
                        }
                        catch (SQLException ex) {
                            if (autoIncColumnsQueryAlwaysSucceeded) {
                                System.err.println("Warning: Reading of auto-incremented columns  \n\n  failed with message \n'" + ex.getMessage() + "'.\n No reason to panic, just detection auf auto-incremented \n  columns will not work. However, better send a mail to \n DbForms Mailing list to get this corrected");
                                autoIncColumnsQueryAlwaysSucceeded = false;
                            }
                        }
                    } else {
                        isAutoIncColumn = typeName.toLowerCase().endsWith(" identity");
                    }
                    if (useStdTypeNames && !XMLConfigGenerator.fieldTypeIsKnown(typeName)) {
                        switch (typeCode) {
                            case -6: 
                            case -5: 
                            case 4: 
                            case 5: {
                                typeName = "integer";
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                typeName = "char";
                                break;
                            }
                            case 3: {
                                typeName = "decimal";
                                break;
                            }
                            case 2: {
                                typeName = "numeric";
                                break;
                            }
                            case 6: {
                                typeName = "float";
                                break;
                            }
                            case 7: {
                                typeName = "real";
                                break;
                            }
                            case 91: {
                                typeName = "date";
                                break;
                            }
                            case 93: {
                                typeName = "timestamp";
                                break;
                            }
                            case 2004: {
                                typeName = "blob";
                                break;
                            }
                            default: {
                                System.out.println("unknown java.sql.Type '" + typeName + "'");
                            }
                        }
                    }
                    result.append("\t\t<field name=\"");
                    result.append(columnName);
                    result.append("\" fieldType=\"");
                    result.append(typeName.toLowerCase());
                    result.append("\" size=\"");
                    result.append(columnSize);
                    result.append("\"");
                    if (keys.contains(columnName)) {
                        result.append(" isKey=\"true\"");
                    }
                    if (isAutoIncColumn) {
                        result.append(" autoInc=\"true\"");
                    }
                    if (generateDefaultValues && defaultValue != null) {
                        result.append(" defaultValue=\"" + defaultValue + "\"");
                    }
                    result.append("/>\n");
                }
                rsFields.close();
                if (!useAutoCommitMode) {
                    con.commit();
                }
                if (foreignKeyDetectionActivated) {
                    result.append(XMLConfigGenerator.getForeignKeyTags(forKeys, catalogName, schemaName, tableName));
                }
                result.append("\n\t\t<!-- add \"granted-privileges\" element for security constraints -->\n\n\t</table>\n\n");
            }
            if (catalogNameFailure > 0) {
                showWarning = true;
                warningMessage.append("<li> " + catalogNameFailure + " empty catalog names not included in table name.");
            }
            if (schemaNameFailure > 0) {
                showWarning = true;
                warningMessage.append("<li> " + schemaNameFailure + " empty schema names not included in table name.");
            }
            result.append("\t<!-- ========== Connection =================================== -->\n");
            result.append("\t<!--\n");
            result.append("\tuncomment this if you have access to JNDI of an application server (see users guide for more info)\n");
            result.append("\t<dbconnection\n");
            result.append("\t\tname = \"jdbc/dbformstest\"\n");
            result.append("\t\tisJndi = \"true\"\n");
            result.append("\t/>\n");
            result.append("\t-->\n\n");
            result.append("\t<dbconnection\n");
            result.append("\t\tname   = \"" + XMLConfigGenerator.xmlClean(jdbcURL) + "\"\n");
            result.append("\t\tisJndi = \"false\"\n");
            result.append("\t\tconClass  = \"" + jdbcDriver + "\"\n");
            result.append("\t\tusername = \"" + username + "\"\n");
            result.append("\t\tpassword  = \"" + password + "\"\n");
            result.append("\t/>\n");
            result.append("</dbforms-config>");
            System.out.println("finished");
            warningMessage.append("</ul></html>");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage() + " in XMLConfigGenerator");
        }
        finally {
            try {
                if (showWarning) {
                    if (createGuiMessagewindow) {
                        JOptionPane.showMessageDialog(null, warningMessage, "Warning", 2);
                    } else {
                        System.err.println("Warning:\n " + warningMessage);
                    }
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return result.toString();
    }

    protected static Connection createConnection(String jdbcDriver, String jdbcURL, String username, String password) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(jdbcDriver).newInstance();
        return DriverManager.getConnection(jdbcURL, username, password);
    }

    static boolean fieldTypeIsKnown(String s) {
        for (int i = 0; i < knownFieldTypes.length; ++i) {
            if (!s.startsWith(knownFieldTypes[i])) continue;
            return true;
        }
        return false;
    }

    private static void addSingleReference(HashMap hm, ResultSet rsk, Vector knownTables, boolean includeCatalog, String catalogSeparator, boolean includeSchema, String schemaSeparator) throws SQLException {
        ForeignKey fki;
        String hashKey;
        HashMap<String, ForeignKey> tabForKeys;
        String pCatalog = rsk.getString(1);
        String pSchema = rsk.getString(2);
        String pTable = rsk.getString(3);
        if (!knownTables.contains("" + XMLConfigGenerator.emptyIfNull(pSchema) + "\t" + XMLConfigGenerator.emptyIfNull(pTable))) {
            return;
        }
        String pColName = rsk.getString(4);
        String fSchema = rsk.getString(6);
        String fTable = rsk.getString(7);
        if (!knownTables.contains("" + XMLConfigGenerator.emptyIfNull(fSchema) + "\t" + XMLConfigGenerator.emptyIfNull(fTable))) {
            return;
        }
        String fColName = rsk.getString(8);
        String fkName = rsk.getString(12);
        if (fkName == null) {
            fkName = pCatalog + "::" + pSchema + "::" + pTable;
        }
        if ((tabForKeys = (HashMap<String, ForeignKey>)hm.get(hashKey = XMLConfigGenerator.emptyIfNull(fSchema) + "\t" + fTable)) == null) {
            tabForKeys = new HashMap<String, ForeignKey>();
            hm.put(hashKey, tabForKeys);
        }
        if ((fki = (ForeignKey)tabForKeys.get(fkName)) == null) {
            fki = new ForeignKey();
            tabForKeys.put(fkName, fki);
            String fullTabName = "";
            if (includeCatalog) {
                fullTabName = pCatalog + catalogSeparator;
            }
            if (includeSchema) {
                fullTabName = fullTabName + pSchema + schemaSeparator;
            }
            fullTabName = fullTabName + pTable;
            fki.setForeignTable(fullTabName);
            fki.setName(fkName);
        }
        fki.addReference(new Reference(fColName, pColName));
    }

    private static String emptyIfNull(String s) {
        return s == null ? "" : s;
    }

    private static String remapType(int dbms, String typeName) {
        if (dbms == 1 && typeName.equalsIgnoreCase("longblob")) {
            typeName = "blob";
        }
        return typeName;
    }

    private static String xmlClean(String str) {
        return str.replaceAll("&", "&amp;");
    }
}

