/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.JDBCDataHelper;
import org.dbforms.config.Table;
import org.dbforms.util.IEscaper;
import org.dbforms.util.Util;

public class ResultSetVector
implements Serializable {
    private static Log logCat = LogFactory.getLog((String)ResultSetVector.class.getName());
    private Hashtable selectFieldsHashtable;
    private Map attributes = new HashMap();
    private Table table = null;
    private Vector objectVector = new Vector();
    private Vector selectFields = new Vector();
    private boolean firstPage = false;
    private boolean lastPage = false;
    private int pointer = 0;

    public ResultSetVector() {
    }

    public ResultSetVector(Table table) {
        this.table = table;
        if (table != null) {
            this.setupSelectFieldsHashtable(table.getFields());
            this.setupSelectFieldsHashtable(table.getCalcFields());
        }
    }

    public ResultSetVector(Table table, Vector selectedFields) {
        this.table = table;
        this.setupSelectFieldsHashtable(selectedFields);
    }

    public static final boolean isNull(ResultSetVector rsv) {
        return rsv == null || rsv.size() == 0;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getTableName() {
        String result = null;
        if (this.table != null) {
            result = this.table.getName();
        }
        return result;
    }

    public String[] getCurrentRow() {
        Object[] obj = this.getCurrentRowAsObjects();
        String[] res = null;
        if (obj != null) {
            res = new String[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                res[i] = this.getField(i);
            }
        }
        return res;
    }

    public FieldValues getCurrentRowAsFieldValues() {
        if (this.selectFields == null) {
            throw new IllegalArgumentException("no field vector was provided to this result");
        }
        String[] rowData = this.getCurrentRow();
        if (rowData == null) {
            return null;
        }
        FieldValues fvHT = new FieldValues();
        for (int i = 0; i < this.selectFields.size(); ++i) {
            Field f = (Field)this.selectFields.elementAt(i);
            FieldValue fv = new FieldValue(f, rowData[i]);
            fvHT.put(fv);
        }
        return fvHT;
    }

    public Map getCurrentRowAsMap() {
        if (this.selectFields == null) {
            throw new IllegalArgumentException("no field vector was provided to this result");
        }
        String[] rowData = this.getCurrentRow();
        if (rowData == null) {
            return null;
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (int i = 0; i < this.selectFields.size(); ++i) {
            Field f = (Field)this.selectFields.elementAt(i);
            ht.put(f.getName(), rowData[i]);
        }
        return ht;
    }

    public Object[] getCurrentRowAsObjects() {
        Object[] res = null;
        if (this.isPointerLegal(this.pointer)) {
            res = (Object[])this.objectVector.elementAt(this.pointer);
        }
        return res;
    }

    public String getField(int i) {
        Object obj = this.getFieldAsObject(i);
        return obj != null ? obj.toString() : "";
    }

    public String getField(String fieldName) {
        int fieldIndex = this.getFieldIndex(fieldName);
        if (fieldIndex < 0) {
            return null;
        }
        return this.getField(fieldIndex);
    }

    public Object getFieldAsObject(int i) {
        return this.getFieldAsObject(this.pointer, i);
    }

    public Object getFieldAsObject(int row, int i) {
        Object res = null;
        if (this.isPointerLegal(row)) {
            try {
                res = ((Object[])this.objectVector.elementAt(row))[i];
            }
            catch (Exception e) {
                logCat.error((Object)"getFieldAsObject", (Throwable)e);
            }
        }
        return res;
    }

    public void setFieldAsObject(int row, int i, Object obj) {
        if (this.isPointerLegal(row)) {
            try {
                Object[] objRow = (Object[])this.objectVector.elementAt(row);
                objRow[i] = obj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object getFieldAsObject(String fieldName) {
        return this.getFieldAsObject(this.pointer, fieldName);
    }

    public Object getFieldAsObject(int row, String fieldName) {
        int fieldIndex = this.getFieldIndex(fieldName);
        if (fieldIndex < 0) {
            return null;
        }
        return this.getFieldAsObject(row, fieldIndex);
    }

    public void setFieldAsObject(int row, String fieldName, Object obj) {
        int fieldIndex = this.getFieldIndex(fieldName);
        if (fieldIndex >= 0) {
            this.setFieldAsObject(row, fieldIndex, obj);
        }
    }

    public Field getFieldDescription(String fieldName) {
        return (Field)this.selectFieldsHashtable.get(fieldName);
    }

    public int getFieldIndex(String fieldName) {
        Field f;
        int res = -1;
        if (!Util.isNull(fieldName) && (f = (Field)this.selectFieldsHashtable.get(fieldName)) != null) {
            res = this.selectFields.indexOf(f);
        }
        return res;
    }

    public boolean isFirst() {
        return this.pointer == 0;
    }

    public void setFirstPage(boolean b) {
        this.firstPage = b;
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    public boolean isLast() {
        return this.pointer == this.size() - 1;
    }

    public void setLastPage(boolean b) {
        this.lastPage = b;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultSet(DbEventInterceptorData interceptorData, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columns = rsmd.getColumnCount();
        IEscaper escaper = null;
        try {
            while (rs.next()) {
                Object[] objectRow = new Object[columns];
                for (int i = 0; i < columns; ++i) {
                    Field curField;
                    if (this.selectFields != null && i < this.selectFields.size() && (curField = (Field)this.selectFields.elementAt(i)) != null) {
                        escaper = curField.getEscaper();
                    }
                    if (this.table != null) {
                        IEscaper iEscaper = escaper = escaper == null ? escaper : this.table.getEscaper();
                    }
                    if (escaper == null) {
                        try {
                            escaper = DbFormsConfigRegistry.instance().lookup().getEscaper();
                        }
                        catch (Exception e) {
                            logCat.error((Object)"cannot create the new default escaper", (Throwable)e);
                        }
                    }
                    objectRow[i] = JDBCDataHelper.getData(rs, escaper, i + 1);
                }
                this.addRow(interceptorData, objectRow);
            }
        }
        finally {
            rs.close();
        }
    }

    public void addRow(DbEventInterceptorData interceptorData, Object[] objectRow) {
        if (objectRow != null) {
            boolean doit = true;
            int size = objectRow.length > this.selectFields.size() ? objectRow.length : this.selectFields.size();
            Object[] newRow = new Object[size];
            for (int i = 0; i < objectRow.length; ++i) {
                newRow[i] = objectRow[i];
            }
            if (interceptorData != null && interceptorData.getTable() != null) {
                interceptorData.setAttribute("ResultSetVector", this);
                interceptorData.setAttribute("ObjectRow", newRow);
                int res = 0;
                try {
                    res = interceptorData.getTable().processInterceptors(8, interceptorData);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl = doit = res == 0;
            }
            if (doit) {
                this.objectVector.addElement(newRow);
                if (interceptorData != null && interceptorData.getTable() != null) {
                    try {
                        interceptorData.getTable().processInterceptors(9, interceptorData);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void flip() {
        int vSize = this.size();
        if (vSize > 1) {
            logCat.info((Object)("flipping " + vSize + " elements!"));
            for (int i = 1; i < vSize; ++i) {
                Object o = this.objectVector.elementAt(i);
                this.objectVector.remove(i);
                this.objectVector.insertElementAt(o, 0);
            }
        }
    }

    public void moveFirst() {
        this.pointer = 0;
    }

    public void moveLast() {
        this.pointer = this.size() - 1;
    }

    public boolean moveNext() {
        ++this.pointer;
        return this.pointer >= this.size();
    }

    public boolean movePrevious() {
        --this.pointer;
        return this.pointer < 0;
    }

    public int size() {
        return this.objectVector.size();
    }

    private boolean isPointerLegal(int p) {
        return p >= 0 && p < this.size();
    }

    private void setupSelectFieldsHashtable(Vector paramSelectFields) {
        this.selectFields.addAll(paramSelectFields);
        this.selectFieldsHashtable = new Hashtable();
        for (int i = 0; i < this.selectFields.size(); ++i) {
            Field f = (Field)this.selectFields.elementAt(i);
            this.selectFieldsHashtable.put(f.getName(), f);
        }
    }
}

