/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource.util;

import de.destatis.core.resource.util.DatMlRawVersion;

public class CommonResourceId {
    public static final int COMMON_RESOURCE_ID_LENGTH = 10;
    private String resourceId;

    public CommonResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getTypeId() {
        return CommonResourceId.getTypeId(this.resourceId);
    }

    public String getDatMlRawVersion() {
        return CommonResourceId.getDatMlRawVersion(this.resourceId);
    }

    public String getVersion() {
        return CommonResourceId.getVersion(this.resourceId);
    }

    public String getPrettyDatMlRawVersion() {
        String datMlRawVersion = this.getDatMlRawVersion();
        String prettyVersion = DatMlRawVersion.getPrettyDatMlRawVersionFromDatMlRawVerson(datMlRawVersion);
        return prettyVersion;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.resourceId;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && CommonResourceId.class.equals(obj.getClass())) {
            equal = this.getResourceId().equals(((CommonResourceId)obj).getResourceId());
        }
        return equal;
    }

    public static String getTypeId(String resourceId) {
        return resourceId.substring(0, 2);
    }

    public static String getDatMlRawVersion(String resourceId) {
        return resourceId.substring(2, 6);
    }

    public static String getVersion(String resourceId) {
        return resourceId.substring(6, 10);
    }
}

