/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard;

import de.destatis.core.map.editor.IconFactory;
import de.destatis.core.map.editor.wizard.Step;
import de.destatis.core.map.editor.wizard.Wizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WizardDialog
extends JDialog
implements ChangeListener {
    private JLabel titleLabel;
    private JLabel infoLabel;
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    private Wizard wizard;
    private Step currentStep;

    public WizardDialog(Frame parent, Wizard wizard) {
        super(parent, wizard.getTitle(), true);
        this.wizard = wizard;
        this.wizard.setChangeListener(this);
        this.currentStep = null;
        this.getContentPane().setLayout(new BorderLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.infoLabel = new JLabel();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.white);
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow));
        JPanel infoPanel = new JPanel(new BorderLayout(5, 5));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        infoPanel.setOpaque(false);
        infoPanel.add((Component)this.titleLabel, "North");
        infoPanel.add((Component)this.infoLabel, "Center");
        topPanel.add((Component)infoPanel, "Center");
        topPanel.add((Component)new JLabel(IconFactory.getIcon("banner.png")), "East");
        this.getContentPane().add((Component)topPanel, "North");
        this.backButton = new JButton("< Zur\u00fcck");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.back();
            }
        });
        this.nextButton = new JButton("Weiter >");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.next();
            }
        });
        this.finishButton = new JButton("Fertig");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.finish();
            }
        });
        this.cancelButton = new JButton("Abbrechen");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.cancel();
            }
        });
        this.updateButtonEnableState();
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 5));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.add(this.backButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.finishButton);
        buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.updateCurrentStep();
        this.setSize(700, 400);
        this.setLocationRelativeTo(null);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.cancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.enableEvents(201L);
    }

    private void updateCurrentStep() {
        if (this.currentStep != this.wizard.getCurrentStep()) {
            if (this.currentStep != null) {
                this.getContentPane().remove(this.currentStep.getComponent());
            }
            this.currentStep = this.wizard.getCurrentStep();
            if (this.currentStep != null) {
                this.titleLabel.setText(this.currentStep.getTitle());
                this.infoLabel.setText(this.currentStep.getInfo());
                this.getContentPane().add(this.currentStep.getComponent(), "Center");
            } else {
                this.titleLabel.setText(" ");
                this.infoLabel.setText(" ");
            }
            this.repaint();
        }
    }

    private void updateButtonEnableState() {
        this.backButton.setEnabled(this.wizard.getPreviousStep() != null);
        this.nextButton.setEnabled(this.wizard.getCurrentStep().isComplete() && this.wizard.getNextStep() != null);
        this.finishButton.setEnabled(this.wizard.isComplete());
        if (this.finishButton.isEnabled()) {
            this.getRootPane().setDefaultButton(this.finishButton);
        } else if (this.nextButton.isEnabled()) {
            this.getRootPane().setDefaultButton(this.nextButton);
        } else {
            this.getRootPane().setDefaultButton(null);
        }
    }

    private void back() {
        if (this.wizard.back()) {
            this.updateCurrentStep();
            this.updateButtonEnableState();
        }
    }

    private void next() {
        if (this.wizard.next()) {
            this.updateCurrentStep();
            this.updateButtonEnableState();
        }
    }

    private void finish() {
        if (this.wizard.finish()) {
            this.setVisible(false);
        }
    }

    private void cancel() {
        if (this.wizard.cancel()) {
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateButtonEnableState();
    }

    @Override
    protected void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.cancel();
        }
    }
}

