/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.ClientStatusEvent;
import de.destatis.core.connect.ClientStatusListener;
import de.destatis.core.map.editor.task.ProgressDialog;
import de.destatis.core.map.editor.task.ProgressMonitor;
import de.destatis.core.map.editor.task.Task;
import de.destatis.core.map.editor.wizard.AbstractStep;
import de.destatis.core.map.editor.wizard.AbstractWizard;
import de.destatis.core.map.editor.wizard.ChooseDatMlRawVersionManuallyStep;
import de.destatis.core.map.editor.wizard.PromtAuthenticationStep;
import de.destatis.core.map.editor.wizard.SelectDatMlRawVersionStep;
import de.destatis.core.map.editor.wizard.SelectResourceStorageStep;
import de.destatis.core.map.editor.wizard.Step;
import de.destatis.core.map.model.MetaMapping;
import de.destatis.core.map.model.MetaMappingBuilder;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.SDFMetaResource;
import de.destatis.core.resource.util.DatMlRawVersion;
import de.destatis.core.resource.util.ResourceManager;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CreateMetaMappingWizard
extends AbstractWizard {
    private SelectResourceStorageStep selectResourceStorageStep;
    private PromtAuthenticationStep promtAuthenticationStep;
    private SelectDatMlRawVersionStep selectMetabeschreibungStep;
    private ChooseDatMlRawVersionManuallyStep chooseDatMlRawVersionManuallyStep;
    private ResourceManager resourceManager;
    private Properties clientProperties;
    private MetaMapping mapping;
    private MetaSDFMetabeschreibung sdfMetaBeschreibung;

    public CreateMetaMappingWizard(ResourceManager resourceManager, Properties clientProperties) {
        this.resourceManager = resourceManager;
        this.clientProperties = clientProperties;
        this.mapping = null;
        this.sdfMetaBeschreibung = null;
        this.selectResourceStorageStep = new SelectResourceStorageStep(false);
        this.promtAuthenticationStep = new PromtAuthenticationStep();
        this.selectMetabeschreibungStep = new SelectDatMlRawVersionStep();
        this.chooseDatMlRawVersionManuallyStep = new ChooseDatMlRawVersionManuallyStep();
        this.setCurrentStep(this.selectResourceStorageStep);
    }

    public MetaMapping getMetaMapping() {
        return this.mapping;
    }

    public MetaSDFMetabeschreibung getSDFMetabeschreibung() {
        return this.sdfMetaBeschreibung;
    }

    @Override
    protected Step[] getAllSteps() {
        return new Step[]{this.selectResourceStorageStep, this.promtAuthenticationStep, this.selectMetabeschreibungStep, this.chooseDatMlRawVersionManuallyStep};
    }

    @Override
    public Step getNextStep() {
        Object nextStep = this.getCurrentStep() == this.selectResourceStorageStep ? (this.selectResourceStorageStep.isLocalResourceStorageSelected() ? this.selectMetabeschreibungStep : this.chooseDatMlRawVersionManuallyStep) : (this.getCurrentStep() == this.chooseDatMlRawVersionManuallyStep ? (this.resourceManager.getResourceConfig().getClient() != null ? null : this.promtAuthenticationStep) : (this.getCurrentStep() == this.promtAuthenticationStep ? null : null));
        return nextStep;
    }

    @Override
    public Step getPreviousStep() {
        AbstractStep previousStep = this.getCurrentStep() == this.selectMetabeschreibungStep ? this.selectResourceStorageStep : (this.getCurrentStep() == this.chooseDatMlRawVersionManuallyStep ? this.selectResourceStorageStep : (this.getCurrentStep() == this.promtAuthenticationStep ? this.chooseDatMlRawVersionManuallyStep : null));
        return previousStep;
    }

    @Override
    public String getTitle() {
        return "Neues Metadaten-Mapping erstellen";
    }

    @Override
    protected boolean onNext() {
        boolean canContinue = true;
        if (this.getCurrentStep() == this.selectResourceStorageStep) {
            if (this.selectResourceStorageStep.isLocalResourceStorageSelected()) {
                Task task = new Task(){

                    @Override
                    protected void execute(ProgressMonitor monitor) throws Exception {
                        monitor.processing("Liste der DatML/RAW-Versionen wird ermittelt...");
                        final List datMlVersions = CreateMetaMappingWizard.this.resourceManager.getLocalDatMlRawVersions();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CreateMetaMappingWizard.this.selectMetabeschreibungStep.setDatMlRawVersions(datMlVersions);
                            }
                        });
                    }
                };
                task.execute(new ProgressDialog(this.getDialog(), "Liste der DatML/RAW-Versionen ermitteln...", true), true);
                if (task.getThrowable() != null) {
                    Throwable t = task.getThrowable();
                    t.printStackTrace();
                    JOptionPane.showMessageDialog(this.getDialog(), t.getMessage(), "Fehler", 0);
                    canContinue = false;
                } else if (task.isAborted()) {
                    canContinue = false;
                }
            } else {
                canContinue = true;
            }
        } else if (this.getCurrentStep() == this.chooseDatMlRawVersionManuallyStep) {
            canContinue = this.autoUpdateDisabledUpdateConfirmation();
        }
        return canContinue;
    }

    private boolean autoUpdateDisabledUpdateConfirmation() {
        boolean canContinue = true;
        boolean sdfMetaAutoUpdate = this.resourceManager.getResourceConfig().isSdfMetaAutoUpdate();
        if (!sdfMetaAutoUpdate) {
            Task task = new Task(){

                @Override
                protected void execute(ProgressMonitor monitor) throws Exception {
                    DatMlRawVersion datMlRawVersion = CreateMetaMappingWizard.this.chooseDatMlRawVersionManuallyStep.getDatMlRawVersion();
                    CreateMetaMappingWizard.this.resourceManager.getSdfMetaResource(datMlRawVersion.getDatMlRawVersion());
                }
            };
            task.execute(new ProgressDialog(this.getDialog(), "Lokale Metadatenbeschreibung wird gesucht...", false), true);
            if (task.getThrowable() != null) {
                Throwable t = task.getThrowable();
                t.printStackTrace();
                if (t instanceof NoResourceFoundException) {
                    int answer = JOptionPane.showConfirmDialog(this.getDialog(), "Es existiert keine passende lokale Metadatenbeschreibung.\nDie automatische Aktualisierung von Metadatenbeschreibungen ist deaktiviert.\n\nM\u00f6chten Sie auf dem CORE.server automatisch nach einer passenden Metadatenbeschreibung suchen und diese ggf. herunterladen?", "Lokale Ressourcen aktualisieren?", 1, 3);
                    if (answer != 0) {
                        canContinue = false;
                    }
                } else {
                    JOptionPane.showMessageDialog(this.getDialog(), t.getMessage(), "Fehler", 0);
                    canContinue = false;
                }
            } else {
                int answer = JOptionPane.showConfirmDialog(this.getDialog(), "Es existiert bereits eine passende lokale Metadatenbeschreibung, welche Sie mit Hlfe der Liste der lokal gespeicherten Metadatenbeschreibungen ausw\u00e4hlen k\u00f6nnen.\nDie automatische Aktualisierung von Metadatenbeschreibungen ist deaktiviert.\n\nM\u00f6chten Sie auf dem CORE.server automatisch nach einer aktuelleren Metadatenbeschreibung suchen und diese ggf. herunterladen?", "Lokale Ressourcen aktualisieren?", 1, 3);
                if (answer != 0) {
                    canContinue = false;
                }
            }
        }
        return canContinue;
    }

    @Override
    public boolean finish() {
        boolean canContinue = true;
        if (this.chooseDatMlRawVersionManuallyStep == this.getCurrentStep() && !(canContinue = this.autoUpdateDisabledUpdateConfirmation())) {
            return false;
        }
        Task task = new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void execute(final ProgressMonitor monitor) throws Exception {
                boolean isServerResourceStorageSelected = CreateMetaMappingWizard.this.selectResourceStorageStep.isServerResourceStorageSelected();
                DatMlRawVersion datMlRawVersion = isServerResourceStorageSelected ? CreateMetaMappingWizard.this.chooseDatMlRawVersionManuallyStep.getDatMlRawVersion() : CreateMetaMappingWizard.this.selectMetabeschreibungStep.getSelectedMetaBeschreibung();
                Client client = CreateMetaMappingWizard.this.resourceManager.getResourceConfig().getClient();
                if (client == null && isServerResourceStorageSelected) {
                    client = new Client(CreateMetaMappingWizard.this.promtAuthenticationStep.getUserName(), CreateMetaMappingWizard.this.promtAuthenticationStep.getPassword(), CreateMetaMappingWizard.this.clientProperties);
                }
                ClientStatusListener listener = null;
                if (client != null) {
                    listener = new ClientStatusListener(){

                        @Override
                        public void statusChanged(ClientStatusEvent e) {
                            this.abortIfCanceled(monitor);
                            switch (e.getType()) {
                                case 1: {
                                    monitor.processed(0.0);
                                    break;
                                }
                                case 2: {
                                    monitor.processed(0.05);
                                    break;
                                }
                                case 3: {
                                    monitor.processed(0.4);
                                    break;
                                }
                                case 4: {
                                    monitor.processed(0.45);
                                }
                            }
                            monitor.processing(e.getDescription());
                        }
                    };
                    client.addStatusListener(listener);
                }
                try {
                    monitor.processing("Metadateneschreibung wird ermittelt...");
                    String prettyDatMlRawVersion = datMlRawVersion.getDatMlRawVersion();
                    SDFMetaResource sdfMetaResource = isServerResourceStorageSelected ? CreateMetaMappingWizard.this.resourceManager.getSdfMetaResource(prettyDatMlRawVersion, true, client) : CreateMetaMappingWizard.this.resourceManager.getSdfMetaResource(prettyDatMlRawVersion);
                    if (isServerResourceStorageSelected) {
                        monitor.processed(0.5);
                    } else {
                        monitor.processed(0.2);
                    }
                    monitor.processing("Metadatenbeschreibung wird geladen...");
                    CreateMetaMappingWizard.this.sdfMetaBeschreibung = sdfMetaResource.getSdfMetaBeschreibung();
                    monitor.processed(0.8);
                    monitor.processing("Metadaten-Mapping wird generiert...");
                    MetaMappingBuilder builder = new MetaMappingBuilder();
                    CreateMetaMappingWizard.this.mapping = builder.build(CreateMetaMappingWizard.this.sdfMetaBeschreibung);
                }
                finally {
                    if (client != null) {
                        client.removeStatusListener(listener);
                    }
                }
            }
        };
        task.execute(new ProgressDialog(this.getDialog(), "Neues Metadaten-Mapping wird erstellt...", true), true);
        if (task.getThrowable() != null) {
            Throwable t = task.getThrowable();
            t.printStackTrace();
            JOptionPane.showMessageDialog(this.getDialog(), t.getMessage(), "Fehler", 0);
            canContinue = false;
        } else if (task.isAborted()) {
            canContinue = false;
        }
        if (canContinue) {
            canContinue = super.finish();
        }
        return canContinue;
    }
}

