/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.editor.MappingEditor;
import de.destatis.core.map.editor.util.HtmlPreviewCreator;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.MetaMapping;
import java.io.IOException;
import java.io.Writer;

public class MetaMappingHtmlPreviewCreator
extends HtmlPreviewCreator {
    private MetaMapping metaMapping;

    public MetaMappingHtmlPreviewCreator(MetaMapping metaMapping, Writer writer) {
        super(writer);
        this.metaMapping = metaMapping;
    }

    @Override
    public void run() {
        try {
            this.writeHtml();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeHtml() throws IOException {
        FieldSetBinding messageBinding;
        this.writer.write("<html><body style=\"font-family:Arial; font-size:11pt; padding: 5px;\">");
        FieldSetBinding documentBinding = this.metaMapping.getDocumentBinding();
        if (documentBinding != null) {
            this.writeFieldSetBinding(documentBinding);
        }
        if ((messageBinding = this.metaMapping.getMessageBinding()) != null) {
            this.writeFieldSetBinding(messageBinding);
        }
        this.writer.write("</body></html>");
        this.writer.flush();
    }

    private void writeFieldSetBinding(FieldSetBinding fieldSetBinding) throws IOException {
        this.writer.write("<p style=\"padding: 5px;\">");
        this.writer.write("<b>" + MappingEditor.cvrtHtml(fieldSetBinding.getId()) + "</b>");
        this.writer.write("</p>");
        this.writer.write("<table cellpadding=\"5px\" cellspacing=\"0\" border=\"0\"><tr>");
        Object[] record = null;
        Integer lastCsvPosition = BindingHelper.getLastCalculatedCsvPosition(fieldSetBinding);
        if (lastCsvPosition != null) {
            record = new Object[lastCsvPosition.intValue()];
        }
        if (record != null) {
            this.fillForFieldSet(record, fieldSetBinding);
            this.writeHtmlTableColumns(this.writer, record, "#f0f0f0", "#e0e0e0");
        }
        this.writer.write("</tr>");
        this.writer.write("</table>");
    }
}

