/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.map.Binding;
import de.destatis.core.map.MappingProblem;
import de.destatis.core.map.editor.IconFactory;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class ProblemTableModel
extends AbstractTableModel {
    private MappingProblem[] problems;

    public void setProblems(MappingProblem[] problems) {
        this.problems = problems;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return Binding.class;
            }
            case 2: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("columnIndex=" + columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Feld";
            }
            case 2: {
                return "Beschreibung";
            }
        }
        throw new IllegalArgumentException("column=" + column);
    }

    @Override
    public int getRowCount() {
        return this.problems != null ? this.problems.length : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MappingProblem problem = this.problems[rowIndex];
        switch (columnIndex) {
            case 0: {
                switch (problem.getType()) {
                    case 1: {
                        return IconFactory.getIcon("fatal.gif");
                    }
                    case 2: {
                        return IconFactory.getIcon("error.gif");
                    }
                    case 3: {
                        return IconFactory.getIcon("warning.gif");
                    }
                    case 4: {
                        return IconFactory.getIcon("info.gif");
                    }
                }
                return null;
            }
            case 1: {
                return problem.getBinding();
            }
            case 2: {
                if (problem.getReason() != null) {
                    if (problem.getReason() instanceof ValueConversionException) {
                        return problem.getDescription() + " (" + problem.getReason().getMessage() + ")";
                    }
                    return problem.getDescription() + " (" + problem.getReason() + ")";
                }
                return problem.getDescription();
            }
        }
        throw new IllegalArgumentException("column=" + columnIndex);
    }

    public MappingProblem getProblemAt(int index) {
        return this.problems[index];
    }
}

