/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.MappingCheckResult;
import de.destatis.core.map.editor.Icons;
import de.destatis.core.map.editor.MappingEditor;
import de.destatis.core.map.editor.MappingTableCellRanderer;
import de.destatis.core.map.editor.MappingTreeCellRenderer;
import de.destatis.core.map.editor.MappingTreeTableModel;
import de.destatis.core.map.editor.PreviewDialog;
import de.destatis.core.map.editor.PropertiesIfc;
import de.destatis.core.map.editor.RowHeaderTableCellRenderer;
import de.destatis.core.map.editor.UndoSupport;
import de.destatis.core.map.editor.treetable.TreeTable;
import de.destatis.core.map.editor.util.BindedElementProvider;
import de.destatis.core.map.editor.util.SelectionFocusListener;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.BindingInfo;
import de.destatis.core.map.model.BindingInfoAttribute;
import de.statspez.sdf.generator.meta.SDFElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public abstract class MappingEditorTool {
    private static final String EVENT_BINDING_SELECTION_CHANGED = new String("EVENT_BINDING_SELECTION_CHANGED");
    private static final String EVENT_DIRTY_FLAG_CHANGED = new String("EVENT_DIRTY_FLAG_CHANGED");
    protected final PropertiesIfc properties;
    protected final UndoSupport undoSupport;
    private BindedElementProvider bindedElementProvider;
    protected TreeTable treeTable;
    protected RowHeaderTableCellRenderer rowHeaderTableCellRenderer;
    private JLabel infoTitleBar;
    private JEditorPane infoTextPane;
    protected JComponent gui;
    private boolean dirtyFlag = false;
    private JPopupMenu tablePopupMenu;
    private ComputeStandardPositionsAction computeStandardPositionsAction;
    private CollapseAllAction collapseAllAction;
    private ExpandAllAction expandAllAction;
    private CollapseAction collapseAction;
    private ExpandAction expandAction;
    private ShowTablePreviewAction showTablePreviewAction;
    private Map changeListeners = new HashMap();
    private SelectionFocusListener selectionFocusListener;
    private ListSelectionListener listSelectionListener;
    private MouseListener tablePopupMouseListener;
    private boolean activated = false;
    private Binding markErrorBinding;

    protected MappingEditorTool(UndoSupport undoSupport, boolean dirtyFlag, PropertiesIfc properties) {
        this.undoSupport = undoSupport;
        this.dirtyFlag = dirtyFlag;
        if (properties == null) {
            throw new IllegalArgumentException("properties ist erforderlich");
        }
        this.properties = properties;
    }

    public void addSelectionChangedListener(ChangeListener changeListener) {
        this.addChangeListener(EVENT_BINDING_SELECTION_CHANGED, changeListener);
    }

    public void addDirtyFlagChangedListener(ChangeListener changeListener) {
        this.addChangeListener(EVENT_DIRTY_FLAG_CHANGED, changeListener);
    }

    private void addChangeListener(String changeEventName, ChangeListener changeListener) {
        if (changeEventName != null && changeListener != null) {
            ArrayList<ChangeListener> changeListenerList = (ArrayList<ChangeListener>)this.changeListeners.get(changeEventName);
            if (changeListenerList == null) {
                changeListenerList = new ArrayList<ChangeListener>();
                this.changeListeners.put(changeEventName, changeListenerList);
            }
            changeListenerList.add(changeListener);
        }
    }

    private void fireBindingSelectionChanged() {
        this.fireChangeEvent(EVENT_BINDING_SELECTION_CHANGED);
    }

    private void fireDirtyFlagChanged() {
        this.fireChangeEvent(EVENT_DIRTY_FLAG_CHANGED);
    }

    private void fireChangeEvent(String changeEventName) {
        List changeListenerList;
        if (this.changeListeners != null && (changeListenerList = (List)this.changeListeners.get(changeEventName)) != null && changeListenerList.size() > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : changeListenerList) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public void setDirtyFlag(boolean dirtyFlag) {
        boolean oldValue = this.dirtyFlag;
        this.dirtyFlag = dirtyFlag;
        if (this.dirtyFlag != oldValue) {
            this.fireDirtyFlagChanged();
        }
    }

    public boolean getDirtyFlag() {
        return this.dirtyFlag;
    }

    public void repaintTable() {
        this.treeTable.repaint();
    }

    public void assemble() {
        this.treeTable = this.createTreeTable();
        this.gui = this.createGUI();
    }

    public final void activate() {
        this.activated = true;
        this.bindedElementProvider = this.createBindedElementProvider();
        MappingTreeTableModel treeTableModel = this.createTreeTableModel();
        this.activateTreeTable(treeTableModel);
        this.tablePopupMenu = this.createTablePopupMenu();
        this.doActivate();
    }

    public boolean activated() {
        return this.activated;
    }

    protected void doActivate() {
    }

    public boolean commitChangesToMapping() {
        this.stopCellEditing();
        return !this.treeTable.isEditing();
    }

    public void save(OutputStream out) throws IOException {
        this.doSave(out);
        this.setDirtyFlag(false);
    }

    public void setMarkErrorBinding(Binding binding) {
        this.markErrorBinding = binding;
        if (this.activated()) {
            this.treeTable.repaint();
        }
    }

    public Binding getMarkErrorBinding() {
        return this.markErrorBinding;
    }

    public void focusErrorBinding(Binding binding) {
        if (this.activated()) {
            JTree tree = this.treeTable.getTree();
            TreePath path = new TreePath(binding.getPath());
            tree.makeVisible(path);
            int row = tree.getRowForPath(path);
            if (row != -1) {
                this.treeTable.getSelectionModel().setSelectionInterval(row, row);
                this.treeTable.scrollRectToVisible(new Rectangle(this.treeTable.getCellRect(row, 0, true)));
            }
            this.treeTable.requestFocus();
        }
    }

    protected abstract void doSave(OutputStream var1) throws IOException;

    protected static void startHtml(StringBuffer buffer) {
        buffer.append("<html><body style=\"margin:5 5 5 5px; font-family:Tahoma,Arial; font-size:");
        buffer.append(11);
        buffer.append("pt\">");
    }

    protected static void endHtml(StringBuffer buffer) {
        buffer.append("</body></html>");
    }

    protected abstract String getTablePreview();

    protected TreeTable createTreeTable() {
        TreeTable treeTable = new TreeTable(){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                Component editorComponent;
                TableCellEditor editor;
                boolean result = super.editCellAt(row, column, e);
                if (result && (e == null || e instanceof KeyEvent) && (editor = this.getCellEditor()) != null && (editorComponent = this.getEditorComponent()) != null) {
                    editorComponent.requestFocus();
                    if (editorComponent instanceof JTextComponent) {
                        MappingEditorTool.this.markText((JTextComponent)editorComponent);
                    }
                }
                return result;
            }
        };
        treeTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        treeTable.setAutoResizeMode(0);
        treeTable.getTableHeader().setReorderingAllowed(false);
        treeTable.setRowHeight(18);
        treeTable.setGridColor(SystemColor.control);
        return treeTable;
    }

    protected void activateTreeTable(MappingTreeTableModel model) {
        int column5Width;
        int column4Width;
        int column3Width;
        int column2Width;
        int column1Width;
        this.treeTable.setModel(model);
        this.rowHeaderTableCellRenderer = new RowHeaderTableCellRenderer();
        this.treeTable.setDefaultRenderer(Binding.class, this.rowHeaderTableCellRenderer);
        this.treeTable.setDefaultRenderer(Object.class, new MappingTableCellRanderer());
        this.treeTable.setDefaultRenderer(Integer.class, new MappingTableCellRanderer());
        this.treeTable.setTreeCellRenderer(new MappingTreeCellRenderer(this));
        this.selectionFocusListener = new SelectionFocusListener();
        this.treeTable.addFocusListener(this.selectionFocusListener);
        this.treeTable.getSelectionModel().setSelectionMode(0);
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MappingEditorTool.this.updateInfo();
                    MappingEditorTool.this.fireBindingSelectionChanged();
                }
            }
        };
        this.treeTable.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.tablePopupMouseListener = new TablePopupListener();
        this.treeTable.addMouseListener(this.tablePopupMouseListener);
        this.initReturnKey(this.treeTable);
        try {
            column1Width = Integer.parseInt(this.properties.getProperty("editor.column1.width", "450"));
        }
        catch (NumberFormatException e) {
            column1Width = 450;
        }
        try {
            column2Width = Integer.parseInt(this.properties.getProperty("editor.column2.width", "150"));
        }
        catch (NumberFormatException e) {
            column2Width = 150;
        }
        try {
            column3Width = Integer.parseInt(this.properties.getProperty("editor.column3.width", "60"));
        }
        catch (NumberFormatException e) {
            column3Width = 60;
        }
        try {
            column4Width = Integer.parseInt(this.properties.getProperty("editor.column4.width", "60"));
        }
        catch (NumberFormatException e) {
            column4Width = 60;
        }
        int defaultColumn5Width = 100;
        try {
            column5Width = Integer.parseInt(this.properties.getProperty("editor.column5.width", defaultColumn5Width + ""));
        }
        catch (NumberFormatException e) {
            column5Width = defaultColumn5Width;
        }
        TableColumn column = this.treeTable.getTableHeader().getColumnModel().getColumn(0);
        column.setResizable(false);
        column.setPreferredWidth(18);
        column = this.treeTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(column1Width);
        column = this.treeTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(column2Width);
        column = this.treeTable.getColumnModel().getColumn(3);
        column.setPreferredWidth(column3Width);
        column = this.treeTable.getColumnModel().getColumn(4);
        column.setPreferredWidth(column4Width);
        column = this.treeTable.getColumnModel().getColumn(5);
        column.setPreferredWidth(column5Width);
    }

    protected JPopupMenu createTablePopupMenu() {
        return null;
    }

    protected abstract void computeStandardPositions();

    protected void showTablePreview() {
        if (this.commitChangesToMapping()) {
            String html = this.getTablePreview();
            Frame owner = JOptionPane.getFrameForComponent(this.getGUI());
            PreviewDialog previewDialog = new PreviewDialog(owner, this.properties);
            previewDialog.setHtml(html);
            previewDialog.setVisible(true);
        }
    }

    protected ComputeStandardPositionsAction getComputeStandardPositionsAction() {
        if (this.computeStandardPositionsAction == null) {
            this.computeStandardPositionsAction = new ComputeStandardPositionsAction();
        }
        return this.computeStandardPositionsAction;
    }

    protected CollapseAllAction getCollapseAllAction() {
        if (this.collapseAllAction == null) {
            this.collapseAllAction = new CollapseAllAction();
        }
        return this.collapseAllAction;
    }

    protected ExpandAllAction getExpandAllAction() {
        if (this.expandAllAction == null) {
            this.expandAllAction = new ExpandAllAction();
        }
        return this.expandAllAction;
    }

    protected CollapseAction getCollapseAction() {
        if (this.collapseAction == null) {
            this.collapseAction = new CollapseAction();
        }
        return this.collapseAction;
    }

    protected ExpandAction getExpandAction() {
        if (this.expandAction == null) {
            this.expandAction = new ExpandAction();
        }
        return this.expandAction;
    }

    protected ShowTablePreviewAction getShowTablePreviewAction() {
        if (this.showTablePreviewAction == null) {
            this.showTablePreviewAction = new ShowTablePreviewAction();
        }
        return this.showTablePreviewAction;
    }

    private void initReturnKey(TreeTable treeTable) {
        InputMap im = treeTable.getInputMap(1);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        final Action oldEnterAction = treeTable.getActionMap().get(im.get(enter));
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column;
                int row;
                JTable table = (JTable)e.getSource();
                if (table.isCellEditable(row = table.getSelectedRow(), column = table.getSelectedColumn())) {
                    Component editorComponent;
                    TableCellEditor editor;
                    if (!table.isEditing() && table.editCellAt(row, column) && (editor = table.getCellEditor()) != null && (editorComponent = table.getEditorComponent()) != null) {
                        if (editorComponent instanceof JTextComponent) {
                            MappingEditorTool.this.setCaretToEnd((JTextComponent)editorComponent);
                        }
                        editorComponent.requestFocus();
                    }
                } else {
                    oldEnterAction.actionPerformed(e);
                }
            }
        };
        treeTable.getActionMap().put(im.get(enter), enterAction);
    }

    private void setCaretToEnd(JTextComponent textComponent) {
        textComponent.setSelectionStart(textComponent.getText().length());
        textComponent.setSelectionEnd(textComponent.getText().length());
        textComponent.getCaret().setSelectionVisible(false);
    }

    private void markText(JTextComponent textComponent) {
        textComponent.setSelectionStart(0);
        textComponent.setSelectionEnd(textComponent.getText().length());
        textComponent.getCaret().setSelectionVisible(true);
    }

    private JComponent createGUI() {
        int dividerLocation;
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setBorder(null);
        try {
            dividerLocation = Integer.parseInt(this.properties.getProperty("editor.divider.left", "800"));
        }
        catch (NumberFormatException e) {
            dividerLocation = 800;
        }
        splitPane.setDividerLocation(dividerLocation);
        JComponent leftGUI = this.createLeftGUI();
        leftGUI.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.controlShadow), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        Component rightGUI = this.createRightGUI();
        splitPane.setLeftComponent(leftGUI);
        splitPane.setRightComponent(rightGUI);
        return splitPane;
    }

    protected abstract JComponent createLeftGUI();

    protected Component createRightGUI() {
        this.infoTitleBar = new JLabel(" ");
        this.infoTitleBar.setPreferredSize(new Dimension(0, 21));
        this.infoTitleBar.setMinimumSize(new Dimension(20, this.infoTitleBar.getMinimumSize().width));
        this.infoTitleBar.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.infoTitleBar.setBackground(SystemColor.control);
        this.infoTitleBar.setOpaque(true);
        this.infoTextPane = new JEditorPane("text/html", "");
        this.infoTextPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.infoTextPane.setBackground(SystemColor.info);
        this.infoTextPane.setOpaque(true);
        this.infoTextPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.infoTextPane);
        scrollPane.setBorder(null);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.controlShadow), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        panel.add((Component)this.infoTitleBar, "North");
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    protected void updateInfo() {
        Binding selectedBinding = this.getSelectedBinding();
        if (selectedBinding == null) {
            this.infoTitleBar.setText("Kein Element ausgew\u00e4hlt");
            this.infoTextPane.setText("");
        } else {
            BindingInfo bindingInfo = BindingHelper.getBindingInfo(selectedBinding, this.bindedElementProvider);
            if (bindingInfo == null) {
                this.infoTitleBar.setText("Keine Information verf\u00fcgbar");
                this.infoTextPane.setText("");
            } else {
                BindingInfoAttribute[] attributes;
                this.infoTitleBar.setText(bindingInfo.getType() + " " + bindingInfo.getName());
                StringBuffer info = new StringBuffer(1024);
                MappingEditorTool.startHtml(info);
                boolean containsInfo = false;
                if (bindingInfo.getDescription() != null && bindingInfo.getDescription().length() > 0) {
                    info.append(MappingEditor.cvrtHtml(bindingInfo.getDescription()));
                    containsInfo = true;
                }
                if ((attributes = bindingInfo.getAttributes()) != null && attributes.length > 0) {
                    if (containsInfo) {
                        info.append("<br><br>");
                    }
                    info.append("<table border=\"0\">");
                    for (BindingInfoAttribute attribute : attributes) {
                        info.append("<tr><th align=\"left\" valign=\"top\">");
                        info.append(MappingEditor.cvrtHtml(attribute.getName()));
                        info.append(":</th><td>");
                        info.append(MappingEditor.cvrtHtml(attribute.getValue()));
                        info.append("</td></tr>");
                    }
                    info.append("</table>");
                    containsInfo = true;
                }
                if (bindingInfo.getComment() != null && bindingInfo.getComment().length() > 0) {
                    if (containsInfo) {
                        info.append("<br><br>");
                    }
                    info.append(MappingEditor.cvrtHtml(bindingInfo.getComment()));
                }
                MappingEditorTool.endHtml(info);
                this.infoTextPane.setText(info.toString());
            }
        }
    }

    protected abstract MappingTreeTableModel createTreeTableModel();

    public void saveProperties() {
        if (this.gui instanceof JSplitPane) {
            this.properties.setProperty("editor.divider.left", String.valueOf(((JSplitPane)this.gui).getDividerLocation()));
        }
        if (this.treeTable != null && this.treeTable.isValid()) {
            this.properties.setProperty("editor.column1.width", String.valueOf(this.treeTable.getColumnModel().getColumn(1).getWidth()));
            this.properties.setProperty("editor.column2.width", String.valueOf(this.treeTable.getColumnModel().getColumn(2).getWidth()));
            this.properties.setProperty("editor.column3.width", String.valueOf(this.treeTable.getColumnModel().getColumn(3).getWidth()));
            this.properties.setProperty("editor.column4.width", String.valueOf(this.treeTable.getColumnModel().getColumn(4).getWidth()));
            this.properties.setProperty("editor.column5.width", String.valueOf(this.treeTable.getColumnModel().getColumn(5).getWidth()));
        }
    }

    public Binding getSelectedBinding() {
        Binding selectedBinding = this.treeTable.getSelectedRow() >= 0 ? (Binding)this.treeTable.getValueAt(this.treeTable.getSelectedRow(), 0) : null;
        return selectedBinding;
    }

    protected SDFElement getBindedElement(Binding binding) {
        SDFElement sdfElement = this.bindedElementProvider.getBindedElement(binding);
        return sdfElement;
    }

    protected abstract BindedElementProvider createBindedElementProvider();

    public JComponent getGUI() {
        return this.gui;
    }

    public MappingCheckResult check() {
        MappingCheckResult result = this.doCheck();
        this.setMappingCheckResult(result);
        this.setMarkErrorBinding(null);
        return result;
    }

    public void setMappingCheckResult(MappingCheckResult mappingCheckResult) {
        this.rowHeaderTableCellRenderer.setProblems(mappingCheckResult.getProblems());
        this.treeTable.repaint();
    }

    protected abstract MappingCheckResult doCheck();

    public void close() {
        if (this.changeListeners != null) {
            this.changeListeners.clear();
            this.changeListeners = null;
        }
        if (this.treeTable != null) {
            if (this.selectionFocusListener != null) {
                this.treeTable.removeFocusListener(this.selectionFocusListener);
            }
            if (this.listSelectionListener != null) {
                this.treeTable.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            }
            if (this.tablePopupMouseListener != null) {
                this.treeTable.removeMouseListener(this.tablePopupMouseListener);
            }
        }
    }

    private void stopCellEditing() {
        TableCellEditor cellEditor;
        int editingRow = this.treeTable.getEditingRow();
        int editingCol = this.treeTable.getEditingColumn();
        if (editingRow != -1 && editingCol != -1 && !(cellEditor = this.treeTable.getCellEditor()).stopCellEditing() && this.cancelCellEditingOnFailedStop()) {
            cellEditor.cancelCellEditing();
        }
    }

    protected boolean cancelCellEditingOnFailedStop() {
        return true;
    }

    protected void openTablePopup(MouseEvent e) {
        if (this.tablePopupMenu != null) {
            this.tablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void expandTree(boolean allPaths) {
        int selectedRow = this.treeTable.getSelectedRow();
        if (allPaths) {
            TreePath selectedPath = this.treeTable.getTree().getPathForRow(selectedRow);
            this.treeTable.expandAll();
            selectedRow = this.treeTable.getTree().getRowForPath(selectedPath);
        } else if (selectedRow != -1) {
            this.treeTable.getTree().expandRow(selectedRow);
        }
        if (selectedRow != -1) {
            this.treeTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    protected void collapseTree(boolean allPaths) {
        if (allPaths) {
            this.treeTable.collapseAll();
            this.treeTable.setRowSelectionInterval(0, 0);
        } else {
            int selectedRow = this.treeTable.getSelectedRow();
            this.treeTable.getTree().collapseRow(selectedRow);
            this.treeTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    protected void positionOrQuantityHasChanged(Binding binding) {
        Binding selectedBinding;
        if (binding != null && (selectedBinding = this.getSelectedBinding()) != null && selectedBinding instanceof FieldGroupBinding) {
            boolean isRelevantBinding = false;
            Binding parent = binding;
            do {
                if (parent != selectedBinding) continue;
                isRelevantBinding = true;
                break;
            } while ((parent = binding.getParent()) != null);
            if (isRelevantBinding) {
                this.updateInfo();
            }
        }
    }

    protected class ShowTablePreviewAction
    extends AbstractAction {
        protected ShowTablePreviewAction() {
            super("Tabellenvorschau ...", Icons.ICON_TABLE_PREVIEW);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditorTool.this.showTablePreview();
        }
    }

    protected class CollapseAction
    extends AbstractAction
    implements ChangeListener {
        protected CollapseAction() {
            super("Reduzieren");
            this.setEnabled(false);
            MappingEditorTool.this.addSelectionChangedListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditorTool.this.collapseTree(false);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            BindingGroup bindingGroup;
            Binding binding;
            boolean enable = false;
            int selectedRow = MappingEditorTool.this.treeTable.getSelectedRow();
            if (selectedRow >= 0 && (binding = MappingEditorTool.this.getSelectedBinding()) instanceof BindingGroup && (bindingGroup = (BindingGroup)binding).getBindingsCount() > 0 && MappingEditorTool.this.treeTable.getTree().isExpanded(selectedRow)) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    protected class ExpandAction
    extends AbstractAction
    implements ChangeListener {
        protected ExpandAction() {
            super("Erweitern");
            this.setEnabled(false);
            MappingEditorTool.this.addSelectionChangedListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditorTool.this.expandTree(false);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            BindingGroup bindingGroup;
            Binding binding;
            boolean enable = false;
            int selectedRow = MappingEditorTool.this.treeTable.getSelectedRow();
            if (selectedRow >= 0 && (binding = MappingEditorTool.this.getSelectedBinding()) instanceof BindingGroup && (bindingGroup = (BindingGroup)binding).getBindingsCount() > 0 && !MappingEditorTool.this.treeTable.getTree().isExpanded(selectedRow)) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    protected class ExpandAllAction
    extends AbstractAction {
        protected ExpandAllAction() {
            super("Alle erweitern");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditorTool.this.expandTree(true);
        }
    }

    protected class CollapseAllAction
    extends AbstractAction {
        protected CollapseAllAction() {
            super("Alle reduzieren");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditorTool.this.collapseTree(true);
        }
    }

    protected class ComputeStandardPositionsAction
    extends AbstractAction {
        protected ComputeStandardPositionsAction() {
            super("Standardpositionen berechnen ...");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingEditorTool.this.computeStandardPositions();
        }
    }

    private class TablePopupListener
    extends MouseAdapter {
        private TablePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MappingEditorTool.this.openTablePopup(e);
            }
        }
    }
}

