/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.MappingXmlConstants;
import de.destatis.core.map.model.MetaMapping;
import de.destatis.core.map.model.MetaMappingBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MetaMappingParser {

    protected static class XmlParser
    extends DefaultHandler {
        private MetaMapping mapping = null;
        private StringBuffer buffer = new StringBuffer();
        private BindingGroup currentBindingGroup = null;
        private Binding currentBinding = null;

        public MetaMapping getMapping() {
            return this.mapping;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buffer.delete(0, this.buffer.length());
            if (MappingXmlConstants.TAG_FIELD_BINDING.equalsIgnoreCase(qName)) {
                String defaultValue;
                String position;
                if (!(this.currentBindingGroup instanceof FieldSetBinding) && !(this.currentBindingGroup instanceof FieldGroupBinding)) {
                    throw new SAXException("Ein FieldBinding darf nur unterhalb eines Dokument-, Message- oder FieldGroupBindings vorkommen.");
                }
                String field = attributes.getValue(MappingXmlConstants.ATTR_FIELD);
                if (field == null || field.length() <= 0) throw new SAXException("Kein Feldname angegeben.");
                FieldBinding fieldBinding = new FieldBinding(field);
                String customName = attributes.getValue(MappingXmlConstants.ATTR_CUSTOM_NAME);
                if (customName != null) {
                    fieldBinding.setCustomName(customName);
                }
                if ((position = attributes.getValue(MappingXmlConstants.ATTR_POSITION)) != null) {
                    fieldBinding.setPosition(new Integer(position.trim()));
                }
                if ((defaultValue = attributes.getValue(MappingXmlConstants.ATTR_DEFAULT_VALUE)) != null) {
                    fieldBinding.setDefaultValue(defaultValue);
                }
                this.currentBindingGroup.addBinding(fieldBinding);
                this.currentBinding = fieldBinding;
                return;
            }
            if (MappingXmlConstants.TAG_FIELD_GROUP_BINDING.equals(qName)) {
                String quantity;
                if (!(this.currentBindingGroup instanceof FieldSetBinding) && !(this.currentBindingGroup instanceof FieldGroupBinding)) {
                    throw new SAXException("Ein FieldGroupBindung darf nur unterhalb eines Dokument-, Message- oder FieldGroupBindings vorkommen.");
                }
                String fieldGroup = attributes.getValue(MappingXmlConstants.ATTR_FIELD_GROUP);
                if (fieldGroup == null || fieldGroup.length() <= 0) throw new SAXException("Kein Feldgruppenname angegeben.");
                FieldGroupBinding fieldGroupBinding = new FieldGroupBinding(fieldGroup);
                String customName = attributes.getValue(MappingXmlConstants.ATTR_CUSTOM_NAME);
                if (customName != null) {
                    fieldGroupBinding.setCustomName(customName);
                }
                if ((quantity = attributes.getValue(MappingXmlConstants.ATTR_QUANTITY)) != null) {
                    fieldGroupBinding.setSize(new Integer(quantity.trim()));
                }
                this.currentBindingGroup.addBinding(fieldGroupBinding);
                this.currentBindingGroup = fieldGroupBinding;
                this.currentBinding = fieldGroupBinding;
                return;
            }
            if (MappingXmlConstants.TAG_META_MAPPING.equals(qName)) {
                String resourceId = attributes.getValue(MappingXmlConstants.ATTR_RESOURCE_ID);
                if (resourceId == null || resourceId.length() == 0) {
                    throw new SAXException("Keine Resource-ID angegeben.");
                }
                String name = attributes.getValue("name");
                if (name == null || name.length() == 0) {
                    name = "Metadaten";
                }
                String customName = attributes.getValue(MappingXmlConstants.ATTR_CUSTOM_NAME);
                String creationDateStr = attributes.getValue(MappingXmlConstants.ATTR_CREATION_DATE);
                String creationTimeStr = attributes.getValue(MappingXmlConstants.ATTR_CREATION_TIME);
                Date creationDate = null;
                if (creationDateStr != null && creationTimeStr != null) {
                    SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
                    try {
                        creationDate = format.parse(creationDateStr + creationTimeStr);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                this.mapping = new MetaMapping(resourceId, name);
                this.mapping.setCustomName(customName);
                this.mapping.setCreationDate(creationDate);
                this.currentBindingGroup = this.mapping;
                this.currentBinding = this.mapping;
                return;
            }
            if (MappingXmlConstants.TAG_DOCUMENT_BINDING.equals(qName)) {
                if (!(this.currentBinding instanceof MetaMapping)) {
                    throw new SAXException("Ein DocumentBinding darf nur direkt unterhalb eines MetaMappings vorkommen.");
                }
                FieldSetBinding fieldSetBinding = new FieldSetBinding(MetaMappingBuilder.DOCUMENT_FIELD_SET_NAME);
                this.mapping.setDocumentBinding(fieldSetBinding);
                this.currentBindingGroup = fieldSetBinding;
                this.currentBinding = fieldSetBinding;
                return;
            } else {
                if (!MappingXmlConstants.TAG_MESSAGE_BINDING.equals(qName)) return;
                if (!(this.currentBinding instanceof MetaMapping)) {
                    throw new SAXException("Ein MessageBinding darf nur direkt unterhalb eines MetaMappings vorkommen.");
                }
                FieldSetBinding fieldSetBinding = new FieldSetBinding(MetaMappingBuilder.MESSAGE_FIELD_SET_NAME);
                this.mapping.setMessageBinding(fieldSetBinding);
                this.currentBindingGroup = fieldSetBinding;
                this.currentBinding = fieldSetBinding;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.mapping == null) {
                throw new SAXException("MetaMapping wurde noch nicht erstellt. Falsches Format.");
            }
            if (MappingXmlConstants.TAG_FIELD_GROUP_BINDING.equals(qName) || MappingXmlConstants.TAG_DOCUMENT_BINDING.equals(qName) || MappingXmlConstants.TAG_MESSAGE_BINDING.equals(qName)) {
                this.currentBindingGroup = this.currentBindingGroup.getParent();
                this.currentBinding = this.currentBindingGroup;
            } else if (MappingXmlConstants.TAG_META_MAPPING.equals(qName)) {
                if (this.mapping.getDocumentBinding() == null) {
                    throw new SAXException("Kein DocumentBinding vorhanden.");
                }
                if (this.mapping.getMessageBinding() == null) {
                    throw new SAXException("Kein MessageBinding vorhanden.");
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        @Override
        public void error(SAXParseException paramSAXParseException) throws SAXException {
            throw paramSAXParseException;
        }

        @Override
        public void warning(SAXParseException paramSAXParseException) throws SAXException {
            throw paramSAXParseException;
        }
    }
}

