/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator.generation;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.StructureDescriptor;
import de.destatis.core.generator.generation.AbstractSdfGeneratorTraverser;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaStatspezObjekt;
import java.util.Map;

public class CollectRecordDataTraverser
extends AbstractSdfGeneratorTraverser {
    protected Map values;

    public CollectRecordDataTraverser(StructureDescriptor parentDescriptor, DataProvider dataProvider, BindingGroup mapping, Map values) {
        super(parentDescriptor, dataProvider, mapping);
        this.values = values;
    }

    @Override
    protected boolean shouldEnterSdfFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
        boolean shouldEnter = false;
        if (!feldReferenz.isIstSelektor()) {
            shouldEnter = true;
        }
        return shouldEnter;
    }

    @Override
    protected void doVisitSDFMerkmal(MetaSDFMerkmal merkmal, AbstractSdfGeneratorTraverser.StructureStackInfo stackInfo, FieldDescriptor mmDescriptor, FieldBinding fieldBinding) {
        DataProvider dataProvider = stackInfo.getDataProvider();
        String value = dataProvider.getFieldValue(mmDescriptor);
        if (value == null && fieldBinding != null) {
            value = fieldBinding.getDefaultValue();
        }
        String path = this.getSdfPathString(mmDescriptor);
        this.values.put(path, value);
    }

    @Override
    protected void doEnterMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe, AbstractSdfGeneratorTraverser.StructureStackInfo stackInfo, StructureDescriptor mmgrDescriptor) {
        String path = this.getSdfPathString(mmgrDescriptor);
        Integer index = mmgrDescriptor.getIndex();
        Contract.verify(index != null, "index ist erforderlich");
        this.values.put(path, index);
    }

    @Override
    protected void doLeaveMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe, AbstractSdfGeneratorTraverser.StructureStackInfo stackInfo, StructureDescriptor mmgrDescriptor) {
    }

    @Override
    protected void doHandleMerkmalsgruppeAnzahl(MetaSDFMerkmalsgruppe merkmalsgruppe, int anzahl) {
        super.doHandleMerkmalsgruppeAnzahl(merkmalsgruppe, anzahl);
        StructureDescriptor descriptor = this.getCurrentStackInfo().getStructureDescriptor();
        String stackPath = this.getSdfPathString(descriptor);
        StringBuffer path = new StringBuffer(stackPath.length() + ".".length() + merkmalsgruppe.getName().length() + "#anzahl".length());
        if (stackPath.length() > 0) {
            path.append(stackPath);
            path.append(".");
        }
        path.append(merkmalsgruppe.getName());
        path.append("#anzahl");
        this.values.put(path.toString(), new Integer(anzahl));
    }

    @Override
    protected boolean shouldEnterSdfMerkmal(MetaSDFMerkmal merkmal) {
        return this.shouldEnterSdfMerkmalOrSdfMerkmalsgruppe((MetaStatspezObjekt)merkmal);
    }

    @Override
    protected boolean shouldEnterSdfMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe) {
        return this.shouldEnterSdfMerkmalOrSdfMerkmalsgruppe((MetaStatspezObjekt)merkmalsgruppe);
    }

    protected boolean shouldEnterSdfMerkmalOrSdfMerkmalsgruppe(MetaStatspezObjekt metaStatspezObject) {
        return true;
    }
}

