/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.ChartValidationException;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.taglib.AttributeValidationException;
import de.laures.cewolf.taglib.AxisConstants;
import de.laures.cewolf.taglib.AxisFactory;
import de.laures.cewolf.taglib.ChartConstants;
import de.laures.cewolf.taglib.ChartTypes;
import de.laures.cewolf.taglib.IncompatibleDatasetException;
import de.laures.cewolf.taglib.LayoutConstants;
import de.laures.cewolf.taglib.LayoutTypes;
import de.laures.cewolf.taglib.PlotDefinition;
import de.laures.cewolf.taglib.PlotTypes;
import de.laures.cewolf.taglib.UnsupportedChartTypeException;
import de.laures.cewolf.util.Assert;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.SignalsDataset;
import org.jfree.data.xy.WindDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class CewolfChartFactory
implements ChartConstants,
AxisConstants,
LayoutConstants {
    static /* synthetic */ Class class$org$jfree$data$xy$XYDataset;
    static /* synthetic */ Class class$org$jfree$data$general$PieDataset;
    static /* synthetic */ Class class$org$jfree$data$category$CategoryDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$OHLCDataset;
    static /* synthetic */ Class class$org$jfree$data$category$IntervalCategoryDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$WindDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$SignalsDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$IntervalXYDataset;
    static /* synthetic */ Class class$org$jfree$data$general$ValueDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$XYZDataset;

    private CewolfChartFactory() {
    }

    private static final int getChartTypeConstant(String type) {
        int res = ChartTypes.typeList.indexOf(type.toLowerCase());
        if (res < 0) {
            throw new RuntimeException("unsupported axis type " + type);
        }
        return res;
    }

    private static final int getLayoutConstant(String layout) {
        return LayoutTypes.typeList.indexOf(layout.toLowerCase());
    }

    public static JFreeChart getChartInstance(String chartType, String title, String xAxisLabel, String yAxisLabel, Dataset data) throws ChartValidationException {
        switch (CewolfChartFactory.getChartTypeConstant(chartType)) {
            case 13: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$XYDataset == null ? (class$org$jfree$data$xy$XYDataset = CewolfChartFactory.class$("org.jfree.data.xy.XYDataset")) : class$org$jfree$data$xy$XYDataset, 13);
                return ChartFactory.createXYLineChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)((XYDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            case 5: {
                CewolfChartFactory.check(data, class$org$jfree$data$general$PieDataset == null ? (class$org$jfree$data$general$PieDataset = CewolfChartFactory.class$("org.jfree.data.general.PieDataset")) : class$org$jfree$data$general$PieDataset, 5);
                return ChartFactory.createPieChart((String)title, (PieDataset)((PieDataset)data), (boolean)true, (boolean)true, (boolean)true);
            }
            case 1: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$XYDataset == null ? (class$org$jfree$data$xy$XYDataset = CewolfChartFactory.class$("org.jfree.data.xy.XYDataset")) : class$org$jfree$data$xy$XYDataset, 1);
                return ChartFactory.createXYAreaChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)((XYDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 6: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$XYDataset == null ? (class$org$jfree$data$xy$XYDataset = CewolfChartFactory.class$("org.jfree.data.xy.XYDataset")) : class$org$jfree$data$xy$XYDataset, 6);
                return ChartFactory.createScatterPlot((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)((XYDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 0: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 0);
                return ChartFactory.createAreaChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 2: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 2);
                return ChartFactory.createBarChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 3: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 3);
                return ChartFactory.createBarChart3D((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 4: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 4);
                return ChartFactory.createLineChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 7: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 7);
                return ChartFactory.createStackedBarChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 8: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 8);
                return ChartFactory.createStackedBarChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 9: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 9);
                return ChartFactory.createStackedBarChart3D((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 11: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 11);
                return ChartFactory.createBarChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 12: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 12);
                return ChartFactory.createBarChart3D((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 10: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$XYDataset == null ? (class$org$jfree$data$xy$XYDataset = CewolfChartFactory.class$("org.jfree.data.xy.XYDataset")) : class$org$jfree$data$xy$XYDataset, 10);
                return ChartFactory.createTimeSeriesChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)((XYDataset)data), (boolean)true, (boolean)false, (boolean)false);
            }
            case 14: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$OHLCDataset == null ? (class$org$jfree$data$xy$OHLCDataset = CewolfChartFactory.class$("org.jfree.data.xy.OHLCDataset")) : class$org$jfree$data$xy$OHLCDataset, 14);
                return ChartFactory.createCandlestickChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (OHLCDataset)((OHLCDataset)data), (boolean)true);
            }
            case 15: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$OHLCDataset == null ? (class$org$jfree$data$xy$OHLCDataset = CewolfChartFactory.class$("org.jfree.data.xy.OHLCDataset")) : class$org$jfree$data$xy$OHLCDataset, 15);
                return ChartFactory.createHighLowChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (OHLCDataset)((OHLCDataset)data), (boolean)true);
            }
            case 16: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$IntervalCategoryDataset == null ? (class$org$jfree$data$category$IntervalCategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.IntervalCategoryDataset")) : class$org$jfree$data$category$IntervalCategoryDataset, 16);
                return ChartFactory.createGanttChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (IntervalCategoryDataset)((IntervalCategoryDataset)data), (boolean)true, (boolean)false, (boolean)false);
            }
            case 17: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$WindDataset == null ? (class$org$jfree$data$xy$WindDataset = CewolfChartFactory.class$("org.jfree.data.xy.WindDataset")) : class$org$jfree$data$xy$WindDataset, 17);
                return ChartFactory.createWindPlot((String)title, (String)xAxisLabel, (String)yAxisLabel, (WindDataset)((WindDataset)data), (boolean)true, (boolean)false, (boolean)false);
            }
            case 18: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$SignalsDataset == null ? (class$org$jfree$data$xy$SignalsDataset = CewolfChartFactory.class$("org.jfree.data.xy.SignalsDataset")) : class$org$jfree$data$xy$SignalsDataset, 18);
                return ChartFactory.createSignalChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (SignalsDataset)((SignalsDataset)data), (boolean)true);
            }
            case 19: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$IntervalXYDataset == null ? (class$org$jfree$data$xy$IntervalXYDataset = CewolfChartFactory.class$("org.jfree.data.xy.IntervalXYDataset")) : class$org$jfree$data$xy$IntervalXYDataset, 19);
                return ChartFactory.createXYBarChart((String)title, (String)xAxisLabel, (boolean)true, (String)yAxisLabel, (IntervalXYDataset)((IntervalXYDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 20: {
                CewolfChartFactory.check(data, class$org$jfree$data$general$PieDataset == null ? (class$org$jfree$data$general$PieDataset = CewolfChartFactory.class$("org.jfree.data.general.PieDataset")) : class$org$jfree$data$general$PieDataset, 20);
                return ChartFactory.createPieChart3D((String)title, (PieDataset)((PieDataset)data), (boolean)true, (boolean)false, (boolean)false);
            }
            case 24: {
                CewolfChartFactory.check(data, class$org$jfree$data$general$ValueDataset == null ? (class$org$jfree$data$general$ValueDataset = CewolfChartFactory.class$("org.jfree.data.general.ValueDataset")) : class$org$jfree$data$general$ValueDataset, 24);
                MeterPlot plot = new MeterPlot((ValueDataset)data);
                JFreeChart chart = new JFreeChart(title, (Plot)plot);
                return chart;
            }
            case 25: {
                CewolfChartFactory.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, 25);
                return ChartFactory.createStackedAreaChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case 26: {
                CewolfChartFactory.check(data, class$org$jfree$data$xy$XYZDataset == null ? (class$org$jfree$data$xy$XYZDataset = CewolfChartFactory.class$("org.jfree.data.xy.XYZDataset")) : class$org$jfree$data$xy$XYZDataset, 26);
                return ChartFactory.createBubbleChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYZDataset)((XYZDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
        }
        throw new UnsupportedChartTypeException(chartType + " is not supported.");
    }

    public static JFreeChart getOverlaidChartInstance(String chartType, String title, String xAxisLabel, String yAxisLabel, int xAxisType, int yAxisType, List plotDefinitions) throws ChartValidationException, DatasetProduceException {
        int chartTypeConst = CewolfChartFactory.getChartTypeConstant(chartType);
        switch (chartTypeConst) {
            case 21: {
                Assert.check(plotDefinitions.size() == 2, "an overlayXYChart may have exactly 2 datasets.\nYours has " + plotDefinitions.size());
                AxisFactory axisFactory = AxisFactory.getInstance();
                ValueAxis domainAxis = axisFactory.createAxis(0, xAxisType, xAxisLabel);
                PlotDefinition mainPlotDef = (PlotDefinition)plotDefinitions.get(0);
                CewolfChartFactory.check((Dataset)mainPlotDef.getDataset(), class$org$jfree$data$xy$XYDataset == null ? (class$org$jfree$data$xy$XYDataset = CewolfChartFactory.class$("org.jfree.data.xy.XYDataset")) : class$org$jfree$data$xy$XYDataset, 21);
                XYPlot plot = (XYPlot)mainPlotDef.getPlot(chartTypeConst);
                plot.setDomainAxis(domainAxis);
                plot.setRangeAxis(axisFactory.createAxis(1, yAxisType, yAxisLabel));
                PlotDefinition subPlotDef = (PlotDefinition)plotDefinitions.get(1);
                CewolfChartFactory.check((Dataset)subPlotDef.getDataset(), class$org$jfree$data$xy$XYDataset == null ? (class$org$jfree$data$xy$XYDataset = CewolfChartFactory.class$("org.jfree.data.xy.XYDataset")) : class$org$jfree$data$xy$XYDataset, 21);
                plot.setDataset(1, (XYDataset)subPlotDef.getDataset());
                String subPlotType = subPlotDef.getType();
                int rendererIndex = PlotTypes.typeList.indexOf(subPlotType.toLowerCase());
                if (rendererIndex < 0) {
                    throw new AttributeValidationException("plot.type", subPlotType);
                }
                XYItemRenderer rend = (XYItemRenderer)PlotTypes.rendererList.get(rendererIndex);
                plot.setRenderer(1, rend);
                return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            }
        }
        throw new UnsupportedChartTypeException(chartType + " is not supported.");
    }

    public static JFreeChart getCombinedChartInstance(String chartType, String title, String xAxisLabel, String yAxisLabel, List plotDefinitions, String layout) throws ChartValidationException, DatasetProduceException {
        int chartTypeConst = CewolfChartFactory.getChartTypeConstant(chartType);
        switch (chartTypeConst) {
            case 23: {
                int layoutConst = CewolfChartFactory.getLayoutConstant(layout);
                CombinedDomainXYPlot plot = null;
                switch (layoutConst) {
                    case 0: {
                        DateAxis domainAxis = new DateAxis(xAxisLabel);
                        plot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
                        for (int i = 0; i < plotDefinitions.size(); ++i) {
                            PlotDefinition pd = (PlotDefinition)plotDefinitions.get(i);
                            CewolfChartFactory.check((Dataset)pd.getDataset(), class$org$jfree$data$xy$XYDataset == null ? CewolfChartFactory.class$("org.jfree.data.xy.XYDataset") : class$org$jfree$data$xy$XYDataset, 23);
                            XYPlot temp = (XYPlot)pd.getPlot(chartTypeConst);
                            temp.setRangeAxis((ValueAxis)new NumberAxis(pd.getYaxislabel()));
                            plot.add(temp);
                        }
                        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                    }
                    case 1: {
                        NumberAxis rangeAxis = new NumberAxis(yAxisLabel);
                        plot = new CombinedRangeXYPlot((ValueAxis)rangeAxis);
                        for (int i = 0; i < plotDefinitions.size(); ++i) {
                            PlotDefinition pd = (PlotDefinition)plotDefinitions.get(i);
                            CewolfChartFactory.check((Dataset)pd.getDataset(), class$org$jfree$data$xy$XYDataset == null ? CewolfChartFactory.class$("org.jfree.data.xy.XYDataset") : class$org$jfree$data$xy$XYDataset, 23);
                            XYPlot temp = (XYPlot)pd.getPlot(chartTypeConst);
                            temp.setDomainAxis((ValueAxis)new DateAxis(pd.getXaxislabel()));
                            ((CombinedRangeXYPlot)plot).add(temp);
                        }
                        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                    }
                }
                throw new AttributeValidationException(layout, " any value");
            }
        }
        throw new UnsupportedChartTypeException(chartType);
    }

    private static void check(Dataset data, Class clazz, int chartType) throws IncompatibleDatasetException {
        if (!clazz.isInstance(data)) {
            throw new IncompatibleDatasetException("Charts of type " + ChartTypes.typeNames[chartType] + " " + "need datasets of type " + clazz.getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

