/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.Storage;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;

public class Configuration {
    public static final String KEY = (class$de$laures$cewolf$Configuration == null ? (class$de$laures$cewolf$Configuration = Configuration.class$("de.laures.cewolf.Configuration")) : class$de$laures$cewolf$Configuration).getName();
    private static final String DEFAULT_OVERLIB_URL = "overlib.js";
    private static final String DEFAULT_STORAGE = "de.laures.cewolf.storage.TransientSessionStorage";
    private static boolean configExists = false;
    private String overlibURL = "overlib.js";
    private boolean debugged = false;
    private String storageClassName = "de.laures.cewolf.storage.TransientSessionStorage";
    private Storage storage = null;
    static /* synthetic */ Class class$de$laures$cewolf$Configuration;

    Configuration(ServletConfig config) {
        ServletContext ctx = config.getServletContext();
        ctx.log("configuring cewolf app..");
        ctx.setAttribute(KEY, (Object)this);
        Enumeration initParams = config.getInitParameterNames();
        try {
            while (initParams.hasMoreElements()) {
                String param = (String)initParams.nextElement();
                String value = config.getInitParameter(param);
                if ("debug".equalsIgnoreCase(param)) {
                    this.debugged = Boolean.valueOf(value);
                    continue;
                }
                if ("overliburl".equalsIgnoreCase(param)) {
                    this.overlibURL = value;
                    continue;
                }
                if ("storage".equalsIgnoreCase(param)) {
                    this.storageClassName = value;
                    continue;
                }
                ctx.log(param + " parameter is ignored.");
            }
        }
        catch (Throwable t) {
            ctx.log("Error in Cewolf config.", t);
        }
        try {
            this.initStorage(ctx);
        }
        catch (CewolfException ex) {
            ctx.log("exception during storage init from class " + this.storageClassName);
            ctx.log("using de.laures.cewolf.storage.TransientSessionStorage");
            this.storageClassName = DEFAULT_STORAGE;
            try {
                this.initStorage(ctx);
            }
            catch (CewolfException cwex) {
                cwex.printStackTrace();
                throw new RuntimeException(this.storageClassName + ".init() threw exception.");
            }
        }
        ctx.log("using storage class " + this.storageClassName);
        ctx.log("using overlibURL " + this.overlibURL);
        ctx.log("debugging is turned " + (this.debugged ? "on" : "off"));
        ctx.log("...done.");
        configExists = true;
    }

    private void initStorage(ServletContext ctx) throws CewolfException {
        try {
            this.storage = (Storage)Class.forName(this.storageClassName).newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CewolfException(ex.getMessage());
        }
        this.storage.init(ctx);
    }

    private Configuration() {
    }

    public static Configuration getInstance(ServletContext ctx) {
        Configuration config = null;
        if (!Configuration.configurationExists()) {
            ctx.log("Cewolf Misconfiguration. You should add a <load-on-startup> tag to your web.xml for the Cewolf rendering servlet.\nA default Configuration will be used if not.");
            config = new Configuration();
            ctx.setAttribute(KEY, (Object)config);
        }
        config = (Configuration)ctx.getAttribute(KEY);
        return config;
    }

    public static boolean configurationExists() {
        return configExists;
    }

    public boolean isDebugged() {
        return this.debugged;
    }

    public String getOverlibURL() {
        return this.overlibURL;
    }

    public Storage getStorage() {
        return this.storage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

