/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.versionchecker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.versionchecker.VersionCheckResourceBundle;
import org.safehaus.uuid.EthernetAddress;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;

public class UUIDUtil {
    private static Log log = LogFactory.getLog(UUIDUtil.class);
    static boolean nativeInitialized = false;
    static UUIDGenerator ug;
    static EthernetAddress eAddr;

    static void init() {
        UUID olduuId;
        String macAddr;
        ug = UUIDGenerator.getInstance();
        if (eAddr == null && (macAddr = System.getProperty("MAC_ADDRESS")) != null) {
            macAddr = macAddr.replace('-', ':');
            eAddr = new EthernetAddress(macAddr);
        }
        if (eAddr == null) {
            eAddr = ug.getDummyAddress();
        }
        if ((olduuId = ug.generateTimeBasedUUID(eAddr)) == null) {
            log.error((Object)VersionCheckResourceBundle.getString("UUIDUtil.ERROR_0003_GENERATEFAILED"));
        }
    }

    public static String getUUIDAsString() {
        return UUIDUtil.getUUID().toString();
    }

    public static UUID getUUID() {
        UUID uuId = ug.generateTimeBasedUUID(eAddr);
        return uuId;
    }

    static {
        UUIDUtil.init();
    }
}

