/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle.pdi;

import org.pentaho.di.core.Props;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.gui.GUIOption;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginClassTypeMapping;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.versionchecker.BasicVersionCheckerProvider;
import org.pentaho.versionchecker.IVersionCheckDataProvider;
import org.pentaho.versionchecker.IVersionCheckErrorHandler;
import org.pentaho.versionchecker.IVersionCheckResultHandler;
import org.pentaho.versionchecker.VersionChecker;

@LifecyclePlugin(id="VersionChecker", name="Version checker")
@PluginClassTypeMapping(classTypes={GUIOption.class}, implementationClass={VersionCheckerListener.class})
public class VersionCheckerListener
implements LifecycleListener,
GUIOption<Boolean> {
    private static Class<?> PKG = VersionCheckerListener.class;
    private static final String PDI_CHECK_VERSION_FLAG = "pdi.check.version.flag";
    private LifecycleException root;
    private static LogChannelInterface log = new LogChannel((Object)"Version checker");
    public static final String VERSION_CHECKER = "Version Checker";

    public void onStart(LifeEventHandler handler) throws LifecycleException {
        String prop = Props.getInstance().getProperty(PDI_CHECK_VERSION_FLAG);
        if (prop != null && !Boolean.parseBoolean(prop)) {
            log.logBasic("Skipping version check.", new Object[0]);
            return;
        }
        try {
            Class.forName("org.pentaho.versionchecker.BasicVersionCheckerProvider");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BasicVersionCheckerProvider dataProvider = new BasicVersionCheckerProvider(Spoon.class);
                VersionChecker vc = new VersionChecker();
                vc.setDataProvider((IVersionCheckDataProvider)dataProvider);
                vc.addResultHandler(new IVersionCheckResultHandler(){

                    public void processResults(String result) {
                    }
                });
                vc.addErrorHandler(new IVersionCheckErrorHandler(){

                    public void handleException(Exception e) {
                        VersionCheckerListener.this.root = new LifecycleException((Throwable)e, false);
                    }
                });
                vc.performCheck(false);
                if (VersionCheckerListener.this.root != null) {
                    return;
                }
            }
        };
        new Thread(r).start();
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
    }

    public Boolean getLastValue() {
        String prop = Props.getInstance().getProperty(PDI_CHECK_VERSION_FLAG);
        return prop == null ? true : new Boolean(prop);
    }

    public void setValue(Boolean val) {
        Props.getInstance().setProperty(PDI_CHECK_VERSION_FLAG, val.toString());
    }

    public GUIOption.DisplayType getType() {
        return GUIOption.DisplayType.CHECK_BOX;
    }

    public String getLabelText() {
        return BaseMessages.getString(PKG, (String)"versioncheck.label.text", (String[])new String[0]);
    }
}

