/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.DateUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.superx.common.DBServletException;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultSet;
import de.superx.common.TranslationContainer;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtils {
    static final boolean isExtraAuthenticationCheckWanted = false;
    private static String path;
    public static Hashtable hash;

    static {
        hash = new Hashtable();
    }

    public static void setPath(String path) {
        ServletUtils.path = path;
    }

    public static String getPath() {
        return path;
    }

    public static String getMandantenID(HttpServletRequest request) {
        String mandantenID = null;
        if (ServletHelper.getParameter(request, "MandantenID") != null) {
            mandantenID = ServletHelper.getParameter(request, "MandantenID");
        }
        if (request.getAttribute("MandantenID") != null) {
            mandantenID = (String)request.getAttribute("MandantenID");
        }
        if (request.getSession() != null && request.getSession().getAttribute("MandantenID") != null) {
            mandantenID = (String)request.getSession().getAttribute("MandantenID");
        }
        if (mandantenID == null) {
            throw new IllegalStateException("Keine MandantenID gefunden. Muss bei einem Mandanten \"default\" sein");
        }
        return mandantenID;
    }

    static String getLocalizedStylesheet(String stil, Locale locale) {
        String localized_stil;
        File f2;
        int trunc_index;
        if (locale.getLanguage() != "de" && (trunc_index = stil.lastIndexOf(".xsl")) > 0 && (f2 = new File(localized_stil = String.valueOf(stil.substring(0, trunc_index)) + "_" + locale.getLanguage() + ".xsl")).exists()) {
            stil = localized_stil;
        }
        return stil;
    }

    static String getJSONErrorText(String user, Locale locale) {
        String s = "";
        s = String.valueOf(s) + "({error:\"" + StringUtils.jsonAdapt(String.valueOf(ServletUtils.get("superx.denied", locale)) + " '" + user + "'\n" + ServletUtils.get("superx.logintext", locale), true) + "\"})";
        return s;
    }

    static String getXmlErrorText(String fehler, String zs, Locale locale) {
        String s = "<html><head><link href=\"../xml/tabelle_html.css\" type=\"text/css\" REL=\"stylesheet\" /><head><body><h1>Ein Fehler ist bei der XML-Transformation aufgereten.</H1><p class=\"errmsg\">" + fehler + "</p>";
        s = String.valueOf(s) + "<p>Der XML-Code:<br /><TEXTAREA NAME=\"content\" ROWS=\"40\" COLS=\"80\" WRAP=\"on\" READONLY=\"true\">";
        s = String.valueOf(s) + zs + "</TEXTAREA></p></body></html>";
        return s;
    }

    public static String getLoginFailureXml(String user, String mandantenid, Locale locale) {
        String s = "<nachricht><p class=\"errmsg\">" + ServletUtils.get("superx.denied", locale) + " " + user + "</p><p>";
        s = String.valueOf(s) + ServletUtils.get("superx.logintext", locale);
        if (SuperXManager.isXMLReturnLinkWanted) {
            s = mandantenid != null && !mandantenid.equalsIgnoreCase("null") && !mandantenid.equalsIgnoreCase("default") ? String.valueOf(s) + "<br /><a href=\"../" + mandantenid + "/xml/index.htm\" target=\"_parent\">" + ServletUtils.get("superx.login", locale) + "</a></p>" : String.valueOf(s) + "<br /><a href=\"../xml/index.htm\" target=\"_parent\">" + ServletUtils.get("superx.login", locale) + "</a></p>";
        }
        s = String.valueOf(s) + "</nachricht>";
        return s;
    }

    static String get(String what, Locale locale) {
        String r;
        if (locale == null) {
            locale = TranslationContainer.defaultLocale;
        }
        ResourceBundle bundle = null;
        if (hash != null) {
            bundle = (ResourceBundle)hash.get(locale.getLanguage());
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("LocalStrings", locale);
            hash.put(bundle, locale.getLanguage());
        }
        if ((r = bundle.getString(what)) == null) {
            r = "Unknown Local String: " + what;
        }
        return r;
    }

    public static String escapeTimeFeld(String feldwert) throws ParseException {
        String charcode1 = "'";
        String charcode2 = "'";
        if (feldwert.startsWith(charcode1) && feldwert.endsWith(charcode1)) {
            feldwert = feldwert.substring(2, feldwert.length() - 1);
        }
        SimpleDateFormat in_df = new SimpleDateFormat("HH:mm:ss");
        Date feldwert_df = in_df.parse(feldwert);
        SimpleDateFormat out_df = new SimpleDateFormat("HH:mm:ss");
        feldwert = out_df.format(feldwert_df);
        feldwert = String.valueOf(charcode1) + feldwert + charcode2;
        return feldwert;
    }

    public static String escapeTimestampFeld(String feldwert) throws ParseException {
        SimpleDateFormat in_df;
        Date feldwert_df;
        SimpleDateFormat out_df;
        String charcode1 = "'";
        String charcode2 = "'";
        if (feldwert.startsWith(charcode1) && feldwert.endsWith(charcode1)) {
            feldwert = feldwert.substring(2, feldwert.length() - 1);
        }
        if ((feldwert = (out_df = new SimpleDateFormat("d.M.yyyy HH:mm:ss")).format(feldwert_df = (in_df = new SimpleDateFormat("d.M.yyyy HH:mm:ss")).parse(feldwert))).length() > 0) {
            feldwert = String.valueOf(charcode1) + feldwert + charcode2;
        }
        return feldwert;
    }

    public static String escapeDateFeld(String feldwert) throws ParseException {
        String charcode1 = "'";
        String charcode2 = "'";
        if (feldwert.startsWith(charcode1) && feldwert.endsWith(charcode1)) {
            feldwert = feldwert.substring(1, feldwert.length() - 1);
        }
        if (feldwert.length() > 0) {
            feldwert = feldwert.equals("--leer--") ? "''" : String.valueOf(charcode1) + feldwert + charcode2;
        }
        return feldwert;
    }

    public static String escapeCharFeld(String feldwert) {
        String charcode1 = "'";
        String charcode2 = "'";
        if (feldwert.startsWith(charcode1) && feldwert.endsWith(charcode1)) {
            feldwert = feldwert.substring(2, feldwert.length() - 1);
        }
        if ((feldwert = SqlStringUtils.escapeString(feldwert)).length() > 0 && SqlStringUtils.unescapeString(feldwert).equals("--leer--")) {
            feldwert = "";
        }
        return feldwert;
    }

    public static SxResultSet execute(String task, String query, String mandantenID) throws SQLException, DBServletException {
        return ServletUtils.execute_el(task, query, true, mandantenID).getResultSet();
    }

    public static SuperX_el execute_el(String task, String query, boolean isSingleQuery, String mandantenID) throws SQLException, DBServletException {
        SuperX_el result_el = new SuperX_el();
        Connection dbConnection = SxPools.getConnection(mandantenID);
        try {
            SxSQL_Server sxServer = new SxSQL_Server(mandantenID);
            if (isSingleQuery) {
                sxServer.executeQuery(query, dbConnection, result_el);
            } else {
                sxServer.execute(query, dbConnection, result_el);
            }
            dbConnection.close();
        }
        catch (SQLException e2) {
            String msg = "Problem bei:" + task + " Meldung:" + e2.toString() + " sql:" + query;
            Logger.getLogger("superx_" + mandantenID).log(Level.SEVERE, msg);
            SxPools.invalidate(mandantenID, dbConnection);
            throw new SQLException(msg);
        }
        if (result_el.getError_String() != null && !result_el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei:" + task + "\n\n  Meldung:" + result_el.getError_String() + "\n  sql:" + query);
        }
        return result_el;
    }

    public static SuperX_el executeALL_el(String task, String query, String mandantenID, boolean isStacktraceWanted) throws SQLException, DBServletException {
        if (task.startsWith("Abfrage Maske")) {
            SuperXManager.setLastMaskenSql("--" + task + " " + DateUtils.getNowString() + "\n" + query);
        }
        SuperX_el result_el = new SuperX_el();
        Connection dbConnection = SxPools.getConnection(mandantenID);
        try {
            SxSQL_Server sxServer = new SxSQL_Server(mandantenID);
            sxServer.executeALL(query, dbConnection, result_el);
            dbConnection.close();
        }
        catch (SQLException e2) {
            SxPools.invalidate(mandantenID, dbConnection);
            String msg = "Problem bei:" + task + "\nMeldung:" + e2.toString();
            Logger.getLogger("superx_" + mandantenID).log(Level.SEVERE, msg);
            if (isStacktraceWanted) {
                e2.printStackTrace();
            }
            throw new SQLException(msg);
        }
        catch (Exception e3) {
            SxPools.invalidate(mandantenID, dbConnection);
            String msg = "Problem bei:" + task + " Meldung:" + e3.toString() + " sql:" + query;
            Logger.getLogger("superx_" + mandantenID).log(Level.SEVERE, msg);
            if (isStacktraceWanted) {
                e3.printStackTrace();
            }
            throw new DBServletException(msg);
        }
        if (result_el.getError_String() != null && !result_el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei:" + task + "\n\n  Meldung:" + result_el.getError_String() + "\n  sql:" + query);
        }
        return result_el;
    }

    public static void checkParams(HttpServletRequest request) {
        StringBuffer test = new StringBuffer();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            test.append(String.valueOf(element) + " - " + request.getParameter(element) + "\n");
            if (request.getParameter(element) == null || request.getParameter(element).indexOf("'") <= -1) continue;
            boolean bl = true;
        }
    }

    public static void addToFormular(HttpServletRequest request, Hashtable formular) {
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String aName = (String)en.nextElement();
            String val = ServletHelper.getParameter(request, aName);
            if (val != null) {
                val = val.replace(';', '^');
            }
            if (val != null && val.equals("--leer--")) {
                val = "";
            }
            formular.put(aName, val);
        }
    }

    public static void sendBackHtml(HttpServletResponse response, String info) throws IOException {
        PrintWriter output = response.getWriter();
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        output.write(info);
        output.flush();
        output.close();
    }
}

