/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.MemoryUtils;
import de.memtext.util.StringUtils;
import de.superx.bin.SxDBUtils;
import de.superx.util.SqlStringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.jfor.jfor.converter.Converter;
import org.jfor.jfor.converter.IConverterOption;
import org.xml.sax.InputSource;

public class SxTransformer {
    private String head_delim1 = "";
    private String head_delim2 = "\t";
    private String header_delim1 = "";
    private String header_delim2 = "\n";
    private String fld_delim1 = "";
    private String fld_delim2 = "\t";
    private String row_delim1 = "";
    private String row_delim2 = "\n";
    private String rs_delim1 = "";
    private String rs_delim2 = "";
    private String delim = "\t";
    private String header = "false";
    private String outHeader = "";
    private String outFooter = "";
    public String format = "txt";
    public String params = "";
    public String[] XslPipeline;
    public String stylesheet = "";
    public PrintWriter myOutwriter;
    public OutputStream myOutputStream;
    public ResultSet outrs = null;
    public ResultSetMetaData outrsmd = null;
    public String quellstring = null;
    public String outfile = "";
    Logger myLogger;
    String loglevel;

    public SxTransformer(Logger logger, PrintStream myStream) {
        this.myLogger = logger;
        this.myLogger.config("Starting the Transformer with Stdout-Output.");
        this.myOutwriter = new PrintWriter(myStream);
    }

    public SxTransformer(Logger logger, String myFile) {
        this.myLogger = logger;
        this.myLogger.config("Starting the Transformer with File-Output.");
        this.outfile = myFile;
        this.myLogger.setLevel(Level.SEVERE);
    }

    public SxTransformer(Logger logger, FileWriter myFilewriter) {
        this.myLogger = logger;
        this.myLogger.config("Starting the Transformer with File-Output.");
        this.myOutwriter = new PrintWriter(new BufferedWriter(myFilewriter));
    }

    public SxTransformer(Logger logger) {
        this.myLogger = logger;
        this.myLogger.config("Starting the Transformer without Stream");
    }

    public void printResult(String outFormat) {
        this.assignDelims(outFormat);
        this.myLogger.config("Resultset wird formatiert");
        String f_wert = "";
        String zs = "";
        String headZs = "";
        int cols = 0;
        Object o = null;
        String[] lbl = null;
        int[] types = new int[255];
        System.gc();
        if (this.outrs != null) {
            try {
                cols = this.outrsmd.getColumnCount();
                lbl = new String[255];
                zs = String.valueOf(this.outHeader) + this.rs_delim1;
                headZs = this.header_delim1;
                int i2 = 1;
                while (i2 <= cols) {
                    lbl[i2] = this.outrsmd.getColumnLabel(i2);
                    types[i2] = this.outrsmd.getColumnType(i2);
                    if (outFormat.equals("xml")) {
                        this.fld_delim1 = "<fld name='" + lbl[i2] + "'>";
                        this.fld_delim2 = "</fld>";
                    } else if (i2 < cols) {
                        headZs = String.valueOf(headZs) + this.head_delim1 + lbl[i2] + this.head_delim2;
                    } else {
                        headZs = String.valueOf(headZs) + this.head_delim1 + lbl[i2] + this.head_delim2;
                        headZs = String.valueOf(headZs) + this.header_delim2;
                    }
                    ++i2;
                }
            }
            catch (SQLException e1) {
                this.myLogger.severe("Fehler beim Einlesen der Feldnamen: " + e1.toString());
                e1.printStackTrace();
            }
            if (this.header.equals("true")) {
                zs = String.valueOf(zs) + headZs;
            }
            this.myOutwriter.write(zs);
            this.myOutwriter.flush();
            StringBuffer line = new StringBuffer();
            try {
                int rowCounter = 0;
                while (this.outrs.next()) {
                    line.setLength(0);
                    line.append(this.row_delim1);
                    int i3 = 1;
                    while (i3 <= cols) {
                        if (outFormat.equals("xml")) {
                            this.fld_delim1 = "<fld name='" + lbl[i3] + "'>";
                            this.fld_delim2 = "</fld>";
                        }
                        o = types[i3] == -1 ? this.outrs.getString(i3) : this.outrs.getObject(i3);
                        if (this.outrs.wasNull()) {
                            if (i3 < cols) {
                                line.append(String.valueOf(this.fld_delim1) + this.fld_delim2);
                            } else {
                                line.append(String.valueOf(this.fld_delim1) + this.fld_delim2);
                                line.append(this.row_delim2);
                            }
                        } else {
                            f_wert = SxDBUtils.field_value(o);
                            if (outFormat.equals("xml") && (f_wert.indexOf("&") > -1 || f_wert.indexOf("<") > -1 || f_wert.indexOf(">") > -1)) {
                                f_wert = "<![CDATA[" + f_wert + "]]>";
                            }
                            if (outFormat.equals("txt") && f_wert != null && f_wert.indexOf("\\n") > -1) {
                                f_wert = StringUtils.replace(f_wert, "\\n", "\\\\n");
                            }
                            if (outFormat.equals("txt") && f_wert != null && f_wert.indexOf(this.fld_delim2) > -1) {
                                f_wert = StringUtils.replace(f_wert, this.fld_delim2, "\\" + this.fld_delim2);
                            }
                            if (i3 < cols) {
                                line.append(String.valueOf(this.fld_delim1) + f_wert + this.fld_delim2);
                            } else {
                                line.append(String.valueOf(this.fld_delim1) + f_wert + this.fld_delim2);
                                line.append(this.row_delim2);
                            }
                        }
                        ++i3;
                    }
                    this.myOutwriter.write(line.toString());
                    if (++rowCounter <= 10000) continue;
                    System.gc();
                    MemoryUtils.printfree();
                    this.myOutwriter.flush();
                    rowCounter = 0;
                }
                this.myOutwriter.write(String.valueOf(this.rs_delim2) + this.outFooter);
                this.myOutwriter.flush();
                this.outrs.close();
                this.myOutwriter.close();
            }
            catch (SQLException e2) {
                this.myLogger.warning("SQL-Fehler beim Ausgeben der Feldwerte: " + e2.toString());
                try {
                    this.myOutwriter.write(String.valueOf(this.rs_delim2) + this.outFooter);
                    this.myOutwriter.flush();
                    this.myOutwriter.close();
                    this.outrs.close();
                }
                catch (SQLException e1) {
                    this.myLogger.warning("SQL-Fehler beim Ausgeben der Feldwerte: " + e1.toString());
                }
            }
        } else {
            this.myOutwriter.flush();
            this.myOutwriter.close();
        }
        this.myLogger.info("resultset printed");
    }

    public void transformString(String methode) throws TransformerException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(this.stylesheet));
            StringReader s1 = new StringReader(this.quellstring);
            transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
            transformer.setOutputProperty("method", methode);
            transformer.setParameter("sx_client", this.format);
            Object result = null;
            if (!this.params.endsWith(",")) {
                this.params = String.valueOf(this.params) + ",";
            }
            StringTokenizer st = new StringTokenizer(this.params, ",");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                if (param.equals("")) continue;
                String paramname = param.substring(0, param.indexOf("="));
                String paramvalue = param.substring(param.indexOf("=") + 1, param.length());
                transformer.setParameter(paramname, paramvalue);
            }
            transformer.transform(new StreamSource(s1), new StreamResult(this.myOutwriter));
        }
        catch (Exception e2) {
            this.myLogger.severe("XSL-Transformation fehlgeschlagen: " + e2.toString());
        }
    }

    public void transformFile(String methode) throws TransformerException, Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(this.stylesheet));
        transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        transformer.setOutputProperty("method", methode);
        transformer.setParameter("sx_client", this.format);
        transformer.setParameter("versionParam", "2.0");
        if (!this.params.endsWith(",")) {
            this.params = String.valueOf(this.params) + ",";
        }
        StringTokenizer st = new StringTokenizer(this.params, ",");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            if (param.equals("")) continue;
            String paramname = param.substring(0, param.indexOf("="));
            String paramvalue = param.substring(param.indexOf("=") + 1, param.length());
            transformer.setParameter(paramname, paramvalue);
        }
        if (methode.equals("pdf")) {
            Level logLevel = this.myLogger.getParent().getLevel();
            this.myLogger.getParent().setLevel(Level.SEVERE);
            FopFactory fopFactory = FopFactory.newInstance();
            fopFactory.setStrictValidation(false);
            fopFactory.setSourceResolution(96);
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            URL cfgFolder = this.getClass().getResource("SxTransformer.class");
            try {
                Configuration cfg = cfgBuilder.buildFromFile(new File(String.valueOf(cfgFolder.getPath()) + File.separator + ".." + File.separator + "fop.xconf"));
                fopFactory.setUserConfig(cfg);
                File fontRoot = new File(cfgFolder + File.separator + "fonts");
                try {
                    System.out.println("Setting font folder to " + fontRoot.toURI().toURL().toExternalForm());
                    fopFactory.setFontBaseURL(fontRoot.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e3) {
                this.myLogger.warning("fop.xconf kann nicht geladen werden:" + e3.toString());
            }
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            try {
                this.myOutputStream = new FileOutputStream(this.outfile);
            }
            catch (FileNotFoundException e4) {
                this.myLogger.severe("Ausgabedatei " + this.outfile + " kann nicht erzeugt werden:" + e4.toString());
                System.exit(-1);
            }
            try {
                try {
                    Fop fop = fopFactory.newFop("application/pdf", foUserAgent, this.myOutputStream);
                    StreamSource src = new StreamSource(this.quellstring);
                    SAXResult res = new SAXResult(fop.getDefaultHandler());
                    try {
                        transformer.transform(src, res);
                        System.out.println("Success!");
                    }
                    catch (TransformerException ex) {
                        throw new Exception(ex);
                    }
                }
                catch (Exception e5) {
                    e5.printStackTrace(System.err);
                    this.myLogger.severe("FOP-Transformation Fehler: " + e5.toString());
                    this.myOutputStream.close();
                    this.myLogger.getParent().setLevel(logLevel);
                }
            }
            finally {
                this.myOutputStream.close();
                this.myLogger.getParent().setLevel(logLevel);
            }
        } else if (methode.equals("rtf")) {
            String zielstring = "";
            this.myLogger.info("Ausgabedatei " + this.outfile + " vorbereiten");
            BufferedWriter myWriter = null;
            try {
                myWriter = new BufferedWriter(new FileWriter(this.outfile));
            }
            catch (IOException e6) {
                e6.printStackTrace();
            }
            try {
                this.myLogger.info("Transformiere nach fo ");
                transformer.transform(new StreamSource(this.quellstring), new StreamResult("tmp.fo"));
                this.myLogger.info("Transformiere nach rtf ");
                new Converter(new InputSource("tmp.fo"), (Writer)myWriter, (IConverterOption)Converter.createConverterOption());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            try {
                FileWriter myFile = new FileWriter(this.outfile);
                this.myOutwriter = new PrintWriter(myFile);
                transformer.transform(new StreamSource(this.quellstring), new StreamResult(this.myOutwriter));
            }
            catch (IOException e7) {
                this.myLogger.severe("Datei " + this.outfile + " kann nicht erzeugt werden: " + e7.toString());
            }
            catch (TransformerException e8) {
                this.myLogger.severe("Datei " + this.outfile + " kann nicht transformiert werden: " + e8.toString());
            }
        }
    }

    public void outputString() {
        BufferedWriter out = new BufferedWriter(this.myOutwriter);
        try {
            out.write(this.quellstring);
            out.flush();
        }
        catch (IOException e2) {
            this.myLogger.severe("Fehler beim Ausgeben des Ergebnisses: " + e2.toString());
        }
    }

    public String getResult(String outFormat) throws SQLException {
        this.assignDelims(outFormat);
        this.myLogger.config("Resultset wird formatiert");
        String f_wert = "";
        int cols = this.outrsmd.getColumnCount();
        String[] lbl = new String[255];
        String zs = this.rs_delim1;
        String headZs = this.header_delim1;
        int i2 = 1;
        while (i2 <= cols) {
            lbl[i2] = this.outrsmd.getColumnLabel(i2);
            if (outFormat.equals("xml")) {
                this.fld_delim1 = "<fld name='" + lbl[i2].toLowerCase() + "'>";
                this.fld_delim2 = "</fld>";
            } else if (i2 < cols) {
                headZs = String.valueOf(headZs) + this.head_delim1 + lbl[i2] + this.head_delim2;
            } else {
                headZs = String.valueOf(headZs) + this.head_delim1 + lbl[i2] + this.head_delim2;
                headZs = String.valueOf(headZs) + this.header_delim2;
            }
            ++i2;
        }
        if (this.header.equals("true")) {
            zs = String.valueOf(zs) + headZs;
        }
        try {
            while (this.outrs.next()) {
                zs = String.valueOf(zs) + this.row_delim1;
                i2 = 1;
                while (i2 <= cols) {
                    Object o = this.outrs.getObject(i2);
                    f_wert = SxDBUtils.field_value(o);
                    if (outFormat.equals("xml")) {
                        this.fld_delim1 = "<fld name='" + lbl[i2].toLowerCase() + "'>";
                        this.fld_delim2 = "</fld>\n";
                    }
                    if (this.outrs.wasNull()) {
                        if (i2 < cols) {
                            zs = String.valueOf(zs) + this.fld_delim1 + this.fld_delim2;
                        } else {
                            zs = String.valueOf(zs) + this.fld_delim1 + this.fld_delim2;
                            zs = String.valueOf(zs) + this.row_delim2;
                        }
                    } else if (i2 < cols) {
                        zs = String.valueOf(zs) + this.fld_delim1 + f_wert.trim() + this.fld_delim2;
                    } else {
                        zs = String.valueOf(zs) + this.fld_delim1 + f_wert.trim() + this.fld_delim2;
                        zs = String.valueOf(zs) + this.row_delim2;
                    }
                    ++i2;
                }
            }
            zs = String.valueOf(zs) + this.rs_delim2;
        }
        catch (Exception e2) {
            this.myLogger.severe("Fehler beim Ausgeben der Feldwerte: " + e2.toString());
        }
        this.outrs.close();
        return zs;
    }

    private void assignDelims(String outFormat) {
        if (outFormat.equals("html")) {
            this.outHeader = "<html><body>";
            this.outFooter = "</body></html>";
            this.rs_delim1 = "<table border='1'>\n";
            this.rs_delim2 = "</table>";
            this.head_delim1 = "<th>";
            this.head_delim2 = "</th>";
            this.header_delim1 = "<tr>";
            this.header_delim2 = "</tr>\n";
            this.row_delim1 = "<tr>";
            this.row_delim2 = "</tr>";
            this.fld_delim1 = "<td>";
            this.fld_delim2 = "</td>";
        }
        if (outFormat.equals("xml")) {
            this.outHeader = "<?xml version='1.0' encoding='" + SqlStringUtils.getEncoding() + "'?>";
            this.outFooter = "";
            this.rs_delim1 = "<rs>\n";
            this.rs_delim2 = "</rs>";
            this.head_delim1 = "";
            this.head_delim2 = "";
            this.header_delim1 = "";
            this.header_delim2 = "";
            this.row_delim1 = "<row>\n";
            this.row_delim2 = "</row>\n";
            this.fld_delim1 = "";
            this.fld_delim2 = "";
        }
    }

    public String getDelim() {
        return this.delim;
    }

    public String getFld_delim1() {
        return this.fld_delim1;
    }

    public String getFld_delim2() {
        return this.fld_delim2;
    }

    public String getFormat() {
        return this.format;
    }

    public String getHead_delim1() {
        return this.head_delim1;
    }

    public String getHead_delim2() {
        return this.head_delim2;
    }

    public String getHeader() {
        return this.header;
    }

    public String getHeader_delim1() {
        return this.header_delim1;
    }

    public String getHeader_delim2() {
        return this.header_delim2;
    }

    public ResultSet getOutrs() {
        return this.outrs;
    }

    public ResultSetMetaData getOutrsmd() {
        return this.outrsmd;
    }

    public String getRow_delim1() {
        return this.row_delim1;
    }

    public String getRow_delim2() {
        return this.row_delim2;
    }

    public String getRs_delim1() {
        return this.rs_delim1;
    }

    public String getRs_delim2() {
        return this.rs_delim2;
    }

    public String[] getXslPipeline() {
        return this.XslPipeline;
    }

    public void setDelim(String string) {
        this.delim = string;
        this.fld_delim1 = "";
        this.fld_delim2 = string;
        this.head_delim2 = string;
    }

    public void setFld_delim1(String string) {
        this.fld_delim1 = string;
    }

    public void setFld_delim2(String string) {
        this.fld_delim2 = string;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setHead_delim1(String string) {
        this.head_delim1 = string;
    }

    public void setHead_delim2(String string) {
        this.head_delim2 = string;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public void setHeader_delim1(String string) {
        this.header_delim1 = string;
    }

    public void setHeader_delim2(String string) {
        this.header_delim2 = string;
    }

    public void setOutrs(ResultSet set) {
        this.outrs = set;
    }

    public void setOutrsmd(ResultSetMetaData data) {
        this.outrsmd = data;
    }

    public void setRow_delim1(String string) {
        this.row_delim1 = string;
    }

    public void setRow_delim2(String string) {
        this.row_delim2 = string;
    }

    public void setRs_delim1(String string) {
        this.rs_delim1 = string;
    }

    public void setRs_delim2(String string) {
        this.rs_delim2 = string;
    }

    public void setXslPipeline(String[] strings) {
        this.XslPipeline = strings;
    }

    public String getOutFooter() {
        return this.outFooter;
    }

    public String getOutHeader() {
        return this.outHeader;
    }

    public void setOutFooter(String string) {
        this.outFooter = string;
    }

    public void setOutHeader(String string) {
        this.outHeader = string;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String string) {
        this.params = string;
    }

    public static void main(String[] args) throws Exception {
        Logger log = Logger.getLogger(SxTransformer.class.getName());
        String rootDir = "/home/superx/tmp/";
        String quelle = String.valueOf(rootDir) + "Buchungsbericht_ids_Test.xml";
        String zielFile = String.valueOf(rootDir) + "testneu.pdf";
        String sxlSheet = "/home/superx/dev/edustore/webserver/tomcat/webapps/superx/xml/tabelle_fo_pdf.xsl";
        SxTransformer sxTrans = new SxTransformer(log, zielFile);
        sxTrans.quellstring = quelle;
        sxTrans.outfile = zielFile;
        sxTrans.stylesheet = sxlSheet;
        sxTrans.transformFile("pdf");
    }
}

