/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.ParseException;
import java.util.List;

public abstract class Parameter {
    private String id = null;
    private String usageName = null;
    private boolean locked = false;
    private String[] defaultValue = null;
    private String help = null;

    public Parameter(String string) {
        this.id = string;
    }

    public String getID() {
        return this.id;
    }

    protected final void setLocked(boolean bl) {
        this.locked = bl;
    }

    protected final boolean locked() {
        return this.locked;
    }

    protected final void enforceParameterLock() {
        if (this.locked) {
            throw new IllegalStateException("Parameter '" + this.getID() + "' may not be changed.");
        }
    }

    protected final void _setDefault(String string) {
        if (string == JSAP.NO_DEFAULT) {
            this.defaultValue = null;
        } else {
            this.defaultValue = new String[1];
            this.defaultValue[0] = string;
        }
    }

    protected final void _setDefault(String[] stringArray) {
        this.defaultValue = stringArray;
    }

    public final void addDefault(String string) {
        if (string != JSAP.NO_DEFAULT) {
            if (this.defaultValue == null) {
                this.defaultValue = new String[0];
            }
            int n = this.defaultValue.length + 1;
            String[] stringArray = new String[n];
            for (int i2 = 0; i2 < n - 1; ++i2) {
                stringArray[i2] = this.defaultValue[i2];
            }
            stringArray[n - 1] = string;
            this.defaultValue = stringArray;
        }
    }

    protected final void _setUsageName(String string) {
        this.usageName = string;
    }

    public final String getUsageName() {
        return this.usageName == null ? this.id : this.usageName;
    }

    public final String[] getDefault() {
        return this.defaultValue;
    }

    protected abstract List parse(String var1) throws ParseException;

    public abstract String getSyntax();

    public final String getUsage() {
        return this.getSyntax();
    }

    public final String getHelp() {
        return this.help == null ? "" : this.help;
    }

    public final Parameter setHelp(String string) {
        this.help = string;
        return this;
    }
}

