/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class LookUpSwitchInstruction
extends SwitchInstruction {
    public int[] cases;

    public LookUpSwitchInstruction() {
    }

    public LookUpSwitchInstruction(byte by, int n, int[] nArray, int[] nArray2) {
        this.opcode = by;
        this.defaultOffset = n;
        this.cases = nArray;
        this.jumpOffsets = nArray2;
    }

    public LookUpSwitchInstruction copy(LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.opcode = lookUpSwitchInstruction.opcode;
        this.defaultOffset = lookUpSwitchInstruction.defaultOffset;
        this.cases = lookUpSwitchInstruction.cases;
        this.jumpOffsets = lookUpSwitchInstruction.jumpOffsets;
        return this;
    }

    public Instruction shrink() {
        return this;
    }

    protected void readInfo(byte[] byArray, int n) {
        n += -n & 3;
        this.defaultOffset = LookUpSwitchInstruction.readInt(byArray, n);
        int n2 = LookUpSwitchInstruction.readInt(byArray, n += 4);
        n += 4;
        this.cases = new int[n2];
        this.jumpOffsets = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.cases[i] = LookUpSwitchInstruction.readInt(byArray, n);
            this.jumpOffsets[i] = LookUpSwitchInstruction.readInt(byArray, n += 4);
            n += 4;
        }
    }

    protected void writeInfo(byte[] byArray, int n) {
        while ((n & 3) != 0) {
            LookUpSwitchInstruction.writeByte(byArray, n++, 0);
        }
        LookUpSwitchInstruction.writeInt(byArray, n, this.defaultOffset);
        LookUpSwitchInstruction.writeInt(byArray, n += 4, this.cases.length);
        n += 4;
        for (int i = 0; i < this.cases.length; ++i) {
            LookUpSwitchInstruction.writeInt(byArray, n, this.cases[i]);
            LookUpSwitchInstruction.writeInt(byArray, n += 4, this.jumpOffsets[i]);
            n += 4;
        }
    }

    public int length(int n) {
        return 1 + (-(n + 1) & 3) + 8 + this.cases.length * 8;
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitLookUpSwitchInstruction(clazz, method, codeAttribute, n, this);
    }
}

