/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util.jrcharts.boxplot;

import java.awt.Font;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.renderers.JCommonDrawableRenderer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.ui.Drawable;

public class JFreeChartBoxPlotScriptlet
extends JRDefaultScriptlet {
    public void afterReportInit() throws JRScriptletException {
        BoxAndWhiskerCategoryDataset dataset = this.createSampleDataset();
        CategoryAxis xAxis = new CategoryAxis("Type");
        NumberAxis yAxis = new NumberAxis("Value");
        yAxis.setAutoRangeIncludesZero(false);
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setFillBox(false);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)new BoxAndWhiskerToolTipGenerator());
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        JFreeChart chart = new JFreeChart("Box-and-Whisker Demo", new Font("SansSerif", 1, 14), (Plot)plot, true);
        this.setVariableValue("Chart", new JCommonDrawableRenderer((Drawable)chart));
    }

    private BoxAndWhiskerCategoryDataset createSampleDataset() {
        int seriesCount = 3;
        int categoryCount = 4;
        int entityCount = 22;
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                ArrayList<Double> list = new ArrayList<Double>();
                for (int k = 0; k < 22; ++k) {
                    double value1 = 10.0 + Math.random() * 3.0;
                    list.add(value1);
                    double value2 = 11.25 + Math.random();
                    list.add(value2);
                }
                dataset.add(list, (Comparable)((Object)("Series " + i)), (Comparable)((Object)(" Type " + j)));
            }
        }
        return dataset;
    }
}

